/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.impl;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollEventListener;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.processor.I18NActivityUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class PollSpaceActivityPublisher
extends PollEventListener {
    public static final String POLL_APP_ID = "ks-poll:spaces";
    public static final String POLL_COMMENT_APP_ID = "poll:spaces";
    private static final Log LOG = ExoLogger.getExoLogger(PollSpaceActivityPublisher.class);
    public static final String POLL_PARENT = "PollLink";
    public static final String POLL_LINK = "Link";
    public static final String UPDATE_POLL_TITLE_ID = "update_poll";
    public static final String SPACE_GROUP_ID = "SpaceGroupId";
    public static final String POLL_ID = "Id";

    private ExoSocialActivity activity(Identity author, String title, String body, Map<String, String> templateParams) throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId(author.getId());
        activity.setTitle(CommonUtils.decodeSpecialCharToHTMLnumber((String)title));
        activity.setBody(body);
        activity.setType(POLL_APP_ID);
        activity.setTemplateParams(templateParams);
        return activity;
    }

    private ExoSocialActivity createComment() {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("Poll has been updated.");
        comment.setType(POLL_COMMENT_APP_ID);
        I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)UPDATE_POLL_TITLE_ID, (String[])new String[0]);
        return comment;
    }

    private String getCurrentUserId() {
        ConversationState state = ConversationState.getCurrent();
        String currentUserId = null;
        if (state != null) {
            currentUserId = state.getIdentity().getUserId();
        }
        return currentUserId;
    }

    private void savePollForActivity(Poll poll, boolean isNew, boolean isVote) {
        PollService pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        try {
            Identity pollOwnerIdentity = identityManager.getOrCreateIdentity("organization", poll.getOwner(), false);
            HashMap<String, String> templateParams = new HashMap<String, String>();
            String pollPath = poll.getParentPath() + "/" + poll.getId();
            String activityId = pollService.getActivityIdForOwner(pollPath);
            if (activityId != null) {
                ExoSocialActivity activity = this.getManager().getActivity(activityId);
                if (activity != null) {
                    poll.setInfoVote();
                    activity.setBody(org.exoplatform.poll.service.Utils.getInfoVote((Poll)poll));
                    activity.setTitle(CommonUtils.decodeSpecialCharToHTMLnumber((String)poll.getQuestion()));
                    this.getManager().updateActivity(activity);
                    if (!isVote) {
                        ExoSocialActivity comment = this.createComment();
                        String userId = this.getCurrentUserId();
                        if (userId != null && !userId.equals(pollOwnerIdentity.getRemoteId())) {
                            Identity currentIdentity = identityManager.getOrCreateIdentity("organization", userId, false);
                            comment.setUserId(currentIdentity.getId());
                        } else {
                            comment.setUserId(pollOwnerIdentity.getId());
                        }
                        this.getManager().saveComment(activity, comment);
                    }
                } else {
                    activityId = null;
                    poll.setInfoVote();
                }
            }
            if (activityId == null) {
                ExoSocialActivity newActivity = this.activity(pollOwnerIdentity, poll.getQuestion(), org.exoplatform.poll.service.Utils.getInfoVote((Poll)poll), templateParams);
                Identity spaceIdentity = this.getSpaceIdentity(poll);
                if (spaceIdentity != null) {
                    pollOwnerIdentity = spaceIdentity;
                    templateParams.put(SPACE_GROUP_ID, this.getSpaceGroupId(poll.getParentPath()));
                }
                templateParams.put(POLL_PARENT, poll.getParentPath());
                templateParams.put(POLL_ID, poll.getId());
                templateParams.put(POLL_LINK, poll.getLink());
                newActivity.setTemplateParams(templateParams);
                this.getManager().saveActivityNoReturn(pollOwnerIdentity, newActivity);
                if (!isNew) {
                    ExoSocialActivity comment = this.createComment();
                    String userId = this.getCurrentUserId();
                    if (userId != null && !userId.equals(pollOwnerIdentity.getRemoteId())) {
                        Identity currentIdentity = identityManager.getOrCreateIdentity("organization", userId, false);
                        comment.setUserId(currentIdentity.getId());
                    } else {
                        comment.setUserId(pollOwnerIdentity.getId());
                    }
                    this.getManager().saveComment(newActivity, comment);
                }
                if (pollService.getActivityIdForOwner(pollPath) == null) {
                    this.saveCommentToTopicActivity(poll, "A poll has been added to the topic.", "forum.add-poll");
                }
                pollService.saveActivityIdForOwner(pollPath, newActivity.getId());
            }
        }
        catch (Exception e) {
            LOG.error("Can not record Activity for space when create poll ", new Object[]{e.getMessage()});
        }
    }

    public void saveCommentToTopicActivity(Poll poll, String title, String titleId) {
        PollService pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        String topicActivityId = pollService.getActivityIdForOwner(poll.getParentPath());
        if (topicActivityId != null) {
            ExoSocialActivity topicActivity = this.getManager().getActivity(topicActivityId);
            if (poll.isInTopic() && topicActivity != null) {
                ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
                Identity pollOwnerIdentity = identityManager.getOrCreateIdentity("organization", poll.getOwner(), false);
                String userId = this.getCurrentUserId();
                if (userId != null && !userId.equals(pollOwnerIdentity.getRemoteId())) {
                    Identity currentIdentity = identityManager.getOrCreateIdentity("organization", userId, false);
                    comment.setUserId(currentIdentity.getId());
                } else {
                    comment.setUserId(pollOwnerIdentity.getId());
                }
                comment.setType("ks-forum:spaces");
                comment.setTitle(title);
                I18NActivityUtils.addResourceKey((ExoSocialActivity)comment, (String)titleId, null);
                this.getManager().saveComment(topicActivity, (ExoSocialActivity)comment);
            }
        }
    }

    public void savePoll(Poll poll, boolean isNew, boolean isVote) {
        this.savePollForActivity(poll, isNew, isVote);
    }

    public void closePoll(Poll poll) {
        this.saveCommentToTopicActivity(poll, "Poll has been closed.", "forum.close-poll");
    }

    public void pollRemove(String pollId) {
        try {
            PollService pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);
            Poll poll = pollService.getPoll(pollId);
            String pollPath = poll.getParentPath() + "/" + poll.getId();
            String activityId = pollService.getActivityIdForOwner(pollPath);
            ExoSocialActivity activity = this.getManager().getActivity(activityId);
            this.getManager().deleteActivity(activity);
            this.saveCommentToTopicActivity(poll, "Poll has been removed.", "forum.remove-poll");
        }
        catch (Exception e) {
            LOG.error((Object)("Fail to remove poll " + e.getMessage()));
        }
    }

    private ActivityManager getManager() {
        return (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    private String getSpaceGroupId(String path) {
        if (path.contains(Utils.CATEGORY_SPACE_ID_PREFIX)) {
            String[] tab = path.split("/");
            String spaceName = tab[tab.length - 2].replace(Utils.FORUM_SPACE_ID_PREFIX, "");
            return new StringBuffer("/spaces").append("/").append(spaceName).toString();
        }
        return "";
    }

    private Identity getSpaceIdentity(Poll poll) {
        IdentityManager identityM = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        String path = poll.getParentPath();
        String spaceGroupId = this.getSpaceGroupId(path);
        if ("".equals(spaceGroupId)) {
            return null;
        }
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        Space space = spaceService.getSpaceByGroupId(spaceGroupId);
        return identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
    }
}

