/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.net.URLEncoder;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.connector.BaseContentSearchServiceConnector;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class FileSearchServiceConnector
extends BaseContentSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger((String)FileSearchServiceConnector.class.getName());

    public FileSearchServiceConnector(InitParams initParams) throws Exception {
        super(initParams);
    }

    @Override
    protected String[] getSearchedDocTypes() {
        return new String[]{"nt:file"};
    }

    @Override
    protected String[] getNodeTypes() {
        return new String[]{"nt:file"};
    }

    @Override
    protected ResultNode filterNode(ResultNode node) throws RepositoryException {
        return node.isNodeType("nt:file") ? node : null;
    }

    @Override
    protected String getPath(ResultNode node, SearchContext context) throws Exception {
        return this.documentService.getLinkInDocumentsApp(node.getPath());
    }

    @Override
    protected String getPreviewUrl(ResultNode node, SearchContext context) throws Exception {
        String restContextName = WCMCoreUtils.getRestContextName();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        String workspaceName = node.getSession().getWorkspace().getName();
        StringBuffer downloadUrl = new StringBuffer();
        downloadUrl.append('/').append(restContextName).append("/jcr/").append(WCMCoreUtils.getRepository().getConfiguration().getName()).append('/').append(workspaceName).append(node.getPath());
        String authorUsername = null;
        if (node.hasProperty("exo:owner")) {
            authorUsername = node.getProperty("exo:owner").getString();
        }
        StringBuilder url = new StringBuilder("javascript:require(['SHARED/social-ui-activity'], function(activity) {activity.previewDoc(null, {doc:{");
        if (node.isNodeType("mix:referenceable")) {
            url.append("id:'").append(node.getUUID()).append("',");
        }
        url.append("fileType:'").append(this.getFileType(node)).append("',");
        url.append("title:'").append(this.getTitleResult(node)).append("',");
        url.append("path:'").append(node.getPath()).append("', repository:'").append(repositoryName).append("', workspace:'").append(workspaceName).append("', downloadUrl:'").append(downloadUrl.toString()).append("', openUrl:'").append(this.documentService.getLinkInDocumentsApp(node.getPath())).append("'}");
        if (authorUsername != null) {
            url.append(",author:{username:'").append(authorUsername).append("'}");
        }
        url.append("})});void(0);");
        return url.toString();
    }

    @Override
    protected String getImageUrl(Node node) {
        try {
            String path = node.getPath().replaceAll("'", "\\\\'");
            String encodedPath = URLEncoder.encode(path, "utf-8");
            encodedPath = encodedPath.replaceAll("%2F", "/");
            String portalName = WCMCoreUtils.getPortalName();
            String restContextName = WCMCoreUtils.getRestContextName();
            String preferenceWS = node.getSession().getWorkspace().getName();
            String thumbnailImage = "/" + restContextName + "/thumbnailImage/medium/" + WCMCoreUtils.getRepository().getConfiguration().getName() + "/" + preferenceWS + encodedPath;
            return thumbnailImage;
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Can not get image link", (Throwable)e);
            }
            return super.getImageUrl(node);
        }
    }
}

