/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.ArrayNodePageList;
import org.exoplatform.services.wcm.search.connector.BaseSearchServiceConnector;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class PageSearchServiceConnector
extends BaseSearchServiceConnector {
    public PageSearchServiceConnector(InitParams initParams) throws Exception {
        super(initParams);
    }

    @Override
    protected QueryCriteria createQueryCriteria(String query, long offset, long limit, String sort, String order) {
        QueryCriteria criteria = new QueryCriteria();
        criteria.setContentTypes(new String[]{"gtn:language", "exo:pageMetadata"});
        criteria.setFulltextSearchProperty(new String[]{"exo:metaKeywords", "exo:metaDescription", "gtn:name"});
        criteria.setKeyword(PageSearchServiceConnector.removeAccents(query.toLowerCase()));
        criteria.setSearchWebpage(true);
        criteria.setSearchDocument(false);
        criteria.setSearchWebContent(false);
        criteria.setLiveMode(true);
        criteria.setOffset(offset);
        criteria.setLimit(limit);
        criteria.setSortBy(sort);
        criteria.setOrderBy(order);
        if (query.contains("~")) {
            criteria.setFuzzySearch(true);
        }
        return criteria;
    }

    @Override
    protected AbstractPageList<ResultNode> searchNodes(QueryCriteria criteria) throws Exception {
        if (StringUtils.isBlank((String)criteria.getSiteName())) {
            return new ArrayNodePageList<ResultNode>(new ArrayList(), (int)criteria.getLimit());
        }
        String[] siteNames = criteria.getSiteName().split(",");
        if (siteNames.length == 1) {
            return this.siteSearch_.searchPageContents(WCMCoreUtils.getUserSessionProvider(), criteria, (int)criteria.getLimit(), false);
        }
        int limit = (int)criteria.getLimit();
        int offset = (int)criteria.getOffset();
        criteria.setOffset(0L);
        ArrayList<ResultNode> ret = new ArrayList<ResultNode>();
        for (String site : siteNames) {
            criteria.setSiteName(site);
            AbstractPageList<ResultNode> resultList = this.siteSearch_.searchPageContents(WCMCoreUtils.getUserSessionProvider(), criteria, (int)criteria.getLimit(), false);
            if (resultList.getAvailable() <= offset) {
                offset -= resultList.getAvailable();
            } else if (resultList.getAvailable() > offset) {
                for (int i = 0; i < limit; ++i) {
                    if (offset + i >= resultList.getAvailable()) continue;
                    ResultNode resNode = (ResultNode)resultList.getPage((offset + i) / resultList.getPageSize() + 1).get((offset + i) % resultList.getPageSize());
                    ret.add(resNode);
                    if (limit == 0) break;
                }
            }
            if (limit == 0) break;
        }
        return new ArrayNodePageList<ResultNode>(ret, (int)criteria.getLimit());
    }

    @Override
    protected ResultNode filterNode(ResultNode node) throws RepositoryException {
        return node;
    }

    @Override
    protected String getPath(ResultNode node, SearchContext context) throws Exception {
        return node.getUserNavigationURI();
    }

    @Override
    protected String getFileType(ResultNode node) throws Exception {
        return "FileDefault";
    }

    @Override
    protected String getTitleResult(ResultNode node) throws Exception {
        try {
            return ((Node)node.getSession().getItem(node.getProperty("mop:link/mop:page").getString())).getProperty("gtn:name").getString();
        }
        catch (Exception e) {
            return node.getTitle();
        }
    }

    @Override
    protected String getImageUrl(Node node) {
        return "/eXoSkin/skin/images/system/unified-search/page.png";
    }

    @Override
    protected String getDetails(ResultNode retNode, SearchContext context) throws Exception {
        DriveData driveData = this.documentService.getDriveOfNode(retNode.getPath(), ConversationState.getCurrent().getIdentity().getUserId(), Utils.getMemberships());
        return this.getDriveTitle(driveData);
    }
}

