/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class SysPropertyActions {
    public static String getProperty(String name, String defaultValue) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getProperty(name, defaultValue);
        }
        return SysProps.PRIVILEGED.getProperty(name, defaultValue);
    }

    public static String getProperty(String name) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getProperty(name);
        }
        return SysProps.PRIVILEGED.getProperty(name);
    }

    public static String setProperty(String name, String value) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.setProperty(name, value);
        }
        return SysProps.PRIVILEGED.setProperty(name, value);
    }

    public static ClassLoader setThreadContextClassLoader(Class cl) {
        if (System.getSecurityManager() == null) {
            return SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl);
        }
        return SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl);
    }

    public static ClassLoader setThreadContextClassLoader(ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            return SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl);
        }
        return SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl);
    }

    static interface SetThreadContextClassLoaderAction {
        public static final SetThreadContextClassLoaderAction NON_PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(Class cl) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl.getClassLoader());
                return old;
            }

            @Override
            public ClassLoader setThreadContextClassLoader(ClassLoader cl) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                return old;
            }
        };
        public static final SetThreadContextClassLoaderAction PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(final Class cl) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(cl.getClassLoader());
                        return old;
                    }
                });
            }

            @Override
            public ClassLoader setThreadContextClassLoader(final ClassLoader cl) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(cl);
                        return old;
                    }
                });
            }
        };

        public ClassLoader setThreadContextClassLoader(Class var1);

        public ClassLoader setThreadContextClassLoader(ClassLoader var1);
    }

    static interface SysProps {
        public static final SysProps NON_PRIVILEGED = new SysProps(){

            @Override
            public String getProperty(String name, String defaultValue) {
                return System.getProperty(name, defaultValue);
            }

            @Override
            public String getProperty(String name) {
                return System.getProperty(name);
            }

            @Override
            public String setProperty(String key, String value) {
                return System.setProperty(key, value);
            }
        };
        public static final SysProps PRIVILEGED = new SysProps(){

            @Override
            public String getProperty(final String name, final String defaultValue) {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(name, defaultValue);
                    }
                };
                return (String)AccessController.doPrivileged(action);
            }

            @Override
            public String getProperty(final String name) {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(name);
                    }
                };
                return (String)AccessController.doPrivileged(action);
            }

            @Override
            public String setProperty(final String name, final String value) {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        return System.setProperty(name, value);
                    }
                };
                return (String)AccessController.doPrivileged(action);
            }
        };

        public String getProperty(String var1, String var2);

        public String getProperty(String var1);

        public String setProperty(String var1, String var2);
    }
}

