/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.space.SpaceFilter;

public class XSpaceFilter
extends SpaceFilter {
    private Set<SpaceMemberEntity.Status> status = new HashSet<SpaceMemberEntity.Status>();
    private boolean includePrivate;
    private boolean unifiedSearch;
    private boolean notHidden;
    private boolean isPublic;
    private boolean lastAccess;
    private boolean visited;

    public XSpaceFilter setSpaceFilter(SpaceFilter spaceFilter) {
        if (spaceFilter != null) {
            this.setAppId(spaceFilter.getAppId());
            this.setFirstCharacterOfSpaceName(spaceFilter.getFirstCharacterOfSpaceName());
            this.setIncludeSpaces(spaceFilter.getIncludeSpaces());
            this.setRemoteId(spaceFilter.getRemoteId());
            this.setSorting(spaceFilter.getSorting());
            if (spaceFilter.getSpaceNameSearchCondition() != null) {
                this.setSpaceNameSearchCondition(spaceFilter.getSpaceNameSearchCondition());
            }
            if (spaceFilter instanceof XSpaceFilter) {
                XSpaceFilter filter = (XSpaceFilter)spaceFilter;
                this.setIncludePrivate(filter.isIncludePrivate());
                this.setUnifiedSearch(filter.isUnifiedSearch());
                this.setNotHidden(filter.isNotHidden());
                this.setLastAccess(filter.isLastAccess());
                this.setVisited(filter.isVisited());
                this.addStatus(filter.getStatus().toArray(new SpaceMemberEntity.Status[filter.getStatus().size()]));
                if (filter.isPublic()) {
                    this.setPublic(filter.getRemoteId());
                }
            }
        }
        return this;
    }

    public XSpaceFilter addStatus(SpaceMemberEntity.Status ... st) {
        this.status.addAll(Arrays.asList(st));
        return this;
    }

    public XSpaceFilter setIncludePrivate(boolean includePrivate) {
        this.includePrivate = includePrivate;
        return this;
    }

    public XSpaceFilter setUnifiedSearch(boolean unifiedSearch) {
        this.unifiedSearch = unifiedSearch;
        return this;
    }

    public XSpaceFilter setNotHidden(boolean notHidden) {
        this.notHidden = notHidden;
        return this;
    }

    public Set<SpaceMemberEntity.Status> getStatus() {
        return this.status;
    }

    public boolean isIncludePrivate() {
        return this.includePrivate;
    }

    public boolean isUnifiedSearch() {
        return this.unifiedSearch;
    }

    public boolean isNotHidden() {
        return this.notHidden;
    }

    public void setPublic(String userId) {
        this.setRemoteId(userId);
        this.isPublic = userId != null;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public void setLastAccess(boolean lastAccess) {
        this.lastAccess = lastAccess;
    }

    public boolean isLastAccess() {
        return this.lastAccess;
    }

    public boolean isVisited() {
        return this.visited;
    }
}

