/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.rest.IdentityAvatarRestService;
import org.exoplatform.social.core.jpa.search.XSpaceFilter;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl$AjcClosure11;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl$AjcClosure13;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl$AjcClosure5;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl$AjcClosure7;
import org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl$AjcClosure9;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.jpa.storage.dao.jpa.query.SpaceQueryBuilder;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;
import org.exoplatform.social.core.storage.impl.SpaceStorageImpl;

public class RDBMSSpaceStorageImpl
extends SpaceStorageImpl
implements SpaceStorage {
    private static final Log LOG;
    private SpaceDAO spaceDAO;
    private SpaceMemberDAO spaceMemberDAO;
    private IdentityDAO identityDAO;
    private IdentityStorage identityStorage;
    private ActivityDAO activityDAO;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public RDBMSSpaceStorageImpl(SpaceDAO spaceDAO, SpaceMemberDAO spaceMemberDAO, RDBMSIdentityStorageImpl identityStorage, IdentityDAO identityDAO, ActivityDAO activityDAO) {
        super((IdentityStorageImpl)identityStorage, null);
        this.spaceDAO = spaceDAO;
        this.identityStorage = identityStorage;
        this.spaceMemberDAO = spaceMemberDAO;
        this.identityDAO = identityDAO;
        this.activityDAO = activityDAO;
    }

    @ExoTransactional
    public void deleteSpace(String id) throws SpaceStorageException {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSSpaceStorageImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public List<Space> getAccessibleSpaces(String userId) throws SpaceStorageException {
        return this.getAccessibleSpaces(userId, 0L, -1L);
    }

    public List<Space> getAccessibleSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getAccessibleSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getAccessibleSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.MANAGER, SpaceMemberEntity.Status.MEMBER), spaceFilter, offset, limit);
    }

    public int getAccessibleSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.MANAGER, SpaceMemberEntity.Status.MEMBER), spaceFilter);
    }

    public int getAccessibleSpacesCount(String userId) throws SpaceStorageException {
        return this.getAccessibleSpacesByFilterCount(userId, null);
    }

    public List<Space> getAllSpaces() throws SpaceStorageException {
        return this.getSpaces(0L, -1L);
    }

    public int getAllSpacesByFilterCount(SpaceFilter spaceFilter) {
        return this.getSpacesCount(null, null, spaceFilter);
    }

    public int getAllSpacesCount() throws SpaceStorageException {
        return this.getAllSpacesByFilterCount(null);
    }

    public List<Space> getEditableSpaces(String userId) throws SpaceStorageException {
        return this.getEditableSpaces(userId, 0L, -1L);
    }

    public List<Space> getEditableSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getEditableSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getEditableSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.MANAGER), spaceFilter, offset, limit);
    }

    public int getEditableSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.MANAGER), spaceFilter);
    }

    public int getEditableSpacesCount(String userId) throws SpaceStorageException {
        return this.getEditableSpacesByFilterCount(userId, null);
    }

    public List<Space> getInvitedSpaces(String userId) throws SpaceStorageException {
        return this.getInvitedSpaces(userId, 0L, -1L);
    }

    public List<Space> getInvitedSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getInvitedSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getInvitedSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.INVITED), spaceFilter, offset, limit);
    }

    public int getInvitedSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.INVITED), spaceFilter);
    }

    public int getInvitedSpacesCount(String userId) throws SpaceStorageException {
        return this.getInvitedSpacesByFilterCount(userId, null);
    }

    public List<Space> getLastAccessedSpace(SpaceFilter spaceFilter, int offset, int limit) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter);
        xFilter.setLastAccess(true);
        return this.getMemberSpacesByFilter(spaceFilter.getRemoteId(), xFilter, offset, limit);
    }

    public int getLastAccessedSpaceCount(SpaceFilter spaceFilter) throws SpaceStorageException {
        return this.getMemberSpacesByFilterCount(spaceFilter.getRemoteId(), spaceFilter);
    }

    public List<Space> getLastSpaces(int limit) {
        List<SpaceEntity> entities = this.spaceDAO.getLastSpaces(limit);
        return this.buildList(entities);
    }

    public List<String> getMemberSpaceIds(String identityId, int offset, int limit) throws SpaceStorageException {
        Identity identity = this.identityStorage.findIdentityById(identityId);
        List<Long> spaceIds = this.spaceMemberDAO.getSpacesIdsByUserName(identity.getRemoteId(), offset, limit);
        LinkedList<String> ids = new LinkedList<String>();
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (Long spaceId : spaceIds) {
                ids.add(String.valueOf(spaceId));
            }
        }
        return ids;
    }

    public List<Space> getMemberSpaces(String userId) throws SpaceStorageException {
        return this.getMemberSpaces(userId, 0L, -1L);
    }

    public List<Space> getMemberSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getMemberSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getMemberSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.MEMBER), spaceFilter, offset, limit);
    }

    public int getMemberSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.MEMBER), spaceFilter);
    }

    public int getMemberSpacesCount(String userId) throws SpaceStorageException {
        return this.getMemberSpacesByFilterCount(userId, null);
    }

    public int getNumberOfMemberPublicSpaces(String userId) {
        XSpaceFilter filter = new XSpaceFilter();
        filter.setNotHidden(true);
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.MEMBER), filter);
    }

    public List<Space> getPendingSpaces(String userId) throws SpaceStorageException {
        return this.getPendingSpaces(userId, 0L, -1L);
    }

    public List<Space> getPendingSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getPendingSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getPendingSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(userId, Arrays.asList(SpaceMemberEntity.Status.PENDING), spaceFilter, offset, limit);
    }

    public int getPendingSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getSpacesCount(userId, Arrays.asList(SpaceMemberEntity.Status.PENDING), spaceFilter);
    }

    public int getPendingSpacesCount(String userId) throws SpaceStorageException {
        return this.getPendingSpacesByFilterCount(userId, null);
    }

    public List<Space> getPublicSpaces(String userId) throws SpaceStorageException {
        return this.getPublicSpaces(userId, 0L, -1L);
    }

    public List<Space> getPublicSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        return this.getPublicSpacesByFilter(userId, null, offset, limit);
    }

    public List<Space> getPublicSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        XSpaceFilter filter = new XSpaceFilter();
        filter.setSpaceFilter(spaceFilter);
        filter.setPublic(userId);
        return this.getSpacesByFilter(filter, offset, limit);
    }

    public int getPublicSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        XSpaceFilter filter = new XSpaceFilter();
        filter.setSpaceFilter(spaceFilter);
        filter.setPublic(userId);
        return this.getSpacesCount(null, null, filter);
    }

    public int getPublicSpacesCount(String userId) throws SpaceStorageException {
        return this.getPublicSpacesByFilterCount(userId, null);
    }

    public Space getSpaceByDisplayName(String spaceDisplayName) throws SpaceStorageException {
        SpaceEntity entity = this.spaceDAO.getSpaceByDisplayName(spaceDisplayName);
        return this.fillSpaceFromEntity(entity);
    }

    public Space getSpaceByGroupId(String groupId) throws SpaceStorageException {
        SpaceEntity entity = this.spaceDAO.getSpaceByGroupId(groupId);
        return this.fillSpaceFromEntity(entity);
    }

    @ExoTransactional
    public Space getSpaceById(String id) throws SpaceStorageException {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Space)ExoTransactionalAspect.aspectOf().around(new RDBMSSpaceStorageImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public Space getSpaceByPrettyName(String spacePrettyName) throws SpaceStorageException {
        String string = spacePrettyName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Space)ExoTransactionalAspect.aspectOf().around(new RDBMSSpaceStorageImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public Space getSpaceByUrl(String url) throws SpaceStorageException {
        SpaceEntity entity = this.spaceDAO.getSpaceByURL(url);
        return this.fillSpaceFromEntity(entity);
    }

    public Space getSpaceSimpleById(String id) throws SpaceStorageException {
        Long spaceId;
        try {
            spaceId = Long.parseLong(id);
        }
        catch (Exception ex) {
            return null;
        }
        SpaceEntity entity = (SpaceEntity)this.spaceDAO.find(spaceId);
        Space space = new Space();
        return this.fillSpaceSimpleFromEntity(entity, space);
    }

    public List<Space> getSpaces(long offset, long limit) throws SpaceStorageException {
        return this.getSpacesByFilter(null, offset, limit);
    }

    public List<Space> getSpacesByFilter(SpaceFilter spaceFilter, long offset, long limit) {
        return this.getSpaces(null, null, spaceFilter, offset, limit);
    }

    public List<Space> getUnifiedSearchSpaces(String userId, SpaceFilter spaceFilter, long offset, long limit) throws SpaceStorageException {
        throw new UnsupportedOperationException();
    }

    public int getUnifiedSearchSpacesCount(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter).setUnifiedSearch(true);
        return this.getSpacesCount(null, null, xFilter);
    }

    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        return this.getVisibleSpaces(userId, spaceFilter, 0L, -1L);
    }

    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter, long offset, long limit) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter).setRemoteId(userId);
        xFilter.addStatus(SpaceMemberEntity.Status.MEMBER, SpaceMemberEntity.Status.MANAGER, SpaceMemberEntity.Status.INVITED);
        xFilter.setIncludePrivate(true);
        return this.getSpacesByFilter(xFilter, offset, limit);
    }

    public int getVisibleSpacesCount(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter).setRemoteId(userId);
        xFilter.addStatus(SpaceMemberEntity.Status.MEMBER, SpaceMemberEntity.Status.MANAGER, SpaceMemberEntity.Status.INVITED);
        xFilter.setIncludePrivate(true);
        return this.getSpacesCount(userId, null, xFilter);
    }

    public List<Space> getVisitedSpaces(SpaceFilter spaceFilter, int offset, int limit) throws SpaceStorageException {
        XSpaceFilter xFilter = new XSpaceFilter();
        xFilter.setSpaceFilter(spaceFilter);
        xFilter.setVisited(true);
        return this.getMemberSpacesByFilter(spaceFilter.getRemoteId(), xFilter, offset, limit);
    }

    @ExoTransactional
    public void renameSpace(Space space, String newDisplayName) throws SpaceStorageException {
        Space space2 = space;
        String string = newDisplayName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)space2, (Object)string);
        Object[] objectArray = new Object[]{this, space2, string, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSSpaceStorageImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void ignoreSpace(String spaceId, String userId) {
        SpaceMemberEntity entity = this.spaceMemberDAO.getSpaceMemberShip(userId, Long.parseLong(spaceId), null);
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find(Long.valueOf(Long.parseLong(spaceId)));
        if (entity == null) {
            entity = new SpaceMemberEntity();
            entity.setSpace(spaceEntity);
            entity.setUserId(userId);
            entity.setStatus(SpaceMemberEntity.Status.IGNORED);
            this.spaceMemberDAO.create(entity);
        } else {
            entity.setStatus(SpaceMemberEntity.Status.IGNORED);
            this.spaceMemberDAO.update(entity);
        }
    }

    public boolean isSpaceIgnored(String spaceId, String userId) {
        SpaceMemberEntity entity = this.spaceMemberDAO.getSpaceMemberShip(userId, Long.parseLong(spaceId), SpaceMemberEntity.Status.IGNORED);
        return entity != null;
    }

    @ExoTransactional
    public void renameSpace(String remoteId, Space space, String newDisplayName) throws SpaceStorageException {
        String string = remoteId;
        Space space2 = space;
        String string2 = newDisplayName;
        Object[] objectArray = new Object[]{string, space2, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, space2, string2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSSpaceStorageImpl$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void saveSpace(Space space, boolean isNew) throws SpaceStorageException {
        Space space2 = space;
        boolean bl = isNew;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)space2, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, space2, Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSSpaceStorageImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void updateSpaceAccessed(String remoteId, Space space) throws SpaceStorageException {
        String string = remoteId;
        Space space2 = space;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)space2);
        Object[] objectArray = new Object[]{this, string, space2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSSpaceStorageImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    private Space fillSpaceFromEntity(SpaceEntity entity) {
        if (entity == null) {
            return null;
        }
        Space space = new Space();
        this.fillSpaceSimpleFromEntity(entity, space);
        space.setPendingUsers(entity.getPendingMembersId());
        space.setInvitedUsers(entity.getInvitedMembersId());
        String[] members = entity.getMembersId();
        String[] managers = entity.getManagerMembersId();
        HashSet<String> membersList = new HashSet<String>();
        if (members != null) {
            membersList.addAll(Arrays.asList(members));
        }
        if (managers != null) {
            membersList.addAll(Arrays.asList(managers));
        }
        space.setMembers(membersList.toArray(new String[0]));
        space.setManagers(entity.getManagerMembersId());
        return space;
    }

    private void renameIdentity(Identity identity) throws NodeNotFoundException {
        this.identityStorage.saveIdentity(identity);
    }

    private List<Space> getSpaces(String userId, List<SpaceMemberEntity.Status> status, SpaceFilter spaceFilter, long offset, long limit) {
        XSpaceFilter filter = new XSpaceFilter();
        filter.setSpaceFilter(spaceFilter);
        if (userId != null && status != null) {
            filter.setRemoteId(userId);
            filter.addStatus(status.toArray(new SpaceMemberEntity.Status[status.size()]));
        }
        if (filter.isUnifiedSearch()) {
            throw new UnsupportedOperationException();
        }
        SpaceQueryBuilder query = SpaceQueryBuilder.builder().filter(filter).offset(offset).limit(limit);
        List entities = query.build().getResultList();
        return this.buildList(entities);
    }

    private int getSpacesCount(String userId, List<SpaceMemberEntity.Status> status, SpaceFilter spaceFilter) {
        XSpaceFilter filter = new XSpaceFilter();
        filter.setSpaceFilter(spaceFilter);
        if (userId != null && status != null) {
            filter.setRemoteId(userId);
            filter.addStatus(status.toArray(new SpaceMemberEntity.Status[status.size()]));
        }
        if (filter.isUnifiedSearch()) {
            throw new UnsupportedOperationException();
        }
        SpaceQueryBuilder query = SpaceQueryBuilder.builder().filter(filter);
        return ((Long)query.buildCount().getSingleResult()).intValue();
    }

    private List<Space> buildList(List<SpaceEntity> spaceEntities) {
        LinkedList<Space> spaces = new LinkedList<Space>();
        if (spaceEntities != null) {
            for (SpaceEntity entity : spaceEntities) {
                Space space = this.fillSpaceFromEntity(entity);
                spaces.add(space);
            }
        }
        return spaces;
    }

    private Space fillSpaceSimpleFromEntity(SpaceEntity entity, Space space) {
        space.setApp(StringUtils.join(entity.getApp(), (String)","));
        space.setId(String.valueOf(entity.getId()));
        space.setDisplayName(entity.getDisplayName());
        space.setPrettyName(entity.getPrettyName());
        if (entity.getRegistration() != null) {
            space.setRegistration(entity.getRegistration().name().toLowerCase());
        }
        space.setDescription(entity.getDescription());
        space.setType(entity.getType());
        if (entity.getVisibility() != null) {
            space.setVisibility(entity.getVisibility().name().toLowerCase());
        }
        if (entity.getPriority() != null) {
            switch (entity.getPriority()) {
                case HIGH: {
                    space.setPriority("1");
                    break;
                }
                case INTERMEDIATE: {
                    space.setPriority("2");
                    break;
                }
                case LOW: {
                    space.setPriority("3");
                    break;
                }
                default: {
                    space.setPriority(null);
                }
            }
        }
        space.setGroupId(entity.getGroupId());
        space.setUrl(entity.getUrl());
        space.setCreatedTime(Long.valueOf(entity.getCreatedDate().getTime()));
        if (entity.getAvatarLastUpdated() != null) {
            try {
                space.setAvatarUrl(IdentityAvatarRestService.buildAvatarURL("space", space.getPrettyName()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to build avatar url: " + e.getMessage()));
            }
        }
        if (entity.getAvatarLastUpdated() != null) {
            space.setAvatarLastUpdated(Long.valueOf(entity.getAvatarLastUpdated().getTime()));
        }
        return space;
    }

    public void setIdentityStorage(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    static {
        RDBMSSpaceStorageImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(RDBMSSpaceStorageImpl.class);
    }

    static /* synthetic */ void deleteSpace_aroundBody0(RDBMSSpaceStorageImpl ajc$this, String id, JoinPoint joinPoint) {
        SpaceEntity entity = (SpaceEntity)ajc$this.spaceDAO.find(Long.valueOf(Long.parseLong(id)));
        if (entity != null) {
            Identity spaceIdentity = ajc$this.identityStorage.findIdentity("space", entity.getPrettyName());
            if (spaceIdentity == null) {
                LOG.warn("Space with pretty name '{}' hasn't a related identity", new Object[]{entity.getPrettyName()});
            } else {
                ajc$this.identityDAO.hardDeleteIdentity(Long.parseLong(spaceIdentity.getId()));
                ajc$this.activityDAO.deleteActivitiesByOwnerId(spaceIdentity.getId());
            }
            ajc$this.spaceDAO.delete(entity);
            LOG.debug("Space {} removed", new Object[]{entity.getPrettyName()});
        }
    }

    static /* synthetic */ Space getSpaceById_aroundBody2(RDBMSSpaceStorageImpl ajc$this, String id, JoinPoint joinPoint) {
        Long spaceId;
        try {
            spaceId = Long.parseLong(id);
        }
        catch (Exception ex) {
            return null;
        }
        SpaceEntity entity = (SpaceEntity)ajc$this.spaceDAO.find(spaceId);
        return ajc$this.fillSpaceFromEntity(entity);
    }

    static /* synthetic */ Space getSpaceByPrettyName_aroundBody4(RDBMSSpaceStorageImpl ajc$this, String spacePrettyName, JoinPoint joinPoint) {
        SpaceEntity entity = ajc$this.spaceDAO.getSpaceByPrettyName(spacePrettyName);
        return ajc$this.fillSpaceFromEntity(entity);
    }

    static /* synthetic */ void renameSpace_aroundBody6(RDBMSSpaceStorageImpl ajc$this, Space space, String newDisplayName, JoinPoint joinPoint) {
        ajc$this.renameSpace(null, space, newDisplayName);
    }

    static /* synthetic */ void renameSpace_aroundBody8(RDBMSSpaceStorageImpl ajc$this, String remoteId, Space space, String newDisplayName, JoinPoint entity) {
        try {
            String oldPrettyName = space.getPrettyName();
            space.setDisplayName(newDisplayName);
            space.setPrettyName(space.getDisplayName());
            space.setUrl(SpaceUtils.cleanString((String)newDisplayName));
            SpaceEntity entity2 = (SpaceEntity)ajc$this.spaceDAO.find(Long.valueOf(Long.parseLong(space.getId())));
            entity2.buildFrom(space);
            Identity identitySpace = ajc$this.identityStorage.findIdentity("space", oldPrettyName);
            if (identitySpace != null) {
                Profile profileSpace = identitySpace.getProfile();
                profileSpace.setProperty("firstName", (Object)space.getDisplayName());
                profileSpace.setProperty("username", (Object)space.getPrettyName());
                profileSpace.setProperty("Url", (Object)space.getUrl());
                ajc$this.identityStorage.saveProfile(profileSpace);
                identitySpace.setRemoteId(space.getPrettyName());
                ajc$this.renameIdentity(identitySpace);
            }
            LOG.debug((Object)String.format("Space %s (%s) saved", space.getPrettyName(), space.getId()));
        }
        catch (NodeNotFoundException e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_RENAME_SPACE, e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ void saveSpace_aroundBody10(RDBMSSpaceStorageImpl ajc$this, Space space, boolean isNew, JoinPoint joinPoint) {
        if (isNew) {
            SpaceEntity entity = new SpaceEntity();
            entity = entity.buildFrom(space);
            ajc$this.spaceDAO.create(entity);
            space.setId(String.valueOf(entity.getId()));
        } else {
            Long id = Long.parseLong(space.getId());
            SpaceEntity entity = (SpaceEntity)ajc$this.spaceDAO.find(id);
            if (entity != null) {
                entity = entity.buildFrom(space);
                ajc$this.spaceDAO.update(entity);
            } else {
                throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_SAVE_SPACE);
            }
        }
        LOG.debug("Space {} ({}) saved", new Object[]{space.getPrettyName(), space.getId()});
    }

    static /* synthetic */ void updateSpaceAccessed_aroundBody12(RDBMSSpaceStorageImpl ajc$this, String remoteId, Space space, JoinPoint joinPoint) {
        SpaceMemberEntity member = ajc$this.spaceMemberDAO.getSpaceMemberShip(remoteId, Long.parseLong(space.getId()), SpaceMemberEntity.Status.MEMBER);
        if (member != null) {
            member.setLastAccess(new Date());
            if (!member.isVisited()) {
                member.setVisited(member.getLastAccess().getTime() - member.getSpace().getCreatedDate().getTime() >= 2000L);
            }
        }
        ajc$this.spaceMemberDAO.update(member);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RDBMSSpaceStorageImpl.java", RDBMSSpaceStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteSpace", "org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl", "java.lang.String", "id", "org.exoplatform.social.core.storage.SpaceStorageException", "void"), 83);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceById", "org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl", "java.lang.String", "id", "org.exoplatform.social.core.storage.SpaceStorageException", "org.exoplatform.social.core.space.model.Space"), 325);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceByPrettyName", "org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl", "java.lang.String", "spacePrettyName", "org.exoplatform.social.core.storage.SpaceStorageException", "org.exoplatform.social.core.space.model.Space"), 336);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "renameSpace", "org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl", "org.exoplatform.social.core.space.model.Space:java.lang.String", "space:newDisplayName", "org.exoplatform.social.core.storage.SpaceStorageException", "void"), 424);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "renameSpace", "org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl", "java.lang.String:org.exoplatform.social.core.space.model.Space:java.lang.String", "remoteId:space:newDisplayName", "org.exoplatform.social.core.storage.SpaceStorageException", "void"), 455);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveSpace", "org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl", "org.exoplatform.social.core.space.model.Space:boolean", "space:isNew", "org.exoplatform.social.core.storage.SpaceStorageException", "void"), 492);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateSpaceAccessed", "org.exoplatform.social.core.jpa.storage.RDBMSSpaceStorageImpl", "java.lang.String:org.exoplatform.social.core.space.model.Space", "remoteId:space", "org.exoplatform.social.core.storage.SpaceStorageException", "void"), 518);
    }
}

