/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;

public class SpaceMemberDAOImpl
extends GenericDAOJPAImpl<SpaceMemberEntity, Long>
implements SpaceMemberDAO {
    private static final Log LOG = ExoLogger.getLogger(SpaceMemberDAOImpl.class);

    @Override
    public void deleteBySpace(SpaceEntity entity) {
        Query query = this.getEntityManager().createNamedQuery("SpaceMember.deleteBySpace");
        query.setParameter("spaceId", (Object)entity.getId());
        query.executeUpdate();
    }

    @Override
    public SpaceMemberEntity getSpaceMemberShip(String remoteId, Long spaceId, SpaceMemberEntity.Status status) throws IllegalArgumentException {
        if (status == null) {
            TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getSpaceMemberShip", SpaceMemberEntity.class);
            query.setParameter("userId", (Object)remoteId);
            query.setParameter("spaceId", (Object)spaceId);
            try {
                List memberEntities = query.getResultList();
                if (memberEntities.size() > 1) {
                    LOG.warn((Object)"we have found more than one result");
                    return (SpaceMemberEntity)memberEntities.get(0);
                }
                return (SpaceMemberEntity)query.getSingleResult();
            }
            catch (NoResultException ex) {
                return null;
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getMember", SpaceMemberEntity.class);
        query.setParameter("userId", (Object)remoteId);
        query.setParameter("spaceId", (Object)spaceId);
        query.setParameter("status", (Object)status);
        try {
            List memberEntities = query.getResultList();
            if (memberEntities.size() > 1) {
                LOG.warn((Object)"we have found more than one result");
                return (SpaceMemberEntity)memberEntities.get(0);
            }
            return (SpaceMemberEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<Long> getSpacesIdsByUserName(String userId, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getSpaceIdentitiesIdByMemberId", Long.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("status", (Object)SpaceMemberEntity.Status.MEMBER);
        try {
            if (limit > 0) {
                query.setFirstResult(offset);
                query.setMaxResults(limit);
            }
            return query.getResultList();
        }
        catch (NoResultException ex) {
            return null;
        }
    }
}

