/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.webui.container.UIContainerActionListener;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;

@ComponentConfig(events={@EventConfig(listeners={UIContainerActionListener.EditContainerActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.DeleteComponentActionListener.class}, confirm="UIContainer.deleteContainer")})
public class UIContainer
extends UIPortalComponent {
    public static final String TABLE_COLUMN_CONTAINER = "TableColumnContainer";
    private String storageId;
    protected String icon;
    protected String description;
    protected String[] moveContainersPermissions;
    protected String[] moveAppsPermissions;

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String s) {
        this.icon = s;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String[] getMoveContainersPermissions() {
        return this.moveContainersPermissions;
    }

    public void setMoveContainersPermissions(String[] moveContainersPermissions) {
        this.moveContainersPermissions = moveContainersPermissions;
    }

    public boolean hasMoveContainersPermission() {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        UserACL acl = (UserACL)exoContainer.getComponentInstanceOfType(UserACL.class);
        return acl.hasPermission(this.moveContainersPermissions);
    }

    public String[] getMoveAppsPermissions() {
        return this.moveAppsPermissions;
    }

    public void setMoveAppsPermissions(String[] moveAppsPermissions) {
        this.moveAppsPermissions = moveAppsPermissions;
    }

    public boolean hasMoveAppsPermission() {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        UserACL acl = (UserACL)exoContainer.getComponentInstanceOfType(UserACL.class);
        return acl.hasPermission(this.moveAppsPermissions);
    }

    public String getPermissionClasses() {
        StringBuilder permissionClasses = new StringBuilder();
        if (!this.hasAccessPermission()) {
            permissionClasses.append(" ProtectedContainer");
        }
        if (!this.hasMoveAppsPermission()) {
            permissionClasses.append(" CannotMoveApps");
        }
        if (!this.hasMoveContainersPermission()) {
            permissionClasses.append(" CannotMoveContainers");
        }
        return permissionClasses.toString();
    }
}

