/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.poi.util.SAXHelper;
import org.exoplatform.commons.utils.QName;
import org.exoplatform.services.document.DCMetaData;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MSXPPTDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.MSXPPTDocumentReader");
    private static final String URI_CORE_PROPERTIES = "http://schemas.openxmlformats.org/package/2006/metadata/core-properties";
    private static final String URI_DC_TERMS = "http://purl.org/dc/terms/";
    private static final String PPTX_SLIDE_PREFIX = "ppt/slides/slide";
    private static final String PPTX_CORE_NAME = "docProps/core.xml";
    private static final int MAX_SLIDES = 500;

    @Override
    public String[] getMimeTypes() {
        return new String[]{"application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12"};
    }

    @Override
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        return this.getContentAsText(is, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is, int maxSlides) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        StringBuilder appendText = new StringBuilder();
        try {
            int slideCount = 0;
            ZipInputStream zis = new ZipInputStream(is);
            try {
                ZipEntry ze = zis.getNextEntry();
                if (ze == null) {
                    String string = "";
                    return string;
                }
                XMLReader xmlReader = SAXHelper.newXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                TreeMap<Integer, String> slides = new TreeMap<Integer, String>();
                while (ze != null && slideCount < maxSlides) {
                    String zeName = ze.getName();
                    if (zeName.startsWith(PPTX_SLIDE_PREFIX) && zeName.length() > PPTX_SLIDE_PREFIX.length()) {
                        String slideNumberStr = zeName.substring(PPTX_SLIDE_PREFIX.length(), zeName.indexOf(".xml"));
                        int slideNumber = -1;
                        try {
                            slideNumber = Integer.parseInt(slideNumberStr);
                        }
                        catch (NumberFormatException e) {
                            LOG.warn((Object)("Could not parse the slide number: " + e.getMessage()));
                        }
                        if (slideNumber > -1 && slideNumber <= maxSlides) {
                            MSPPTXContentHandler contentHandler = new MSPPTXContentHandler();
                            xmlReader.setContentHandler(contentHandler);
                            xmlReader.parse(new InputSource(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)zis))));
                            slides.put(slideNumber, contentHandler.getContent());
                            ++slideCount;
                        }
                    }
                    ze = zis.getNextEntry();
                }
                for (String slide : slides.values()) {
                    appendText.append(slide);
                    appendText.append(' ');
                }
            }
            finally {
                block32: {
                    try {
                        zis.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block32;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
            String string = appendText.toString();
            return string;
        }
        catch (ParserConfigurationException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
        finally {
            block33: {
                try {
                    is.close();
                }
                catch (IOException e) {
                    if (!LOG.isTraceEnabled()) break block33;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        try {
            ZipInputStream zis;
            block19: {
                Properties properties;
                zis = new ZipInputStream(is);
                try {
                    ZipEntry ze = zis.getNextEntry();
                    while (ze != null && !ze.getName().equals(PPTX_CORE_NAME)) {
                        ze = zis.getNextEntry();
                    }
                    if (ze != null) break block19;
                    properties = new Properties();
                }
                catch (Throwable throwable) {
                    try {
                        zis.close();
                        throw throwable;
                    }
                    catch (ParserConfigurationException e) {
                        throw new DocumentReadException(e.getMessage(), e);
                    }
                    catch (SAXException e) {
                        throw new DocumentReadException(e.getMessage(), e);
                    }
                }
                zis.close();
                return properties;
            }
            MSPPTXMetaHandler metaHandler = new MSPPTXMetaHandler();
            XMLReader xmlReader = SAXHelper.newXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setContentHandler(metaHandler);
            xmlReader.parse(new InputSource(zis));
            Properties properties = metaHandler.getProperties();
            zis.close();
            return properties;
        }
        finally {
            block20: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block20;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
    }

    private class MSPPTXMetaHandler
    extends DefaultHandler {
        private Properties props = new Properties();
        private QName curPropertyName;
        private StringBuilder curPropertyValue = new StringBuilder();

        public Properties getProperties() {
            return this.props;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (namespaceURI.equals("http://purl.org/dc/elements/1.1/")) {
                this.curPropertyName = new QName("http://purl.org/dc/elements/1.1/", localName);
            } else if (namespaceURI.equals(MSXPPTDocumentReader.URI_CORE_PROPERTIES) && localName.equals("lastModifiedBy")) {
                this.curPropertyName = DCMetaData.CONTRIBUTOR;
            } else if (namespaceURI.equals(MSXPPTDocumentReader.URI_DC_TERMS) && localName.equals("modified")) {
                this.curPropertyName = DCMetaData.DATE;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.curPropertyName != null) {
                this.curPropertyValue.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.curPropertyName != null) {
                this.props.put(this.curPropertyName, this.curPropertyValue.toString());
                this.curPropertyValue = new StringBuilder();
                this.curPropertyName = null;
            }
        }
    }

    private class MSPPTXContentHandler
    extends DefaultHandler {
        private StringBuilder content = new StringBuilder();
        private boolean appendChar = false;

        public String getContent() {
            return this.content.toString();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (rawName.startsWith("a:t")) {
                this.appendChar = true;
                if (this.content.length() > 0 && this.content.charAt(this.content.length() - 1) != ' ') {
                    this.content.append(' ');
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.appendChar) {
                this.content.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.appendChar = false;
        }
    }
}

