/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SpoolConfig {
    private static final Log LOG = ExoLogger.getLogger(SpoolConfig.class);
    public FileCleaner fileCleaner;
    public File tempDirectory = new File(PropertyManager.getProperty((String)"java.io.tmpdir"));
    private static final String FORCE_CLEAN_SWAP_LIVE_TIME = "exo.jcr.spoolConfig.swap.live.time";
    public int maxBufferSize = 204800;
    private static Map<String, SpoolConfig> spoolConfigList = new HashMap<String, SpoolConfig>();
    public static int liveTime = -1;

    public SpoolConfig(FileCleaner fileCleaner) {
        this.fileCleaner = fileCleaner;
    }

    public static SpoolConfig getDefaultSpoolConfig() {
        return new SpoolConfig(FileCleanerHolder.getDefaultFileCleaner());
    }

    public static File getSwapPath(String workspaceName) {
        SpoolConfig sp = spoolConfigList.get(workspaceName);
        return sp != null ? sp.tempDirectory : null;
    }

    public static void addSpoolConfig(String workspaceName, SpoolConfig spoolConfig) {
        spoolConfigList.put(workspaceName, spoolConfig);
    }

    static {
        try {
            liveTime = Integer.parseInt(System.getProperty(FORCE_CLEAN_SWAP_LIVE_TIME));
        }
        catch (NumberFormatException nex) {
            LOG.warn("Parameter {} is not a valid number, default value will be used is -1", new Object[]{FORCE_CLEAN_SWAP_LIVE_TIME});
        }
    }
}

