/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.rest.entity.DataEntity;

public class RestUtils {
    public static final int DEFAULT_LIMIT = 20;
    public static final int DEFAULT_OFFSET = 0;
    public static final int HARD_LIMIT = 50;
    public static final String SUPPORT_TYPE = "json";
    public static final String ADMIN_GROUP = "/platform/administrators";

    public static String formatISO8601(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return ISO8601.format((Calendar)calendar);
    }

    public static MediaType getJsonMediaType() {
        return RestUtils.getMediaType(SUPPORT_TYPE, new String[]{SUPPORT_TYPE});
    }

    public static MediaType getMediaType(String expectedFormat, String[] supportedFormats) {
        if (!RestUtils.isSupportedFormat(expectedFormat, supportedFormats)) {
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        if (expectedFormat.equals(SUPPORT_TYPE) && RestUtils.isSupportedFormat(SUPPORT_TYPE, supportedFormats)) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        if (expectedFormat.equals("xml") && RestUtils.isSupportedFormat("xml", supportedFormats)) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        if (expectedFormat.equals("atom") && RestUtils.isSupportedFormat("atom", supportedFormats)) {
            return MediaType.APPLICATION_ATOM_XML_TYPE;
        }
        throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
    }

    private static boolean isSupportedFormat(String expectedFormat, String[] supportedFormats) {
        for (String supportedFormat : supportedFormats) {
            if (!supportedFormat.equals(expectedFormat)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMemberOfAdminGroup() {
        return ConversationState.getCurrent().getIdentity().isMemberOf(ADMIN_GROUP);
    }

    public static String getRestUrl(String type, String id, String restPath) {
        String version = restPath.split("/")[1];
        String socialResource = restPath.split("/")[2];
        return new StringBuffer(RestUtils.getBaseRestUrl()).append("/").append(version).append("/").append(socialResource).append("/").append(type).append("/").append(id).toString();
    }

    public static String getBaseRestUrl() {
        return new StringBuffer(RestUtils.getBaseUrl()).append("/").append(CommonsUtils.getRestContextName()).toString();
    }

    public static String getBaseUrl() {
        String fullUrl = ApplicationContextImpl.getCurrent().getBaseUri().toString();
        return fullUrl != null && !fullUrl.isEmpty() ? fullUrl.substring(0, fullUrl.indexOf("/", 9)) : "";
    }

    public static boolean isAnonymous() {
        return IdentityConstants.ANONIM.equals(ConversationState.getCurrent().getIdentity().getUserId());
    }

    public static String getPathParam(UriInfo uriInfo, String name) {
        return (String)uriInfo.getPathParameters().getFirst((Object)name);
    }

    public static String getQueryParam(UriInfo uriInfo, String name) {
        return (String)uriInfo.getQueryParameters().getFirst((Object)name);
    }

    public static int getLimit(UriInfo uriInfo) {
        Integer limit = RestUtils.getIntegerValue(uriInfo, "limit");
        return limit != null && limit > 0 ? Math.min(50, limit) : 20;
    }

    public static int getOffset(UriInfo uriInfo) {
        Integer offset = RestUtils.getIntegerValue(uriInfo, "offset");
        return offset != null ? offset : 0;
    }

    public static Integer getIntegerValue(UriInfo uriInfo, String name) {
        String value = RestUtils.getQueryParam(uriInfo, name);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long getLongValue(UriInfo uriInfo, String name) {
        String value = RestUtils.getQueryParam(uriInfo, name);
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isReturnSize(UriInfo uriInfo) {
        return Boolean.parseBoolean(RestUtils.getQueryParam(uriInfo, "returnSize"));
    }

    public static DataEntity extractInfo(DataEntity inEntity, List<String> returnedProperties) {
        DataEntity outEntity = new DataEntity();
        for (Map.Entry entry : inEntity.entrySet()) {
            if (!returnedProperties.contains(entry.getKey())) continue;
            outEntity.setProperty((String)entry.getKey(), entry.getValue());
        }
        return outEntity;
    }

    public static long getBaseTime(String baseDateTime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = sdf.parse(baseDateTime);
        return date.getTime();
    }
}

