/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.ActivitiesRealtimeListAccess;
import org.exoplatform.social.core.activity.ActivityLifeCycle;
import org.exoplatform.social.core.activity.ActivityListener;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.CommentsRealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;

public class ActivityManagerImpl
implements ActivityManager {
    private static final Log LOG = ExoLogger.getLogger(ActivityManagerImpl.class);
    protected ActivityStorage activityStorage;
    protected IdentityManager identityManager;
    protected SpaceService spaceService;
    protected ActivityLifeCycle activityLifeCycle = new ActivityLifeCycle();
    private static final int DEFAULT_LIMIT = 20;
    private static Map<String, Boolean> activityTypesRegistry = new HashMap<String, Boolean>();
    private static final String ACTIVITY_TYPE_PROPERTY_PATTERN = "exo\\.activity-type\\..*\\.enabled";
    private static final String PREFIX = "exo.activity-type.";
    private static final String SUFFIX = ".enabled";
    private int maxUploadSize = 10;

    public ActivityManagerImpl(ActivityStorage activityStorage, IdentityManager identityManager, InitParams params) {
        this.activityStorage = activityStorage;
        this.identityManager = identityManager;
        this.initActivityTypes();
        if (params != null && params.containsKey((Object)"upload.limit.size") && StringUtils.isNotBlank((CharSequence)params.getValueParam("upload.limit.size").getValue())) {
            this.maxUploadSize = Integer.parseInt(params.getValueParam("upload.limit.size").getValue());
        } else {
            String maxUploadString = System.getProperty("wcm.connector.drives.uploadLimit");
            if (StringUtils.isNotBlank((CharSequence)maxUploadString)) {
                this.maxUploadSize = Integer.parseInt(maxUploadString);
            }
        }
    }

    @Override
    public void saveActivityNoReturn(Identity streamOwner, ExoSocialActivity newActivity) {
        if (!streamOwner.isEnable()) {
            LOG.warn((Object)"Activity could not be saved. Owner has been disabled.");
            return;
        }
        if (newActivity.getType() != null && activityTypesRegistry.get(newActivity.getType()) != null && !activityTypesRegistry.get(newActivity.getType()).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activity could not be saved. Activity Type {} has been disabled.", new Object[]{newActivity.getType()});
            }
            return;
        }
        this.activityStorage.saveActivity(streamOwner, newActivity);
        this.activityLifeCycle.saveActivity(newActivity);
    }

    @Override
    public void saveActivityNoReturn(ExoSocialActivity newActivity) {
        Identity owner = this.getStreamOwner(newActivity);
        this.saveActivityNoReturn(owner, newActivity);
    }

    @Override
    public void saveActivity(Identity streamOwner, String activityType, String activityTitle) {
        if (activityType != null && activityTypesRegistry.get(activityType) != null && !activityTypesRegistry.get(activityType).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activity could not be saved. Activity Type {} has been disabled.", new Object[]{activityType});
            }
            return;
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setType(activityType);
        activity.setTitle(activityTitle);
        this.saveActivity(streamOwner, activity);
    }

    @Override
    public ExoSocialActivity getActivity(String activityId) {
        return this.activityStorage.getActivity(activityId);
    }

    @Override
    public ExoSocialActivity getParentActivity(ExoSocialActivity comment) {
        return this.activityStorage.getParentActivity(comment);
    }

    @Override
    public List<ExoSocialActivity> getSubComments(ExoSocialActivity comment) {
        return this.activityStorage.getSubComments(comment);
    }

    @Override
    public void updateActivity(ExoSocialActivity existingActivity) {
        this.activityStorage.updateActivity(existingActivity);
    }

    @Override
    public void deleteActivity(ExoSocialActivity existingActivity) {
        Validate.notNull((Object)existingActivity.getId(), (String)"existingActivity.getId() must not be null!");
        this.deleteActivity(existingActivity.getId());
    }

    @Override
    public void deleteActivity(String activityId) {
        this.activityStorage.deleteActivity(activityId);
    }

    @Override
    public void saveComment(ExoSocialActivity existingActivity, ExoSocialActivity newComment) throws ActivityStorageException {
        if (existingActivity == null) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_SAVE_COMMENT, "Activity cannot be NULL");
        }
        String activityType = existingActivity.getType();
        if (existingActivity != null && existingActivity.getId() == null && activityType != null && activityTypesRegistry.get(activityType) != null && !activityTypesRegistry.get(activityType).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Comment could not be saved. Activity Type {} has been disabled.", new Object[]{activityType});
            }
            return;
        }
        this.activityStorage.saveComment(existingActivity, newComment);
        this.activityLifeCycle.saveComment(newComment);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity existingActivity, boolean loadSubComments) {
        return new CommentsRealtimeListAccess(this.activityStorage, existingActivity, loadSubComments);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity existingActivity) {
        return new CommentsRealtimeListAccess(this.activityStorage, existingActivity);
    }

    @Override
    public void deleteComment(String activityId, String commentId) {
        this.activityStorage.deleteComment(activityId, commentId);
    }

    @Override
    public void deleteComment(ExoSocialActivity existingActivity, ExoSocialActivity existingComment) {
        this.deleteComment(existingActivity.getId(), existingComment.getId());
    }

    @Override
    public void saveLike(ExoSocialActivity existingActivity, Identity identity) {
        Object[] identityIds = existingActivity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            LOG.warn((Object)("activity is already liked by identity: " + identity));
            return;
        }
        identityIds = (String[])ArrayUtils.add((Object[])identityIds, (Object)identity.getId());
        existingActivity.setLikeIdentityIds((String[])identityIds);
        this.updateActivity(existingActivity);
        if (existingActivity.isComment()) {
            this.activityLifeCycle.likeComment(existingActivity);
        } else {
            this.activityLifeCycle.likeActivity(existingActivity);
        }
    }

    @Override
    public void deleteLike(ExoSocialActivity activity, Identity identity) {
        activity.setTitle(null);
        activity.setBody(null);
        activity.setTemplateParams(null);
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            identityIds = (String[])ArrayUtils.removeElement((Object[])identityIds, (Object)identity.getId());
            activity.setLikeIdentityIds((String[])identityIds);
            this.updateActivity(activity);
        } else {
            LOG.warn((Object)("activity is not liked by identity: " + identity));
        }
    }

    @Override
    public void addActivityEventListener(ActivityListenerPlugin activityListenerPlugin) {
        this.registerActivityListener(activityListenerPlugin);
    }

    public void registerActivityListener(ActivityListener listener) {
        this.activityLifeCycle.addListener(listener);
    }

    public void unregisterActivityListener(ActivityListener listener) {
        this.activityLifeCycle.removeListener(listener);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesWithListAccess(Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.USER_ACTIVITIES, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesWithListAccess(Identity ownerIdentity, Identity viewerIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.VIEW_USER_ACTIVITIES, ownerIdentity, viewerIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfConnectionsWithListAccess(Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.CONNECTIONS_ACTIVITIES, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfUserSpacesWithListAccess(Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.USER_SPACE_ACTIVITIES, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfSpaceWithListAccess(Identity existingSpaceIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.SPACE_ACTIVITIES, existingSpaceIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivityFeedWithListAccess(Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.ACTIVITY_FEED, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesByPoster(Identity posterIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.POSTER_ACTIVITIES, posterIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesByPoster(Identity posterIdentity, String ... activityTypes) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.POSTER_AND_TYPES_ACTIVITIES, posterIdentity, activityTypes);
    }

    @Override
    public void addProcessor(ActivityProcessor processor) {
        this.activityStorage.getActivityProcessors().add(processor);
        LOG.debug((Object)("added activity processor " + processor.getClass()));
    }

    @Override
    public void addProcessorPlugin(BaseActivityProcessorPlugin plugin) {
        this.addProcessor(plugin);
    }

    public void initActivityTypes() {
        Properties properties = PropertyManager.getPropertiesByPattern((String)ACTIVITY_TYPE_PROPERTY_PATTERN);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String value = properties.getProperty(k.toString());
            String name = k.toString().substring(PREFIX.length(), k.toString().lastIndexOf(SUFFIX));
            if (value != null && value.equalsIgnoreCase("false")) {
                LOG.info("Activity Type key:  {},  registration status: disabled", new Object[]{name});
                activityTypesRegistry.putIfAbsent(name, false);
            } else {
                LOG.info("Activity Type key:  {},  registration status: enabled", new Object[]{name});
                activityTypesRegistry.putIfAbsent(name, true);
            }
        }));
    }

    @Override
    public ExoSocialActivity saveActivity(Identity streamOwner, ExoSocialActivity newActivity) {
        ExoSocialActivity created = this.activityStorage.saveActivity(streamOwner, newActivity);
        this.activityLifeCycle.saveActivity(this.getActivity(created.getId()));
        return created;
    }

    @Override
    public ExoSocialActivity saveActivity(ExoSocialActivity newActivity) {
        this.saveActivityNoReturn(newActivity);
        return newActivity;
    }

    @Override
    public List<ExoSocialActivity> getActivities(Identity identity) throws ActivityStorageException {
        List<ExoSocialActivity> activityList = Collections.emptyList();
        try {
            ExoSocialActivity[] activities = (ExoSocialActivity[])this.getActivitiesWithListAccess(identity).load(0, 20);
            activityList = Arrays.asList(activities);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get activities by identity: " + identity));
        }
        return activityList;
    }

    @Override
    public List<ExoSocialActivity> getActivities(Identity identity, long start, long limit) throws ActivityStorageException {
        return this.activityStorage.getUserActivities(identity, start, limit);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfConnections(Identity ownerIdentity) throws ActivityStorageException {
        List<ExoSocialActivity> activityList = Collections.emptyList();
        try {
            ExoSocialActivity[] activities = (ExoSocialActivity[])this.getActivitiesOfConnectionsWithListAccess(ownerIdentity).load(0, 30);
            activityList = Arrays.asList(activities);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get activities of connections!");
        }
        return activityList;
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfConnections(Identity ownerIdentity, int offset, int limit) throws ActivityStorageException {
        this.validateStartLimit(offset, limit);
        List<Object> connectionList = null;
        try {
            ListAccess<Identity> connectionsWithListAccess = this.identityManager.getConnectionsWithListAccess(ownerIdentity);
            connectionList = Arrays.asList(connectionsWithListAccess.load(0, connectionsWithListAccess.getSize()));
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to getActivitiesOfIdentities of: " + ownerIdentity.getRemoteId()), (Throwable)e);
        }
        return this.activityStorage.getActivitiesOfIdentities(connectionList, offset, limit);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfUserSpaces(Identity ownerIdentity) {
        return this.getActivitiesOfUserSpacesWithListAccess(ownerIdentity).loadAsList(0, 20);
    }

    @Override
    public List<ExoSocialActivity> getActivityFeed(Identity identity) {
        return this.getActivityFeedWithListAccess(identity).loadAsList(0, 40);
    }

    @Override
    public void removeLike(ExoSocialActivity existingActivity, Identity existingIdentity) {
        this.deleteLike(existingActivity, existingIdentity);
    }

    @Override
    public List<ExoSocialActivity> getComments(ExoSocialActivity existingActivity) {
        return this.getCommentsWithListAccess(existingActivity).loadAsList(0, 40);
    }

    @Override
    public ExoSocialActivity recordActivity(Identity owner, String type, String title) throws ActivityStorageException {
        ExoSocialActivityImpl newActivity = new ExoSocialActivityImpl(owner.getId(), type, title);
        this.saveActivity(owner, newActivity);
        return newActivity;
    }

    @Override
    public int getActivitiesCount(Identity owner) throws ActivityStorageException {
        return this.activityStorage.getNumberOfUserActivities(owner);
    }

    @Override
    public void processActivitiy(ExoSocialActivity activity) {
    }

    @Override
    public ExoSocialActivity recordActivity(Identity owner, ExoSocialActivity activity) throws Exception {
        this.saveActivity(owner, activity);
        return activity;
    }

    @Override
    public ExoSocialActivity recordActivity(Identity owner, String type, String title, String body) throws ActivityStorageException {
        String userId = owner.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userId, type, title, body);
        this.saveActivity(owner, activity);
        return activity;
    }

    private void validateStartLimit(long start, long limit) {
        Validate.isTrue((limit >= start ? 1 : 0) != 0, (String)"'limit' must be greater than or equal to 'start'");
        Validate.isTrue((limit - start <= 20L ? 1 : 0) != 0, (String)"'limit - start' must be less than or equal to 20");
    }

    private Identity getStreamOwner(ExoSocialActivity newActivity) {
        Validate.notNull((Object)newActivity.getUserId(), (String)"activity.getUserId() must not be null!");
        return this.identityManager.getIdentity(newActivity.getUserId(), false);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getAllActivitiesWithListAccess() {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.ALL);
    }

    @Override
    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    @Override
    public List<ExoSocialActivity> getActivities(List<String> activityIdList) {
        return this.activityStorage.getActivities(activityIdList);
    }
}

