/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.importer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.config.model.I18NString;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PageNodeContainer;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.importer.ImportConfig;
import org.exoplatform.portal.mop.navigation.GenericScope;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.tree.diff.Adapters;
import org.exoplatform.portal.tree.diff.ListAdapter;
import org.exoplatform.portal.tree.diff.ListChangeIterator;
import org.exoplatform.portal.tree.diff.ListChangeType;
import org.exoplatform.portal.tree.diff.ListDiff;

public class NavigationFragmentImporter {
    private static final ListAdapter<PageNodeContainer, String> PAGE_NODE_CONTAINER_ADAPTER = new ListAdapter<PageNodeContainer, String>(){

        @Override
        public int size(PageNodeContainer list) {
            ArrayList<PageNode> nodes = list.getNodes();
            if (nodes == null) {
                return 0;
            }
            return nodes.size();
        }

        @Override
        public Iterator<String> iterator(PageNodeContainer list, boolean reverse) {
            ArrayList<PageNode> nodes = list.getNodes();
            if (nodes == null) {
                return Collections.emptyList().iterator();
            }
            String[] names = new String[nodes.size()];
            int index = 0;
            for (PageNode child : nodes) {
                names[index++] = child.getName();
            }
            return Adapters.list().iterator(names, reverse);
        }
    };
    private static final ListAdapter<NodeContext<?>, String> NODE_ADAPTER = new ListAdapter<NodeContext<?>, String>(){

        @Override
        public int size(NodeContext<?> list) {
            return list.getNodeCount();
        }

        @Override
        public Iterator<String> iterator(NodeContext<?> list, boolean reverse) {
            int size = list.getNodeCount();
            String[] names = new String[size];
            int index = 0;
            for (NodeContext child = (NodeContext)list.getFirst(); child != null; child = (NodeContext)child.getNext()) {
                names[index++] = child.getName();
            }
            return Adapters.list().iterator(names, reverse);
        }
    };
    private final String[] path;
    private final NavigationService navigationService;
    private final SiteKey navigationKey;
    private final Locale portalLocale;
    private final DescriptionService descriptionService;
    private final PageNodeContainer src;
    private final ImportConfig config;

    public NavigationFragmentImporter(String[] path, NavigationService navigationService, SiteKey navigationKey, Locale portalLocale, DescriptionService descriptionService, PageNodeContainer src, ImportConfig config) {
        this.path = path;
        this.navigationService = navigationService;
        this.navigationKey = navigationKey;
        this.portalLocale = portalLocale;
        this.descriptionService = descriptionService;
        this.src = src;
        this.config = config;
    }

    public ImportConfig getConfig() {
        return this.config;
    }

    public NodeContext<?> perform() {
        NavigationContext navigationCtx = this.navigationService.loadNavigation(this.navigationKey);
        if (navigationCtx != null) {
            NodeContext<NodeContext<?>> root;
            NodeContext<NodeContext<?>> from = root = this.navigationService.loadNode(NodeModel.SELF_MODEL, navigationCtx, GenericScope.branchShape(this.path), null);
            for (String name : this.path) {
                NodeContext<NodeContext<?>> a = from.get(name);
                from = a != null ? a : from.add(null, name);
            }
            HashMap labelMap = new HashMap();
            this.perform(this.src, from, labelMap);
            this.navigationService.saveNode(root, null);
            for (Map.Entry entry : labelMap.entrySet()) {
                String id = ((NodeContext)entry.getKey()).getId();
                this.descriptionService.setDescriptions(id, (Map)entry.getValue());
            }
            return from;
        }
        return null;
    }

    private void perform(PageNodeContainer src, NodeContext<?> dst, Map<NodeContext<?>, Map<Locale, Described.State>> labelMap) {
        this.navigationService.rebaseNode(dst, Scope.CHILDREN, null);
        ListDiff diff = new ListDiff(PAGE_NODE_CONTAINER_ADAPTER, NODE_ADAPTER);
        ArrayList<PageNode> srcChildren = src.getNodes();
        ListChangeIterator<PageNodeContainer, NodeContext<?>, String> it = diff.iterator(src, dst);
        class Change {
            final ListChangeType type;
            final String name;
            final int index1;
            final int index2;

            Change(ListChangeType type, String name, int index1, int index2) {
                this.type = type;
                this.name = name;
                this.index1 = index1;
                this.index2 = index2;
            }
        }
        LinkedList<Change> foo = new LinkedList<Change>();
        while (it.hasNext()) {
            ListChangeType type = it.next();
            foo.add(new Change(type, it.getElement(), it.getIndex1(), it.getIndex2()));
        }
        NodeContext<?> previousChild = null;
        for (Change change : foo) {
            PageNode srcChild = src.getNode(change.name);
            NodeContext<?> dstChild = dst.get(change.name);
            switch (change.type) {
                case SAME: {
                    this.perform(srcChild, dstChild, labelMap);
                    if (this.config.updatedSame) {
                        this.update(srcChild, dstChild, labelMap);
                    }
                    previousChild = dstChild;
                    break;
                }
                case REMOVE: {
                    if (dst.getNode(change.name) != null || !this.config.createMissing) break;
                    previousChild = this.add(srcChild, previousChild, dst, labelMap);
                    break;
                }
                case ADD: {
                    if (src.getNode(change.name) != null) {
                        if (this.config.updatedSame) {
                            this.update(srcChild, dstChild, labelMap);
                        }
                        previousChild = dstChild;
                        break;
                    }
                    if (this.config.destroyOrphan) {
                        dstChild.removeNode();
                        break;
                    }
                    previousChild = dstChild;
                }
            }
        }
    }

    private NodeContext<?> add(PageNode target, NodeContext<?> previous, NodeContext<?> parent, Map<NodeContext<?>, Map<Locale, Described.State>> labelMap) {
        ArrayList<PageNode> targetChildren;
        HashMap<Locale, Described.State> description;
        I18NString labels = target.getLabels();
        if (labels.isSimple()) {
            description = null;
        } else if (labels.isEmpty()) {
            description = null;
        } else {
            description = new HashMap<Locale, Described.State>();
            for (Map.Entry entry : labels.getExtended(this.portalLocale).entrySet()) {
                description.put(entry.getKey(), new Described.State((String)entry.getValue(), null));
            }
        }
        String name = target.getName();
        int index = previous != null ? parent.get(previous.getName()).getIndex() + 1 : 0;
        NodeContext<?> child = parent.add((Integer)index, name);
        NodeState state = target.getState();
        child.setState(state);
        if (description != null) {
            labelMap.put(child, description);
        }
        if ((targetChildren = target.getNodes()) != null) {
            NodeContext<?> targetPrevious = null;
            for (PageNode targetChild : targetChildren) {
                targetPrevious = this.add(targetChild, targetPrevious, child, labelMap);
            }
        }
        return child;
    }

    private void update(PageNode src, NodeContext<?> target, Map<NodeContext<?>, Map<Locale, Described.State>> labelMap) {
        HashMap<Locale, Described.State> description;
        target.setState(src.getState());
        I18NString labels = src.getLabels();
        if (labels.isSimple()) {
            description = null;
        } else if (labels.isEmpty()) {
            description = null;
        } else {
            description = new HashMap<Locale, Described.State>();
            for (Map.Entry entry : labels.getExtended(this.portalLocale).entrySet()) {
                description.put(entry.getKey(), new Described.State((String)entry.getValue(), null));
            }
        }
        if (description != null) {
            labelMap.put(target, description);
        } else {
            labelMap.put(target, Collections.emptyMap());
        }
    }
}

