/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.idm.GroupDAOImpl;
import org.exoplatform.services.organization.idm.MembershipImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.gatein.common.logging.LogLevel;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;

public class IDMMembershipListAccess
implements ListAccess<Membership>,
Serializable {
    private static Logger log = LoggerFactory.getLogger(IDMMembershipListAccess.class);
    private final org.picketlink.idm.api.Group group;
    private final User user;
    private int size = -1;
    private Membership lastExisting;
    private final boolean usePaginatedQuery;
    private List<Role> fullResults;

    public IDMMembershipListAccess(org.picketlink.idm.api.Group group, boolean usePaginatedQuery) {
        this.group = group;
        this.user = null;
        this.usePaginatedQuery = usePaginatedQuery;
    }

    public IDMMembershipListAccess(User user, boolean usePaginatedQuery) {
        this.group = null;
        this.user = user;
        this.usePaginatedQuery = usePaginatedQuery;
    }

    public Membership[] load(int index, int length) throws Exception {
        int i;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "load", new Object[]{"index", index, "length", length});
        }
        List<Role> roles = null;
        if (this.fullResults != null) {
            int toIndex = index + length > this.fullResults.size() ? this.fullResults.size() : index + length;
            roles = this.fullResults.subList(index, toIndex);
        } else {
            IdentitySearchCriteria crit = this.usePaginatedQuery ? new IdentitySearchCriteriaImpl().page(index, length) : new IdentitySearchCriteriaImpl().page(0, this.size);
            crit.sort(SortOrder.ASCENDING);
            if (this.group != null) {
                roles = new LinkedList<Role>(this.getIDMService().getIdentitySession().getRoleManager().findRoles((IdentityType)this.group, null, crit));
            } else if (this.user != null) {
                roles = new LinkedList<Role>(this.getIDMService().getIdentitySession().getRoleManager().findRoles((IdentityType)this.user, null, crit));
            }
            if (!this.usePaginatedQuery) {
                this.fullResults = roles;
                int toIndex = index + length > this.fullResults.size() ? this.fullResults.size() : index + length;
                roles = this.fullResults.subList(index, toIndex);
            }
        }
        Membership[] memberships = new Membership[length];
        int size = roles.size();
        for (i = 0; i < size; ++i) {
            Role role = roles.get(i);
            Group exoGroup = ((GroupDAOImpl)this.getOrganizationService().getGroupHandler()).convertGroup(role.getGroup());
            MembershipImpl memb = new MembershipImpl();
            memb.setGroupId(exoGroup.getId());
            memb.setUserName(role.getUser().getId());
            if (role.getRoleType().getName().equals("JBOSS_IDENTITY_MEMBERSHIP")) {
                memb.setMembershipType(this.getOrganizationService().getConfiguration().getAssociationMembershipType());
            } else {
                memb.setMembershipType(role.getRoleType().getName());
            }
            this.lastExisting = memb;
            memberships[i] = memb;
        }
        if (length > size) {
            while (i < length) {
                memberships[i] = this.lastExisting;
                ++i;
            }
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "load", memberships);
        }
        return memberships;
    }

    public int getSize() throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "getSize", null);
        }
        int result = 0;
        if (this.size < 0) {
            if (this.group != null && this.user == null) {
                result = this.getIDMService().getIdentitySession().getRoleManager().getRolesCount((IdentityType)this.group, null, null);
            } else if (this.group == null && this.user != null) {
                result = this.getIDMService().getIdentitySession().getRoleManager().getRolesCount((IdentityType)this.user, null, null);
            }
            this.size = result;
        } else {
            result = this.size;
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "getSize", result);
        }
        return result;
    }

    PicketLinkIDMService getIDMService() {
        return (PicketLinkIDMService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PicketLinkIDMService.class);
    }

    PicketLinkIDMOrganizationServiceImpl getOrganizationService() {
        return (PicketLinkIDMOrganizationServiceImpl)((Object)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class));
    }
}

