/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.organization.BaseOrganizationService;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;
import org.exoplatform.services.organization.idm.Config;
import org.exoplatform.services.organization.idm.GroupDAOImpl;
import org.exoplatform.services.organization.idm.IDMTransactionSyncListener;
import org.exoplatform.services.organization.idm.MembershipDAOImpl;
import org.exoplatform.services.organization.idm.MembershipTypeDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.PicketLinkIDMServiceImpl;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.idm.UserProfileDAOImpl;
import org.exoplatform.services.organization.idm.cache.CacheableGroupHandlerImpl;
import org.exoplatform.services.organization.idm.cache.CacheableMembershipHandlerImpl;
import org.exoplatform.services.organization.idm.cache.CacheableMembershipTypeHandlerImpl;
import org.exoplatform.services.organization.idm.cache.CacheableUserHandlerImpl;
import org.exoplatform.services.organization.idm.cache.CacheableUserProfileHandlerImpl;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.transaction.JTAUserTransactionLifecycleListener;
import org.gatein.common.transaction.JTAUserTransactionLifecycleService;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.Transaction;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picocontainer.Startable;

public class PicketLinkIDMOrganizationServiceImpl
extends BaseOrganizationService
implements Startable,
ComponentRequestLifecycle {
    private PicketLinkIDMServiceImpl idmService_;
    public static final String CONFIGURATION_OPTION = "configuration";
    private Config configuration = new Config();
    private JTAUserTransactionLifecycleService jtaTransactionLifecycleService;
    private OrganizationCacheHandler organizationCacheHandler;
    private static final Logger log = LoggerFactory.getLogger(PicketLinkIDMOrganizationServiceImpl.class);
    private static final boolean traceLoggingEnabled = log.isTraceEnabled();
    private volatile boolean acceptComponentRequestCall;

    public PicketLinkIDMOrganizationServiceImpl(InitParams params, PicketLinkIDMService idmService, JTAUserTransactionLifecycleService jtaTransactionLifecycleService, OrganizationCacheHandler organizationCacheHandler) throws Exception {
        ObjectParameter configurationParam;
        this.idmService_ = (PicketLinkIDMServiceImpl)idmService;
        this.jtaTransactionLifecycleService = jtaTransactionLifecycleService;
        this.organizationCacheHandler = organizationCacheHandler;
        if (params != null && (configurationParam = params.getObjectParam(CONFIGURATION_OPTION)) != null) {
            this.configuration = (Config)configurationParam.getObject();
            this.initConfiguration(params);
        }
        if (organizationCacheHandler != null && (this.configuration == null || this.configuration.isUseCache())) {
            this.groupDAO_ = new CacheableGroupHandlerImpl(organizationCacheHandler, this, idmService, this.configuration.isCountPaginatedUsers());
            this.userDAO_ = new CacheableUserHandlerImpl(organizationCacheHandler, this, idmService);
            this.userProfileDAO_ = new CacheableUserProfileHandlerImpl(organizationCacheHandler, this, idmService);
            this.membershipDAO_ = new CacheableMembershipHandlerImpl(organizationCacheHandler, this, idmService, true);
            this.membershipTypeDAO_ = new CacheableMembershipTypeHandlerImpl(organizationCacheHandler, this, idmService);
        } else {
            this.groupDAO_ = new GroupDAOImpl(this, idmService);
            this.userDAO_ = new UserDAOImpl(this, idmService);
            this.userProfileDAO_ = new UserProfileDAOImpl(this, idmService);
            this.membershipDAO_ = new MembershipDAOImpl(this, idmService);
            this.membershipTypeDAO_ = new MembershipTypeDAOImpl(this, idmService);
        }
    }

    public PicketLinkIDMOrganizationServiceImpl(InitParams params, PicketLinkIDMService idmService, JTAUserTransactionLifecycleService jtaTransactionLifecycleService) throws Exception {
        this(params, idmService, jtaTransactionLifecycleService, null);
    }

    public final Group getJBIDMGroup(String groupId) throws Exception {
        String[] ids = groupId.split("/");
        String name = ids[ids.length - 1];
        String parentId = null;
        if (groupId.contains("/")) {
            parentId = groupId.substring(0, groupId.lastIndexOf("/"));
        }
        String plGroupName = this.configuration.getPLIDMGroupName(name);
        return this.idmService_.getIdentitySession().getPersistenceManager().findGroup(plGroupName, this.getConfiguration().getGroupType(parentId));
    }

    public void start() {
        try {
            if (this.configuration.isUseJTA()) {
                this.jtaTransactionLifecycleService.registerListener((JTAUserTransactionLifecycleListener)new IDMTransactionSyncListener(this.idmService_));
            }
            this.acceptComponentRequestCall = true;
            RequestLifeCycle.begin((ComponentRequestLifecycle)this);
            super.start();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public void startRequest(ExoContainer container) {
        block9: {
            if (!this.acceptComponentRequestCall) {
                return;
            }
            try {
                if (this.configuration.isUseJTA()) {
                    if (traceLoggingEnabled) {
                        log.trace((Object)"Starting UserTransaction in method startRequest");
                    }
                    try {
                        if (this.jtaTransactionLifecycleService.getUserTransaction().getStatus() != 6 && this.jtaTransactionLifecycleService.getUserTransaction().getStatus() != 0) {
                            this.jtaTransactionLifecycleService.finishJTATransaction();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    this.jtaTransactionLifecycleService.beginJTATransaction();
                    break block9;
                }
                if (!this.idmService_.getIdentitySession().getTransaction().isActive()) {
                    this.idmService_.getIdentitySession().beginTransaction();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void flush() {
        if (this.configuration.isUseJTA()) {
            if (traceLoggingEnabled) {
                log.trace((Object)"Flushing UserTransaction in method flush");
            }
            try {
                if (this.jtaTransactionLifecycleService.getUserTransaction().getStatus() == 0) {
                    this.idmService_.getIdentitySession().save();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                if (this.idmService_.getIdentitySession().getTransaction().isActive()) {
                    this.idmService_.getIdentitySession().save();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.recoverFromIDMError(e);
            }
        }
    }

    public void endRequest(ExoContainer container) {
        if (!this.acceptComponentRequestCall) {
            return;
        }
        if (this.configuration.isUseJTA()) {
            if (traceLoggingEnabled) {
                log.trace((Object)"Finishing UserTransaction in method endRequest");
            }
            try {
                this.jtaTransactionLifecycleService.finishJTATransaction();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                Transaction transaction = this.idmService_.getIdentitySession().getTransaction();
                if (transaction.isActive()) {
                    transaction.commit();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.recoverFromIDMError(e);
            }
        }
    }

    public boolean isStarted(ExoContainer container) {
        try {
            if (this.configuration.isUseJTA()) {
                return this.jtaTransactionLifecycleService.getUserTransaction() == null ? false : this.jtaTransactionLifecycleService.getUserTransaction().getStatus() == 0;
            }
            return this.idmService_.getIdentitySession() == null || this.idmService_.getIdentitySession().getTransaction() == null ? false : this.idmService_.getIdentitySession().getTransaction().isActive();
        }
        catch (Exception e) {
            log.error((Object)"Error while checking on Transaction status : ", (Throwable)e);
            return false;
        }
    }

    public void recoverFromIDMError(Exception e) {
        block7: {
            try {
                Transaction idmTransaction = this.idmService_.getIdentitySession().getTransaction();
                if (idmTransaction != null && idmTransaction.isActive()) {
                    try {
                        log.info((Object)"IDM Transaction rollback");
                        idmTransaction.rollback();
                        log.info((Object)"IDM Transaction has been rolled-backed");
                    }
                    catch (Exception e1) {
                        log.warn((Object)"Error during IDM Transaction rollback.", (Throwable)e1);
                    }
                    try {
                        log.info((Object)"IDM Transaction restart");
                        idmTransaction.start();
                        log.info((Object)"IDM Transaction restarted");
                    }
                    catch (Exception e1) {
                        log.warn((Object)"Error during IDM Transaction restart, a new transaction will be started", (Throwable)e1);
                        this.idmService_.getIdentitySession().beginTransaction();
                        log.info((Object)"New IDM Transaction started");
                    }
                    break block7;
                }
                log.info((Object)"New IDM Transaction start");
                this.idmService_.getIdentitySession().beginTransaction();
                log.info((Object)"New IDM Transaction started");
            }
            catch (Exception e1) {
                log.warn((Object)"Error during recovery of old error", (Throwable)e1);
            }
        }
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    public void clearCaches() {
        if (this.organizationCacheHandler != null && (this.configuration == null || this.configuration.isUseCache())) {
            if (this.groupDAO_ != null && this.groupDAO_ instanceof CacheableGroupHandlerImpl) {
                ((CacheableGroupHandlerImpl)this.groupDAO_).clearCache();
            }
            if (this.userDAO_ != null && this.userDAO_ instanceof CacheableGroupHandlerImpl) {
                ((CacheableGroupHandlerImpl)this.userDAO_).clearCache();
            }
            if (this.userProfileDAO_ != null && this.userProfileDAO_ instanceof CacheableGroupHandlerImpl) {
                ((CacheableGroupHandlerImpl)this.userProfileDAO_).clearCache();
            }
            if (this.membershipDAO_ != null && this.membershipDAO_ instanceof CacheableGroupHandlerImpl) {
                ((CacheableGroupHandlerImpl)this.membershipDAO_).clearCache();
            }
            if (this.membershipTypeDAO_ != null && this.membershipTypeDAO_ instanceof CacheableGroupHandlerImpl) {
                ((CacheableGroupHandlerImpl)this.membershipTypeDAO_).clearCache();
            }
        }
    }

    public void setConfiguration(Config configuration) {
        this.configuration = configuration;
    }

    private void initConfiguration(InitParams params) {
        IdentityConfigurationMetaData configMD = this.idmService_.getConfigMD();
        List identityStores = null;
        if (configMD != null) {
            identityStores = configMD.getIdentityStores();
        }
        if (identityStores != null && identityStores.size() > 1) {
            this.configuration.setCountPaginatedUsers(false);
            this.configuration.setSkipPaginationInMembershipQuery(true);
        } else {
            this.configuration.setCountPaginatedUsers(true);
            this.configuration.setSkipPaginationInMembershipQuery(false);
        }
    }
}

