/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.idm.impl.cache.infinispan;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gatein.portal.idm.impl.cache.infinispan.tree.Fqn;
import org.gatein.portal.idm.impl.cache.infinispan.tree.IDMTreeCacheImpl;
import org.gatein.portal.idm.impl.cache.infinispan.tree.Node;
import org.gatein.portal.idm.impl.cache.infinispan.tree.TreeCache;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.picketlink.idm.common.exception.IdentityException;

public abstract class AbstractInfinispanCacheProvider {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private TreeCache cache;
    public static final String CONFIG_FILE_OPTION = "cache.configFile";
    public static final String CONFIG_NAME_OPTION = "cache.configName";
    public static final String CONFIG_CACHE_REGISTRY_OPTION = "cache.cacheRegistryName";
    public static final String NULL_NS_NODE = "PL_COMMON_NS";
    public static final String NODE_COMMON_ROOT = "COMMON_ROOT";

    public void initialize(Map<String, String> properties, Object configurationRegistry) {
        Cache infinispanCache;
        String registryName = properties.get(CONFIG_CACHE_REGISTRY_OPTION);
        if (registryName != null) {
            try {
                this.cache = this.getCacheFromRegistry(configurationRegistry, registryName);
                return;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find Infinispan 'Cache' object in configuration registry with provided name: " + registryName, e);
            }
        }
        String configFile = properties.get(CONFIG_FILE_OPTION);
        String configName = properties.get(CONFIG_NAME_OPTION);
        if (configFile == null) {
            throw new IllegalArgumentException("Cannot find 'cache.configFile' in passed properties. Failed to initialize cache provider.");
        }
        if (configName == null) {
            throw new IllegalArgumentException("Cannot find 'cache.configName' in passed properties. Failed to initialize cache provider.");
        }
        try {
            DefaultCacheManager manager = new DefaultCacheManager(configFile, true);
            infinispanCache = manager.getCache(configName);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to initialize cache due to IO error", ioe);
        }
        this.cache = new IDMTreeCacheImpl(infinispanCache, false, -1L, -1L);
        this.log.info("Infinispan cache for Picketlink IDM created successfuly. cache name: " + infinispanCache.getName());
    }

    public void initialize(InputStream cacheConfigStream, String configName) {
        if (cacheConfigStream == null) {
            throw new IllegalArgumentException("Infinispan configuration InputStream is null");
        }
        try {
            DefaultCacheManager manager = new DefaultCacheManager(cacheConfigStream, true);
            Cache infinispanCache = manager.getCache(configName);
            this.cache = new IDMTreeCacheImpl(infinispanCache, false, -1L, -1L);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to initialize cache due to IO error", ioe);
        }
        this.log.info("Infinispan cache for Picketlink IDM created successfuly. cache name: " + this.cache.getCache().getName());
    }

    public void initialize(Cache infinispanCache, boolean attachLifespanToLeafNodes, long leafNodeLifespan, long staleNodesLinksCleanerDelay) {
        this.cache = new IDMTreeCacheImpl(infinispanCache, attachLifespanToLeafNodes, leafNodeLifespan, staleNodesLinksCleanerDelay);
        ComponentStatus status = infinispanCache.getStatus();
        if (status.startAllowed()) {
            this.cache.getCache().start();
        }
        this.log.info("Infinispan cache for Picketlink IDM created successfuly. cache name: " + this.cache.getCache().getName());
    }

    public void invalidate(String ns) {
        boolean success = this.getCache().removeNode(this.getNamespacedFqn(ns).toString());
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(this.toString() + "Invalidating namespace:" + ns + "; success=" + success);
        }
    }

    public void invalidateAll() {
        boolean success = this.getCache().removeNode("/" + this.getRootNode());
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(this.toString() + "Invalidating whole cache - success=" + success);
        }
    }

    public String printContent() {
        return this.getCache().printTree();
    }

    public String getNamespace(String commonId) {
        if (commonId == null) {
            return NODE_COMMON_ROOT;
        }
        return commonId;
    }

    public String getNamespace(String commonId, String sessionId) {
        if (sessionId == null) {
            return this.getNamespace(commonId);
        }
        return commonId + "/" + sessionId;
    }

    protected abstract String getRootNode();

    protected abstract TreeCache getCacheFromRegistry(Object var1, String var2) throws IdentityException;

    protected StringBuilder getNamespacedFqn(String ns) {
        String namespace = this.getNamespaceForFqn(ns);
        return new StringBuilder(47).append(this.getRootNode()).append('/').append(namespace);
    }

    private String getNamespaceForFqn(String ns) {
        if (ns == null) {
            return NULL_NS_NODE;
        }
        return ns;
    }

    protected Fqn getFqn(String ns, String node, Object o) {
        if (o == null) {
            o = "null";
        }
        Object[] fqnElements = new Object[]{this.getRootNode(), this.getNamespaceForFqn(ns), node, o.toString()};
        return Fqn.fromElements(fqnElements);
    }

    protected Fqn getFqn(String ns, String node) {
        Object[] fqnElements = new Object[]{this.getRootNode(), this.getNamespaceForFqn(ns), node};
        return Fqn.fromElements(fqnElements);
    }

    protected TreeCache getCache() {
        return this.cache;
    }

    protected Node addNode(Fqn nodeFqn) {
        return this.getCache().getTransientLeafNode(nodeFqn);
    }

    protected Node getNode(Fqn nodeFqn) {
        return this.getCache().getNode(nodeFqn);
    }

    protected void removeNode(Fqn nodeFqn) {
        this.getCache().removeNode(nodeFqn);
    }
}

