/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.idm.impl.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gatein.portal.idm.IdentityStoreSource;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.session.managers.RoleManagerImpl;
import org.picketlink.idm.impl.repository.FallbackIdentityStoreRepository;
import org.picketlink.idm.impl.repository.RepositoryIdentityStoreSessionImpl;
import org.picketlink.idm.impl.store.SimpleIdentityStoreInvocationContext;
import org.picketlink.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreMappingMetaData;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.AttributeStore;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

public class ExoFallbackIdentityStoreRepository
extends FallbackIdentityStoreRepository {
    private static Logger log = Logger.getLogger(ExoFallbackIdentityStoreRepository.class.getName());
    public static final String OPTION_MANDATORY_OBJECTS = "mandatoryStoredObjects";
    private Map<String, IdentityStore> mandatoryStores = new HashMap<String, IdentityStore>();
    private Set<String> mandatoryStoresObjects = new HashSet<String>();
    private final Set<IdentityStore> configuredIdentityStores = new HashSet<IdentityStore>();

    public ExoFallbackIdentityStoreRepository(String id) {
        super(id);
    }

    public void bootstrap(IdentityRepositoryConfigurationContext configurationContext, Map<String, IdentityStore> bootstrappedIdentityStores, Map<String, AttributeStore> bootstrappedAttributeStores) throws IdentityException {
        super.bootstrap(configurationContext, bootstrappedIdentityStores, bootstrappedAttributeStores);
        if (this.getIdentityStoreMappings().size() > 0) {
            this.configuredIdentityStores.addAll(this.getMappedIdentityStores());
        }
        IdentityRepositoryConfigurationMetaData configurationMD = configurationContext.getRepositoryConfigurationMetaData();
        List mappingMDs = configurationMD.getIdentityStoreToIdentityObjectTypeMappings();
        for (IdentityStoreMappingMetaData mappingMD : mappingMDs) {
            String[] identityTypeIds;
            String identityTypeIdsValue = mappingMD.getOptionSingleValue(OPTION_MANDATORY_OBJECTS);
            if (identityTypeIdsValue == null || identityTypeIdsValue.trim().isEmpty()) continue;
            identityTypeIdsValue = identityTypeIdsValue.trim();
            String identityStoreId = mappingMD.getIdentityStoreId();
            for (String identityTypeId : identityTypeIds = identityTypeIdsValue.split(",")) {
                if ((identityTypeId = identityTypeId.trim()).isEmpty()) continue;
                if (!mappingMD.getIdentityObjectTypeMappings().contains(identityTypeId)) {
                    log.warning("'mandatoryStoredObjects' parameter contains an identityTypeId that is not mapped in Store : " + identityStoreId);
                    continue;
                }
                if (this.mandatoryStoresObjects.contains(identityTypeId)) {
                    log.warning("'mandatoryStoredObjects' parameter contains an identityTypeId that is already defined as mandatory in a Store. This parameter value will be ignored in store: " + identityStoreId);
                    continue;
                }
                Iterator<IdentityStore> identityStoresIterator = this.configuredIdentityStores.iterator();
                do {
                    IdentityStore identityStore;
                    if (!(identityStore = identityStoresIterator.next()).getId().equals(identityStoreId)) continue;
                    this.mandatoryStores.put(identityTypeId, identityStore);
                } while (identityStoresIterator.hasNext() && !this.mandatoryStores.containsKey(identityTypeId));
                this.mandatoryStoresObjects.add(identityTypeId);
            }
        }
    }

    List<IdentityStore> resolveIdentityStores(IdentityObjectType iot) {
        LinkedList<IdentityStore> ids = null;
        try {
            ids = this.getIdentityStores(iot);
        }
        catch (IdentityException e) {
            if (this.isAllowNotDefinedAttributes()) {
                ids = new LinkedList<IdentityStore>();
                ids.add(this.defaultIdentityStore);
                return ids;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IllegalStateException("Used IdentityObjectType not mapped. Consider using allowNotDefinedIdentityObjectTypes repository option switch: " + iot);
        }
        if (ids == null || ids.size() == 0) {
            ids = new LinkedList();
            ids.add(this.defaultIdentityStore);
        } else {
            boolean isReadOnly = true;
            for (IdentityStore identityStore : ids) {
                isReadOnly &= this.isIdentityStoreReadOnly(identityStore);
            }
            if (isReadOnly) {
                ids.add(this.defaultIdentityStore);
            }
        }
        return ids;
    }

    IdentityStoreInvocationContext resolveInvocationContext(IdentityStore targetStore, IdentityStoreInvocationContext invocationCtx) {
        return this.resolveInvocationContext(targetStore.getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveInvocationContext(AttributeStore targetStore, IdentityStoreInvocationContext invocationCtx) {
        return this.resolveInvocationContext(targetStore.getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveInvocationContext(String id, IdentityStoreInvocationContext invocationCtx) {
        RepositoryIdentityStoreSessionImpl repoSession = (RepositoryIdentityStoreSessionImpl)invocationCtx.getIdentityStoreSession();
        IdentityStoreSession targetSession = repoSession.getIdentityStoreSession(id);
        return new SimpleIdentityStoreInvocationContext(targetSession, invocationCtx.getRealmId(), String.valueOf(((Object)((Object)this)).hashCode()));
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        try {
            Collection objects;
            List<IdentityStore> mappedStores = this.resolveIdentityStores(identity.getIdentityType());
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
            if (mappedStores.size() == 1 && mappedStores.contains(this.defaultIdentityStore)) {
                return this.defaultIdentityStore.findIdentityObject(defaultCtx, identity, relationshipType, parent, criteria);
            }
            IdentitySearchCriteriaImpl c = null;
            if (criteria != null) {
                c = new IdentitySearchCriteriaImpl(criteria);
                c.setPaged(false);
            }
            Collection<Object> results = new LinkedList();
            HashSet merged = new HashSet();
            for (IdentityStore mappedStore : mappedStores) {
                IdentityStoreInvocationContext mappedCtx = this.resolveInvocationContext(mappedStore, invocationCxt);
                if (!this.hasIdentityObject(mappedCtx, mappedStore, identity) || relationshipType != null && RoleManagerImpl.ROLE.getName().equals(relationshipType.getName()) && !mappedStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
                results = mappedStore.findIdentityObject(mappedCtx, identity, relationshipType, parent, (IdentityObjectSearchCriteria)c);
                merged.addAll(results);
            }
            if (!mappedStores.contains(this.defaultIdentityStore) && (objects = this.defaultIdentityStore.findIdentityObject(defaultCtx, identity, relationshipType, parent, (IdentityObjectSearchCriteria)c)) != null && objects.size() != 0) {
                merged.addAll(objects);
            }
            if (criteria == null) {
                results = merged;
            } else {
                LinkedList<IdentityObject> processed = new LinkedList<IdentityObject>(merged);
                if (criteria.isSorted()) {
                    this.sortByName(processed, criteria.isAscending());
                }
                results = processed;
                if (criteria.isPaged()) {
                    results = this.cutPageFromResults(processed, criteria);
                }
            }
            return results;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String name, IdentityObjectType identityObjectType) throws IdentityException {
        IdentityStoreInvocationContext targetCtx;
        IdentityStore targetStore;
        IdentityObject mandatoryIO = null;
        List<IdentityStore> targetStores = this.resolveIdentityStores(identityObjectType);
        IdentityObject io = null;
        Iterator<IdentityStore> iterator = targetStores.iterator();
        while (iterator.hasNext() && (io = (targetStore = iterator.next()).findIdentityObject(targetCtx = this.resolveInvocationContext(targetStore, invocationContext), name, identityObjectType)) == null) {
        }
        if (io != null) {
            IdentityStoreInvocationContext mappedContext;
            IdentityStore mandatoryStore;
            IdentityStoreInvocationContext defaultInvocationContext = this.resolveInvocationContext(this.defaultIdentityStore, invocationContext);
            if (!this.isFirstlyCreatedIn(defaultInvocationContext, this.defaultIdentityStore, io) && this.mandatoryStoresObjects.contains(identityObjectType.getName()) && (mandatoryIO = (mandatoryStore = this.mandatoryStores.get(identityObjectType.getName())).findIdentityObject(mappedContext = this.resolveInvocationContext(mandatoryStore, invocationContext), name, identityObjectType)) == null) {
                return null;
            }
            return io;
        }
        io = this.defaultIdentityStore.findIdentityObject(this.resolveInvocationContext(this.defaultIdentityStore, invocationContext), name, identityObjectType);
        return io;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String id) throws IdentityException {
        IdentityStoreInvocationContext defaultInvocationContext = this.resolveInvocationContext(this.defaultIdentityStore, invocationContext);
        for (IdentityStore identityStore : this.getIdentityStoreMappings().values()) {
            IdentityStoreInvocationContext targetCtx;
            IdentityObject io = identityStore.findIdentityObject(targetCtx = this.resolveInvocationContext(identityStore, invocationContext), id);
            if (io == null) continue;
            if (!this.isFirstlyCreatedIn(defaultInvocationContext, this.defaultIdentityStore, io) && this.mandatoryStoresObjects.contains(io.getIdentityType().getName())) {
                IdentityStore mandatoryStore = this.mandatoryStores.get(io.getIdentityType().getName());
                if (identityStore.getId().equals(mandatoryStore.getId())) {
                    return io;
                }
                IdentityStoreInvocationContext mappedContext = this.resolveInvocationContext(mandatoryStore, invocationContext);
                IdentityObject mandatoryIO = null;
                try {
                    mandatoryIO = mandatoryStore.findIdentityObject(mappedContext, id);
                }
                catch (IdentityException e) {
                    log.log(Level.SEVERE, "Failed to find IdentityObject in target store: ", e);
                }
                if (mandatoryIO == null) {
                    return null;
                }
            }
            return io;
        }
        return this.defaultIdentityStore.findIdentityObject(invocationContext, id);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        IdentityStoreInvocationContext targetCtx;
        List<IdentityStore> targetStores = this.resolveIdentityStores(identityType);
        Collection<Object> results = new LinkedList();
        Collection defaultIOs = new LinkedList();
        IdentityStoreInvocationContext defaultInvocationContext = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
        if (targetStores.size() == 1 && targetStores.contains(this.defaultIdentityStore)) {
            LinkedList<IdentityObject> resx = new LinkedList();
            try {
                resx = this.defaultIdentityStore.findIdentityObject(defaultInvocationContext, identityType, criteria);
            }
            catch (IdentityException e) {
                log.log(Level.SEVERE, "Exception occurred: ", e);
            }
            return resx;
        }
        IdentitySearchCriteriaImpl c = null;
        if (criteria != null) {
            c = new IdentitySearchCriteriaImpl(criteria);
            c.setPaged(false);
            Map attrs = c.getValues();
            Iterator it = attrs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!"enabled".equals(entry.getKey()) || ((String[])entry.getValue()).length != 0) continue;
                it.remove();
            }
        }
        if ((defaultIOs = this.defaultIdentityStore.findIdentityObject(defaultInvocationContext, identityType, (IdentityObjectSearchCriteria)c)).size() == 0 && targetStores.size() == 1) {
            Object resx = new LinkedList();
            try {
                IdentityStore targetStore = targetStores.get(0);
                targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
                resx = targetStore.findIdentityObject(targetCtx, identityType, criteria);
            }
            catch (IdentityException e) {
                log.log(Level.SEVERE, "Exception occurred: ", e);
            }
            return resx;
        }
        for (IdentityStore targetStore : targetStores) {
            try {
                targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
                Collection identityObjects = targetStore.findIdentityObject(targetCtx, identityType, (IdentityObjectSearchCriteria)c);
                if (this.mandatoryStoresObjects.contains(identityType.getName())) {
                    IdentityStore mandatoryStore = this.mandatoryStores.get(identityType.getName());
                    if (!targetStore.getId().equals(mandatoryStore.getId())) {
                        IdentityStoreInvocationContext mappedContext = this.resolveInvocationContext(mandatoryStore, invocationCtx);
                        Iterator identityObjectsIterator = identityObjects.iterator();
                        while (identityObjectsIterator.hasNext()) {
                            IdentityObject identityObject = (IdentityObject)identityObjectsIterator.next();
                            if (this.isFirstlyCreatedIn(defaultInvocationContext, this.defaultIdentityStore, identityObject) || this.hasIdentityObject(mappedContext, mandatoryStore, identityObject)) continue;
                            identityObjectsIterator.remove();
                        }
                    }
                }
                results.addAll(identityObjects);
            }
            catch (IdentityException e) {
                log.log(Level.SEVERE, "Exception occurred: ", e);
                throw e;
            }
        }
        HashSet merged = new HashSet();
        merged.addAll(results);
        if (this.mandatoryStoresObjects.contains(identityType.getName())) {
            IdentityStore mandatoryStore = this.mandatoryStores.get(identityType.getName());
            if (!this.defaultIdentityStore.getId().equals(mandatoryStore.getId())) {
                IdentityStoreInvocationContext mappedContext = this.resolveInvocationContext(mandatoryStore, invocationCtx);
                Iterator identityObjectsIterator = defaultIOs.iterator();
                while (identityObjectsIterator.hasNext()) {
                    IdentityObject identityObject = (IdentityObject)identityObjectsIterator.next();
                    if (this.isFirstlyCreatedIn(defaultInvocationContext, this.defaultIdentityStore, identityObject) || this.hasIdentityObject(mappedContext, mandatoryStore, identityObject)) continue;
                    identityObjectsIterator.remove();
                    this.defaultIdentityStore.removeIdentityObject(defaultInvocationContext, identityObject);
                }
            }
        }
        merged.addAll(defaultIOs);
        if (criteria != null) {
            LinkedList<IdentityObject> processed = new LinkedList<IdentityObject>(merged);
            if (criteria.isSorted()) {
                this.sortByName(processed, criteria.isAscending());
            }
            results = processed;
            if (criteria.isPaged()) {
                results = this.cutPageFromResults(processed, criteria);
            }
        } else {
            results = merged;
        }
        return results;
    }

    private void sortByName(List<IdentityObject> objects, final boolean ascending) {
        Collections.sort(objects, new Comparator<IdentityObject>(){

            @Override
            public int compare(IdentityObject o1, IdentityObject o2) {
                if (ascending) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
        });
    }

    private List<IdentityObject> cutPageFromResults(List<IdentityObject> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<IdentityObject> results = new LinkedList<IdentityObject>();
        if (criteria.getMaxResults() == 0) {
            for (int i = criteria.getFirstResult(); i < objects.size(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        } else {
            for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        }
        return results;
    }

    private boolean isFirstlyCreatedIn(IdentityStoreInvocationContext mappedContext, IdentityStore targetStore, IdentityObject identityObject) throws IdentityException {
        if (targetStore instanceof IdentityStoreSource) {
            try {
                if (!this.mandatoryStoresObjects.contains(identityObject.getIdentityType().getName())) {
                    return true;
                }
                return ((IdentityStoreSource)targetStore).isFirstlyCreatedIn(mappedContext, identityObject);
            }
            catch (Exception e) {
                throw new IdentityException((Throwable)e);
            }
        }
        return false;
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityObjectType, IdentityObjectAttribute attribute) throws IdentityException {
        try {
            IdentityStoreInvocationContext mappedContext;
            IdentityStore mandatoryStore;
            Object supportedAttrs;
            if (this.mandatoryStoresObjects.contains(identityObjectType.getName()) && (supportedAttrs = (mandatoryStore = this.mandatoryStores.get(identityObjectType.getName())).getSupportedAttributeNames(mappedContext = this.resolveInvocationContext(mandatoryStore, invocationCtx), identityObjectType)).contains(attribute.getName()) && mandatoryStore.findIdentityObjectByUniqueAttribute(mappedContext, identityObjectType, attribute) == null) {
                return null;
            }
            List<IdentityStore> mappedStores = this.resolveIdentityStores(identityObjectType);
            IdentityObject result = null;
            for (IdentityStore mappedStore : mappedStores) {
                if (mappedStore == this.defaultAttributeStore) continue;
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(mappedStore, invocationCtx);
                Set supportedAttrs2 = mappedStore.getSupportedAttributeNames(targetCtx, identityObjectType);
                if (supportedAttrs2.contains(attribute.getName())) {
                    result = mappedStore.findIdentityObjectByUniqueAttribute(targetCtx, identityObjectType, attribute);
                }
                if (result == null) continue;
                return result;
            }
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
            if (this.isAllowNotDefinedAttributes()) {
                result = this.defaultAttributeStore.findIdentityObjectByUniqueAttribute(defaultCtx, identityObjectType, attribute);
            } else {
                Set supportedAttrs3 = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identityObjectType);
                if (supportedAttrs3.contains(attribute.getName())) {
                    result = this.defaultAttributeStore.findIdentityObjectByUniqueAttribute(defaultCtx, identityObjectType, attribute);
                }
            }
            return result;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }
}

