/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.impl;

import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.exoplatform.services.organization.ExtendedCloneable;
import org.exoplatform.services.organization.Group;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="EXO_GROUP")
public class GroupImpl
implements Group,
ExtendedCloneable {
    private static final long serialVersionUID = -5909516396351606340L;
    @Id
    private String id;
    @Column
    private String parentId;
    @Column
    private String groupName;
    @Column
    private String label;
    @Column(name="description")
    private String desc;

    public GroupImpl() {
    }

    public GroupImpl(String name) {
        this.groupName = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void setGroupName(String name) {
        this.groupName = name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String s) {
        this.label = s;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public void setDescription(String s) {
        this.desc = s;
    }

    public String toString() {
        return "Group[" + this.id + "|" + this.groupName + "]";
    }

    @Override
    public GroupImpl clone() {
        try {
            return (GroupImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupImpl group = (GroupImpl)o;
        return Objects.equals(this.id, group.id) && Objects.equals(this.parentId, group.parentId) && Objects.equals(this.groupName, group.groupName) && Objects.equals(this.label, group.label) && Objects.equals(this.desc, group.desc);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parentId, this.groupName, this.label, this.desc);
    }
}

