/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.SpecialOperation;
import com.google.caja.parser.quasiliteral.NodeTypeFilter;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.SpecialOpFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuleChain {
    private final List<Rule> rules = new ArrayList<Rule>();
    private final NodeTypeFilter nodeTypeFilter = new NodeTypeFilter(this);
    private final SpecialOpFilter specOpFilter = new SpecialOpFilter(this);

    public void add(Rule r) {
        this.rules.add(r);
        this.nodeTypeFilter.reset();
        this.specOpFilter.reset();
    }

    public List<Rule> getAllRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public List<Rule> applicableTo(ParseTreeNode node) {
        if (node instanceof SpecialOperation) {
            return this.specOpFilter.rulesFor(node);
        }
        return this.nodeTypeFilter.rulesFor(node);
    }
}

