/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Directive;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.util.Lists;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleQuasiNode
extends QuasiNode {
    private final Class<? extends ParseTreeNode> clazz;
    private final Object value;
    private final QuasiNode.Equivalence valueComparator;

    protected SimpleQuasiNode(Class<? extends ParseTreeNode> clazz, Object value, QuasiNode.Equivalence valueComparator, QuasiNode ... children) {
        super(children);
        this.clazz = clazz;
        this.value = value;
        this.valueComparator = valueComparator;
    }

    @Override
    protected boolean consumeSpecimens(List<ParseTreeNode> specimens, Map<String, ParseTreeNode> bindings) {
        if (specimens.isEmpty()) {
            return false;
        }
        if (this.matchSelf(specimens.get(0)) && this.matchChildren(specimens.get(0), bindings)) {
            specimens.remove(0);
            return true;
        }
        return false;
    }

    private boolean matchSelf(ParseTreeNode specimen) {
        return this.clazz == specimen.getClass() && this.valueComparator.equivalent(this.value, specimen.getValue());
    }

    private boolean matchChildren(ParseTreeNode specimen, Map<String, ParseTreeNode> bindings) {
        List<ParseTreeNode> specimenChildren = Lists.newArrayList(specimen.children());
        for (QuasiNode child : this.getChildren()) {
            if (child.consumeSpecimens(specimenChildren, bindings)) continue;
            return false;
        }
        return specimenChildren.isEmpty();
    }

    @Override
    protected boolean createSubstitutes(List<ParseTreeNode> substitutes, Map<String, ParseTreeNode> bindings) {
        List<ParseTreeNode> children = Lists.newArrayList();
        for (QuasiNode child : this.getChildren()) {
            if (child.createSubstitutes(children, bindings)) continue;
            return false;
        }
        if (Block.class.isAssignableFrom(this.clazz)) {
            int n = children.size();
            for (int i = 1; i < n; ++i) {
                ParseTreeNode child = children.get(i);
                if (!(child instanceof DirectivePrologue)) continue;
                if (children.get(0) instanceof DirectivePrologue) {
                    DirectivePrologue dp0 = (DirectivePrologue)children.get(0);
                    DirectivePrologue dp1 = (DirectivePrologue)child;
                    if (!dp1.children().isEmpty()) {
                        List<? extends Directive> all = Lists.newArrayList(dp0.children());
                        all.addAll(dp1.children());
                        children.set(0, new DirectivePrologue(FilePosition.span(dp0.getFilePosition(), dp1.getFilePosition()), all));
                    }
                    children.remove(i);
                    continue;
                }
                for (int j = i; j >= 1; --j) {
                    children.set(j, children.get(j - 1));
                }
                children.set(0, child);
            }
        }
        ParseTreeNode node = ParseTreeNodes.newNodeInstance(this.clazz, FilePosition.UNKNOWN, this.value, children);
        substitutes.add(node);
        return true;
    }

    public Class<? extends ParseTreeNode> getMatchedClass() {
        return this.clazz;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.clazz.getSimpleName() + (this.value == null ? "" : " : " + this.value);
    }
}

