/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.AbstractLockedDomainService;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.uri.LockedDomainPrefixGenerator;

@Singleton
public class HashLockedDomainService
extends AbstractLockedDomainService {
    private static final String classname = HashLockedDomainService.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final Map<String, String> lockedSuffixes;
    private Authority authority;
    private LockedDomainPrefixGenerator ldGen;
    private final Pattern authpattern = Pattern.compile("%authority%");
    private HashLockedDomainObserver ldObserver;
    public static final String LOCKED_DOMAIN_SUFFIX_KEY = "gadgets.uri.iframe.lockedDomainSuffix";

    @Inject
    public HashLockedDomainService(ContainerConfig config, @Named(value="shindig.locked-domain.enabled") boolean enabled, LockedDomainPrefixGenerator ldGen) {
        super(config, enabled);
        this.lockedSuffixes = Maps.newHashMap();
        this.ldGen = ldGen;
        if (enabled) {
            this.ldObserver = new HashLockedDomainObserver();
            config.addConfigObserver((ContainerConfig.ConfigObserver)this.ldObserver, true);
        }
    }

    @Override
    public String getLockedDomainForGadget(Gadget gadget, String container) throws GadgetException {
        container = this.getContainer(container);
        if (this.isEnabled() && !this.isExcludedFromLockedDomain(gadget, container) && (this.isGadgetReqestingLocking(gadget) || this.isDomainLockingEnforced(container))) {
            return this.getLockedDomain(gadget, container);
        }
        return null;
    }

    private String getLockedDomainPrefix(Gadget gadget) throws GadgetException {
        String ret = "";
        if (this.isEnabled()) {
            ret = this.ldGen.getLockedDomainPrefix(this.getLockedDomainParticipants(gadget));
        }
        return ret.toLowerCase();
    }

    @Override
    public boolean isGadgetValidForHost(String host, Gadget gadget, String container) {
        container = this.getContainer(container);
        if (this.isEnabled() && (this.isGadgetReqestingLocking(gadget) || this.isHostUsingLockedDomain(host) || this.isDomainLockingEnforced(container))) {
            String neededHost;
            if (this.isRefererCheckEnabled() && !this.isValidReferer(gadget, container)) {
                return false;
            }
            try {
                neededHost = this.getLockedDomain(gadget, container);
            }
            catch (GadgetException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Invalid host for call.", e);
                }
                return false;
            }
            return host.equalsIgnoreCase(neededHost);
        }
        return true;
    }

    @Override
    public boolean isHostUsingLockedDomain(String host) {
        if (this.isEnabled()) {
            for (String suffix : this.lockedSuffixes.values()) {
                if (!host.toLowerCase().endsWith(suffix.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    @Inject(optional=true)
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    private String checkSuffix(String suffix) {
        Matcher m;
        if (suffix != null && (m = this.authpattern.matcher(suffix)).matches()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("You should not be using %authority% replacement in a running environment!");
                LOG.warning("Check your config and specify an explicit locked domain suffix.");
                LOG.warning("Found suffix: " + suffix);
            }
            if (this.authority != null) {
                suffix = m.replaceAll(this.authority.getAuthority());
            }
        }
        return suffix;
    }

    private String getContainer(String container) {
        if (this.required.containsKey(container)) {
            return container;
        }
        return "default";
    }

    private String getLockedDomain(Gadget gadget, String container) throws GadgetException {
        String suffix = this.lockedSuffixes.get(container);
        if (suffix == null) {
            return null;
        }
        return this.getLockedDomainPrefix(gadget) + suffix;
    }

    private String getLockedDomainParticipants(Gadget gadget) throws GadgetException {
        Map<String, Feature> features = gadget.getSpec().getModulePrefs().getFeatures();
        Feature ldFeature = features.get("locked-domain");
        TreeSet<String> filtered = new TreeSet<String>();
        filtered.add(gadget.getSpec().getUrl().toString().toLowerCase());
        if (ldFeature != null) {
            Collection<String> participants = ldFeature.getParamCollection("participant");
            for (String participant : participants) {
                try {
                    Uri.parse((String)participant);
                }
                catch (Uri.UriException e) {
                    throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Participant param must be a valid uri", e);
                }
                filtered.add(participant.toLowerCase());
            }
        }
        StringBuilder buffer = new StringBuilder();
        for (String participant : filtered) {
            buffer.append(participant);
        }
        return buffer.toString();
    }

    @VisibleForTesting
    ContainerConfig.ConfigObserver getConfigObserver() {
        return this.ldObserver;
    }

    private class HashLockedDomainObserver
    implements ContainerConfig.ConfigObserver {
        private HashLockedDomainObserver() {
        }

        public void containersChanged(ContainerConfig config, Collection<String> changed, Collection<String> removed) {
            for (String container : changed) {
                String suffix = config.getString(container, HashLockedDomainService.LOCKED_DOMAIN_SUFFIX_KEY);
                if (suffix == null) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.logp(Level.WARNING, classname, "containersChanged", "noLockedDomainConfig", new Object[]{container});
                    continue;
                }
                HashLockedDomainService.this.lockedSuffixes.put(container, HashLockedDomainService.this.checkSuffix(suffix));
            }
            for (String container : removed) {
                HashLockedDomainService.this.lockedSuffixes.remove(container);
            }
        }
    }
}

