/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.oauth.BasicOAuthStore;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.OAuthFetcherConfig;
import org.apache.shindig.gadgets.oauth.OAuthRequest;
import org.apache.shindig.gadgets.oauth.OAuthStore;

public class OAuthModule
extends AbstractModule {
    private static final String classname = OAuthModule.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private static final String OAUTH_CONFIG = "config/oauth.json";
    private static final String OAUTH_SIGNING_KEY_FILE = "shindig.signing.key-file";
    private static final String OAUTH_SIGNING_KEY_NAME = "shindig.signing.key-name";
    private static final String OAUTH_CALLBACK_URL = "shindig.signing.global-callback-url";

    protected void configure() {
        this.bind(BlobCrypter.class).annotatedWith((Annotation)Names.named((String)"shindig.oauth.state-crypter")).toProvider(OAuthCrypterProvider.class);
        this.bind(OAuthStore.class).toProvider(OAuthStoreProvider.class);
        this.bind(OAuthRequest.class).toProvider(OAuthRequestProvider.class);
    }

    @Singleton
    public static class OAuthStoreProvider
    implements Provider<OAuthStore> {
        private final BasicOAuthStore store = new BasicOAuthStore();

        @Inject
        public OAuthStoreProvider(@Named(value="shindig.signing.key-file") String signingKeyFile, @Named(value="shindig.signing.key-name") String signingKeyName, @Named(value="shindig.signing.global-callback-url") String defaultCallbackUrl, Authority authority) {
            this.loadDefaultKey(signingKeyFile, signingKeyName);
            this.store.setDefaultCallbackUrl(defaultCallbackUrl);
            this.store.setAuthority(authority);
            this.loadConsumers();
        }

        private void loadDefaultKey(String signingKeyFile, String signingKeyName) {
            BasicOAuthStoreConsumerKeyAndSecret key;
            block7: {
                key = null;
                if (!StringUtils.isBlank((CharSequence)signingKeyFile)) {
                    try {
                        if (LOG.isLoggable(Level.INFO)) {
                            LOG.logp(Level.INFO, classname, "loadDefaultKey", "loadKeyFileFrom", new Object[]{signingKeyFile});
                        }
                        String privateKey = IOUtils.toString((InputStream)ResourceLoader.open((String)signingKeyFile), (String)"UTF-8");
                        privateKey = BasicOAuthStore.convertFromOpenSsl(privateKey);
                        key = new BasicOAuthStoreConsumerKeyAndSecret(null, privateKey, BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, signingKeyName, null);
                    }
                    catch (Throwable t) {
                        if (!LOG.isLoggable(Level.WARNING)) break block7;
                        LOG.logp(Level.WARNING, classname, "loadDefaultKey", "couldNotLoadKeyFile", new Object[]{signingKeyFile});
                        LOG.logp(Level.WARNING, classname, "loadDefaultKey", "", t);
                    }
                }
            }
            if (key != null) {
                this.store.setDefaultKey(key);
            } else if (LOG.isLoggable(Level.WARNING)) {
                LOG.logp(Level.WARNING, classname, "loadDefaultKey", "couldNotLoadSignedKey", new Object[]{OAuthModule.OAUTH_SIGNING_KEY_FILE, OAuthModule.OAUTH_SIGNING_KEY_NAME});
            }
        }

        private void loadConsumers() {
            block2: {
                try {
                    String oauthConfigString = ResourceLoader.getContent((String)OAuthModule.OAUTH_CONFIG);
                    this.store.initFromConfigString(oauthConfigString);
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.WARNING)) break block2;
                    LOG.logp(Level.WARNING, classname, "loadConsumers", "failedToInit", new Object[]{OAuthModule.OAUTH_CONFIG});
                    LOG.log(Level.WARNING, "", t);
                }
            }
        }

        public OAuthStore get() {
            return this.store;
        }
    }

    public static class OAuthRequestProvider
    implements Provider<OAuthRequest> {
        private final HttpFetcher fetcher;
        private final OAuthFetcherConfig config;

        @Inject
        public OAuthRequestProvider(HttpFetcher fetcher, OAuthFetcherConfig config) {
            this.fetcher = fetcher;
            this.config = config;
        }

        public OAuthRequest get() {
            return new OAuthRequest(this.config, this.fetcher);
        }
    }

    @Singleton
    public static class OAuthCrypterProvider
    implements Provider<BlobCrypter> {
        private final BlobCrypter crypter;

        @Inject
        public OAuthCrypterProvider(@Named(value="shindig.signing.state-key") String stateCrypterPath) throws IOException {
            if (StringUtils.isBlank((CharSequence)stateCrypterPath)) {
                LOG.info("Using random key for OAuth client-side state encryption");
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, classname, "OAuthCrypterProvider constructor", "usingRandomKey");
                }
                this.crypter = new BasicBlobCrypter(Crypto.getRandomBytes((int)16));
            } else {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, classname, "OAuthCrypterProvider constructor", "usingFile", new Object[]{stateCrypterPath});
                }
                this.crypter = new BasicBlobCrypter(new File(stateCrypterPath));
            }
        }

        public BlobCrypter get() {
            return this.crypter;
        }
    }
}

