/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.image.JpegImageUtils;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class BaseOptimizer {
    static final Map<String, ImageFormat> FORMAT_NAME_TO_IMAGE_FORMAT = ImmutableMap.of((Object)"png", (Object)ImageFormat.IMAGE_FORMAT_PNG, (Object)"gif", (Object)ImageFormat.IMAGE_FORMAT_GIF, (Object)"jpeg", (Object)ImageFormat.IMAGE_FORMAT_JPEG);
    final HttpResponseBuilder response;
    final OptimizerConfig config;
    protected ImageOutputter outputter;
    protected byte[] minBytes;
    protected int minLength;
    protected JpegImageUtils.JpegImageParams sourceImageParams;
    int reductionPct;

    public BaseOptimizer(OptimizerConfig config, HttpResponseBuilder response) {
        this(config, response, null);
    }

    public BaseOptimizer(OptimizerConfig config, HttpResponseBuilder response, JpegImageUtils.JpegImageParams sourceImageParams) {
        this.config = config;
        this.response = response;
        this.minLength = response.getContentLength();
        this.sourceImageParams = sourceImageParams;
        this.outputter = this.getOutputter();
    }

    protected ImageOutputter getOutputter() {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(this.getOriginalFormatName());
        if (writers.hasNext()) {
            ImageWriter writer = writers.next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            if (this.getOriginalFormatName().equals("jpeg")) {
                param.setCompressionMode(2);
                param.setCompressionQuality(this.config.getJpegCompression());
                if (param instanceof JPEGImageWriteParam) {
                    ((JPEGImageWriteParam)param).setOptimizeHuffmanTables(this.config.getJpegHuffmanOptimization());
                }
            }
            JpegImageUtils.SamplingModes samplingMode = JpegImageUtils.SamplingModes.DEFAULT;
            if (this.config.getJpegRetainSubsampling() && this.sourceImageParams != null) {
                samplingMode = this.sourceImageParams.getSamplingMode();
            }
            return new ImageIOOutputter(writer, param, samplingMode);
        }
        return new SanselanOutputter(FORMAT_NAME_TO_IMAGE_FORMAT.get(this.getOriginalFormatName()));
    }

    protected void write(BufferedImage image) throws IOException {
        if (image == null) {
            return;
        }
        byte[] bytes = this.outputter.toBytes(image);
        if (this.minLength > bytes.length) {
            this.minBytes = bytes;
            this.minLength = this.minBytes.length;
            this.reductionPct = (this.response.getContentLength() - this.minLength) * 100 / this.response.getContentLength();
        }
    }

    public void rewrite(BufferedImage image) throws IOException {
        if (this.outputter == null) {
            return;
        }
        long time = System.currentTimeMillis();
        this.rewriteImpl(image);
        time = System.currentTimeMillis() - time;
        if (this.minBytes != null && this.minBytes.length != 0) {
            StringBuilder rewriteMsg = new StringBuilder(24);
            rewriteMsg.append("c=").append(this.minBytes.length * 100 / this.response.getContentLength());
            if (!this.getOutputContentType().equals(this.getOriginalContentType())) {
                rewriteMsg.append(";o=").append(this.getOriginalContentType());
            }
            rewriteMsg.append(";t=").append(time);
            this.response.removeHeader("ETag");
            this.response.setHeader("Content-Type", this.getOutputContentType()).setHeader("X-Shindig-Rewrite", rewriteMsg.toString()).setResponse(this.minBytes);
        }
    }

    protected final byte[] getRewrittenImage() {
        return this.minBytes;
    }

    protected abstract void rewriteImpl(BufferedImage var1) throws IOException;

    protected abstract String getOutputContentType();

    protected abstract String getOriginalContentType();

    protected abstract String getOriginalFormatName();

    public static class SanselanOutputter
    implements ImageOutputter {
        ImageFormat format;
        ByteArrayOutputStream baos;

        public SanselanOutputter(ImageFormat format) {
            this.format = format;
        }

        @Override
        public byte[] toBytes(BufferedImage image) throws IOException {
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream();
            } else {
                this.baos.reset();
            }
            try {
                Sanselan.writeImage((BufferedImage)image, (OutputStream)this.baos, (ImageFormat)this.format, (Map)Maps.newHashMap());
                return this.baos.toByteArray();
            }
            catch (ImageWriteException iwe) {
                throw new IOException(iwe.getMessage());
            }
        }
    }

    public static class ImageIOOutputter
    implements ImageOutputter {
        ImageWriter writer;
        ByteArrayOutputStream baos;
        ImageWriteParam writeParam;
        JpegImageUtils.SamplingModes jpegSamplingMode;

        public ImageIOOutputter(ImageWriter writer, ImageWriteParam writeParam) {
            this(writer, writeParam, JpegImageUtils.SamplingModes.DEFAULT);
        }

        public ImageIOOutputter(ImageWriter writer, ImageWriteParam writeParam, JpegImageUtils.SamplingModes jpegSamplingMode) {
            this.writer = writer;
            this.writeParam = (ImageWriteParam)Objects.firstNonNull((Object)writeParam, (Object)writer.getDefaultWriteParam());
            this.jpegSamplingMode = jpegSamplingMode;
        }

        @Override
        public byte[] toBytes(BufferedImage image) throws IOException {
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream();
            } else {
                this.baos.reset();
            }
            this.writer.setOutput(ImageIO.createImageOutputStream(this.baos));
            ImageWriteParam metaImageWriteParam = this.writeParam;
            if (this.writer instanceof JPEGImageWriter) {
                metaImageWriteParam = null;
            }
            IIOMetadata metadata = this.writer.getDefaultImageMetadata(new ImageTypeSpecifier(image.getColorModel(), image.getSampleModel()), metaImageWriteParam);
            if (this.jpegSamplingMode.getModeValue() > 0 && this.writer instanceof JPEGImageWriter) {
                this.setJpegSubsamplingMode(metadata);
            }
            this.writer.write(null, new IIOImage(image, Collections.emptyList(), metadata), metaImageWriteParam == null ? this.writeParam : null);
            return this.baos.toByteArray();
        }

        private void setJpegSubsamplingMode(IIOMetadata metadata) throws IIOInvalidTreeException {
            Node rootNode = metadata.getAsTree("javax_imageio_jpeg_image_1.0");
            boolean metadataUpdated = false;
            if (rootNode.getLastChild() != null) {
                Node markerNode = rootNode.getLastChild();
                NodeList markers = markerNode.getChildNodes();
                for (int i = 0; i < markers.getLength(); ++i) {
                    Node node = markers.item(i);
                    if (!node.getNodeName().equalsIgnoreCase("sof") || !node.hasChildNodes() || node.getChildNodes().getLength() != 3) continue;
                    NamedNodeMap attrMap = node.getFirstChild().getAttributes();
                    int samplingMode = this.jpegSamplingMode.getModeValue();
                    attrMap.getNamedItem("HsamplingFactor").setNodeValue((samplingMode & 0xF) + "");
                    attrMap.getNamedItem("VsamplingFactor").setNodeValue((samplingMode >> 4 & 0xF) + "");
                    metadataUpdated = true;
                    break;
                }
            }
            if (metadataUpdated) {
                metadata.setFromTree("javax_imageio_jpeg_image_1.0", rootNode);
            }
        }
    }

    public static interface ImageOutputter {
        public byte[] toBytes(BufferedImage var1) throws IOException;
    }
}

