/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.plugins.jpeg.JPEGQTable;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.sanselan.formats.jpeg.JpegUtils;
import org.apache.shindig.gadgets.rewrite.image.ImageUtils;

public class JpegImageUtils {
    private static final Logger LOG = Logger.getLogger(ImageUtils.class.getName());
    private static final int END_OF_IMAGE_MARKER = 65497;
    private static final String INVALID_JPEG_ERROR_MSG = "Not a Valid JPEG File";
    private static final int HUFFMAN_TABLE_MARKER = 65476;
    private static final int QUANTIZATION_TABLE_MARKER = 65499;
    private static final int MAX_DC_SYMBOLS = 12;
    private static final int MAX_AC_SYMBOLS = 162;

    private JpegImageUtils() {
    }

    public static JpegImageParams getJpegImageData(InputStream is, String filename) throws IOException, ImageReadException {
        final JpegImageParams imageParams = new JpegImageParams(SamplingModes.UNKNOWN, false, -1.0f);
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){
            BinaryFileParser binaryParser = new BinaryFileParser();

            public boolean beginSOS() {
                return false;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65472 || marker == 65474) {
                    this.parseSOFSegment(markerLength, segmentData);
                } else if (marker == 65476) {
                    this.parseHuffmanTables(markerLength, segmentData);
                } else if (marker == 65499) {
                    this.parseQuantizationTables(markerLength, segmentData);
                }
                return true;
            }

            private void parseSOFSegment(int markerLength, byte[] segmentData) throws IOException, ImageReadException {
                int toBeProcessed = markerLength - 2;
                byte numComponents = 0;
                ByteArrayInputStream is = new ByteArrayInputStream(segmentData);
                if (toBeProcessed <= 6) {
                    LOG.log(Level.WARNING, "Failed to SOF marker");
                    return;
                }
                this.binaryParser.skipBytes((InputStream)is, 5, JpegImageUtils.INVALID_JPEG_ERROR_MSG);
                numComponents = this.binaryParser.readByte("Number_of_components", (InputStream)is, "Unable to read Number of components from SOF marker");
                if (numComponents == 3 && (toBeProcessed -= 6) == 9) {
                    this.binaryParser.skipBytes((InputStream)is, 1, JpegImageUtils.INVALID_JPEG_ERROR_MSG);
                    imageParams.setSamplingMode(this.binaryParser.readByte("Sampling Factors", (InputStream)is, "Unable to read the sampling factor from the 'Y' channel component spec"));
                    imageParams.setLumaIndex(this.binaryParser.readByte("Quantization Table Index", (InputStream)is, "Unable to read Quantization table index of 'Y' channel"));
                    this.binaryParser.skipBytes((InputStream)is, 2, JpegImageUtils.INVALID_JPEG_ERROR_MSG);
                    imageParams.setChromaIndex(this.binaryParser.readByte("Quantization Table Index", (InputStream)is, "Unable to read Quantization table index of 'Cb' Channel"));
                } else {
                    LOG.log(Level.WARNING, "Failed to Component Spec from SOF marker");
                }
            }

            private void parseQuantizationTables(int markerLength, byte[] segmentData) throws ImageReadException, IOException {
                int precision;
                ByteArrayInputStream is = new ByteArrayInputStream(segmentData);
                for (int toBeProcessed = markerLength - 2; toBeProcessed > 1; toBeProcessed -= 64 * (precision + 1)) {
                    byte tableInfo = this.binaryParser.readByte("Quantization Table Info", (InputStream)is, "Not able to read Quantization Table Info");
                    int tableIndex = tableInfo & 0xF;
                    precision = tableInfo >> 4;
                    if (--toBeProcessed < 64 * (precision + 1)) {
                        return;
                    }
                    int[] quanTable = new int[64];
                    for (int i = 0; i < 64; ++i) {
                        quanTable[i] = precision == 0 ? this.binaryParser.readByte("Reading", (InputStream)is, "Reading Quanization Table Failed") : this.binaryParser.read2Bytes("Reading", (InputStream)is, "Reading Quantization Table Failed");
                    }
                    imageParams.addQTable(tableIndex, quanTable);
                }
            }

            private void parseHuffmanTables(int markerLength, byte[] segmentData) throws ImageReadException, IOException {
                int numSymbols;
                ByteArrayInputStream is = new ByteArrayInputStream(segmentData);
                for (int toBeProcessed = markerLength - 2; toBeProcessed > 1; toBeProcessed -= 16 + numSymbols) {
                    byte tableInfo = this.binaryParser.readByte("Huffman Table Info", (InputStream)is, "Not able to read Huffman Table Info");
                    if (--toBeProcessed < 16) {
                        return;
                    }
                    numSymbols = 0;
                    for (int i = 0; i < 16; ++i) {
                        numSymbols += this.binaryParser.readByte("Num symbols", (InputStream)is, "Not able to read num symbols");
                    }
                    int tableType = tableInfo >> 4 & 1;
                    if ((tableType != 0 || numSymbols == 12) && (tableType != 1 || numSymbols == 162)) continue;
                    imageParams.setHuffmanOptimized(true);
                    return;
                }
            }
        };
        new JpegUtils().traverseJFIF((ByteSource)new ByteSourceInputStream(is, filename), visitor);
        return imageParams;
    }

    public static class JpegImageParams {
        private SamplingModes mode;
        private boolean huffmanOptimized;
        private float approxQualityFactor;
        private float lumaQualityFactor = -1.0f;
        private float chromaQualityFactor = -1.0f;
        private final int[] k1LumaQuantTable = JPEGQTable.K1Luminance.getTable();
        private final int[] k2ChromaQuantTable = JPEGQTable.K2Chrominance.getTable();
        private int[][] tables = new int[2][64];
        private int lumaIndex = -1;
        private int chromaIndex = -1;

        JpegImageParams(SamplingModes mode, boolean huffmanOptimized, float approxQualityFactor) {
            this.mode = mode;
            this.huffmanOptimized = huffmanOptimized;
            this.approxQualityFactor = approxQualityFactor;
        }

        public SamplingModes getSamplingMode() {
            return this.mode;
        }

        public void setSamplingMode(int samplingMode) {
            for (SamplingModes mode : SamplingModes.values()) {
                if (samplingMode != mode.getModeValue()) continue;
                this.mode = mode;
                return;
            }
            this.mode = SamplingModes.UNKNOWN;
            LOG.log(Level.WARNING, "Unable to read subsampling information for Jpeg Image");
        }

        public boolean isHuffmanOptimized() {
            return this.huffmanOptimized;
        }

        public void setHuffmanOptimized(boolean huffmanOptimized) {
            this.huffmanOptimized = huffmanOptimized;
        }

        public void setLumaIndex(int index) {
            this.lumaIndex = index;
        }

        public void setChromaIndex(int index) {
            this.chromaIndex = index;
        }

        public float approximateQuality(int[] table, int[] stdTable) {
            int total = 0;
            int stdTotal = 0;
            for (int i = 0; i < 64; ++i) {
                total += table[i];
                stdTotal += stdTable[i];
            }
            float scaleFactor = ((float)total - 32.0f) / (float)stdTotal;
            float approxChannelQuality = (double)scaleFactor > 1.0 ? 0.5f / scaleFactor : (2.0f - scaleFactor) / 2.0f;
            return approxChannelQuality;
        }

        public void addQTable(int tableIndex, int[] table) {
            if (tableIndex == 0 || tableIndex == 1) {
                System.arraycopy(table, 0, this.tables[tableIndex], 0, table.length);
            }
        }

        public float getChromaQualityFactor() {
            if (this.chromaQualityFactor < 0.0f && this.chromaIndex >= 0) {
                this.chromaQualityFactor = this.approximateQuality(this.tables[this.chromaIndex], this.k2ChromaQuantTable);
            }
            return this.chromaQualityFactor;
        }

        public float getLumaQualityFactor() {
            if (this.lumaQualityFactor < 0.0f && this.lumaIndex >= 0) {
                this.lumaQualityFactor = this.approximateQuality(this.tables[this.lumaIndex], this.k1LumaQuantTable);
            }
            return this.lumaQualityFactor;
        }

        public float getApproxQualityFactor() {
            if (this.approxQualityFactor < 0.0f) {
                this.approxQualityFactor = (this.getLumaQualityFactor() + 2.0f * this.getChromaQualityFactor()) / 3.0f;
            }
            return this.approxQualityFactor;
        }
    }

    public static enum SamplingModes {
        UNKNOWN(-2),
        DEFAULT(-1),
        YUV444(17),
        YUV422(33),
        YUV420(34),
        YUV411(65);

        private int mode;

        private SamplingModes(int mode) {
            this.mode = mode;
        }

        public int getModeValue() {
            return this.mode;
        }
    }
}

