/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.conf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.forum.common.conf.ManagedPlugin;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;

@Managed
@NameTemplate(value={@Property(key="service", value="forum"), @Property(key="view", value="plugins"), @Property(key="name", value="{Name}")})
@ManagedDescription(value="Plugin that defines rules for administrator role")
public class RoleRulesPlugin
extends ManagedPlugin {
    private Map<String, List<String>> rules_ = new LinkedHashMap<String, List<String>>();

    public RoleRulesPlugin(InitParams params) throws Exception {
        ValueParam vlParam = params.getValueParam("role");
        ValuesParam vlsParam = params.getValuesParam("rules");
        this.rules_.put(vlParam.getValue(), vlsParam.getValues());
    }

    @Managed
    @ManagedDescription(value="add an admin rule")
    public void addRule(String role, String rule) {
        this.rules_.get(role).add(rule);
    }

    @Managed
    @ManagedDescription(value="list of rules that define")
    public List<String> getRules(String role) {
        return this.rules_.get(role);
    }

    @Managed
    @ManagedDescription(value="get possible names for rules")
    public List<String> getRuleNames() {
        ArrayList<String> results = new ArrayList<String>();
        results.addAll(this.rules_.keySet());
        return results;
    }

    @Managed
    @ManagedDescription(value="get All rules in this plugin")
    public Map<String, List<String>> getAllRules() {
        return this.rules_;
    }
}

