/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.login.LoginError;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.sso.SSOHelper;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.authentication.AuthenticationEvent;
import org.gatein.wci.authentication.AuthenticationEventType;
import org.gatein.wci.authentication.AuthenticationException;
import org.gatein.wci.authentication.AuthenticationListener;
import org.gatein.wci.security.Credentials;

public class LoginServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = -1330051083735349589L;
    private static final int UNAUTHENTICATED = 0;
    private static final int AUTHENTICATED = 1;
    private static final int FAILED = 2;
    private static final Logger log = LoggerFactory.getLogger(LoginServlet.class);
    public static final String COOKIE_NAME = "rememberme";
    public static final String OAUTH_COOKIE_NAME = "oauth_rememberme";
    private static final String IS_CASE_INSENSITIVE = "exo.auth.case.insensitive";
    public static final String SESSION_ATTRIBUTE_REMEMBER_ME = "_rememberme";

    protected void afterInit(ServletConfig config) throws ServletException {
        ServletContainerFactory.getServletContainer().addAuthenticationListener(new AuthenticationListener(){

            public void onEvent(AuthenticationEvent event) {
                if (event.getType() == AuthenticationEventType.LOGIN) {
                    LoginServlet.bindCredentialsToAuthenticationRegistry(LoginServlet.this.getContainer(), event.getRequest(), event.getCredentials());
                }
            }
        });
    }

    public static String getRememberMeTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!COOKIE_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static String getOauthRememberMeTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!OAUTH_COOKIE_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int status;
        try {
            req.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Encoding not supported", (Throwable)e);
        }
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        boolean caseInsensitive = true;
        String caseInsensitiveString = PropertyManager.getProperty((String)IS_CASE_INSENSITIVE);
        if (caseInsensitiveString != null) {
            caseInsensitive = Boolean.valueOf(caseInsensitiveString);
        }
        if (req.getRemoteUser() == null) {
            if (username != null && password != null) {
                Credentials credentials = new Credentials(username, password);
                ServletContainer container = ServletContainerFactory.getServletContainer();
                try {
                    container.login(req, resp, credentials);
                }
                catch (AuthenticationException e) {
                    if (caseInsensitive) {
                        if ((username = this.getUserNameCaseInsensitive(username)) != null) {
                            try {
                                credentials = new Credentials(username, password);
                                container.login(req, resp, credentials);
                            }
                            catch (AuthenticationException e1) {
                                log.trace((Object)("User " + username + " authentication failed"), (Throwable)e1);
                            }
                        }
                    }
                    log.trace((Object)("User " + username + " authentication failed"), (Throwable)e);
                }
                int n = status = req.getRemoteUser() != null ? 1 : 2;
                if (status == 1) {
                    Cookie cookie;
                    String cookieToken;
                    CookieTokenService tokenService;
                    String rememberme;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"User authenticated successfuly through WCI. Will redirect to initialURI");
                    }
                    if ("true".equals(rememberme = req.getParameter(COOKIE_NAME))) {
                        tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                        cookieToken = tokenService.createToken(credentials);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found a remember me request parameter, created a persistent token " + cookieToken + " for it and set it up in the next response"));
                        }
                        cookie = new Cookie(COOKIE_NAME, cookieToken);
                        cookie.setPath(req.getContextPath());
                        cookie.setHttpOnly(true);
                        cookie.setMaxAge((int)tokenService.getValidityTime());
                        resp.addCookie(cookie);
                    } else if ("true".equals(req.getSession().getAttribute(SESSION_ATTRIBUTE_REMEMBER_ME))) {
                        tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                        cookieToken = tokenService.createToken(credentials);
                        cookie = new Cookie(OAUTH_COOKIE_NAME, cookieToken);
                        cookie.setPath(req.getContextPath());
                        cookie.setMaxAge((int)tokenService.getValidityTime());
                        resp.addCookie(cookie);
                        req.getSession().removeAttribute(SESSION_ATTRIBUTE_REMEMBER_ME);
                    }
                }
            } else {
                log.debug((Object)"username or password not provided. Changing status to UNAUTHENTICATED");
                status = 0;
            }
        } else {
            log.debug((Object)"User already authenticated. Will redirect to initialURI");
            status = 1;
        }
        String initialURI = req.getParameter("initialURI");
        if (initialURI == null || initialURI.length() == 0) {
            initialURI = req.getContextPath();
            log.debug((Object)("No initial URI found, will use default " + initialURI + " instead "));
        } else {
            log.debug((Object)("Found initial URI " + initialURI));
        }
        try {
            URI uri = new URI(initialURI);
            if (uri.isAbsolute() && !uri.getHost().equals(req.getServerName())) {
                log.warn((Object)"Cannot redirect to an URI outside of the current host when using a login redirect. Redirecting to the portal context path instead.");
                initialURI = req.getContextPath();
            }
        }
        catch (URISyntaxException e) {
            log.warn((Object)"Initial URI in login link is malformed. Redirecting to the portal context path instead.");
            initialURI = req.getContextPath();
        }
        if (status == 1) {
            if (!resp.isCommitted()) {
                resp.sendRedirect(resp.encodeRedirectURL(initialURI));
            }
        } else {
            if (status == 2) {
                req.setAttribute("org.gatein.portal.login.error", (Object)"whatever");
            }
            req.setAttribute("org.gatein.portal.login.initial_uri", (Object)initialURI);
            SSOHelper ssoHelper = (SSOHelper)this.getContainer().getComponentInstanceOfType(SSOHelper.class);
            String disabledUser = (String)req.getAttribute("_disabledUserName");
            boolean meetDisabledUser = disabledUser != null;
            ServletContext servletContext = this.getServletContext();
            final String portalContextPath = servletContext.getContextPath();
            HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(req){

                public String getContextPath() {
                    return portalContextPath;
                }
            };
            if (ssoHelper.skipJSPRedirection() && meetDisabledUser) {
                resp.setContentType("text/html; charset=UTF-8");
                this.getServletContext().getRequestDispatcher("/login/jsp/disabled.jsp").include((ServletRequest)wrappedRequest, (ServletResponse)resp);
            } else if (ssoHelper.skipJSPRedirection()) {
                String ssoRedirectUrl = req.getContextPath() + ssoHelper.getSSORedirectURLSuffix();
                ssoRedirectUrl = resp.encodeRedirectURL(ssoRedirectUrl);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Redirected to SSO login URL: " + ssoRedirectUrl));
                }
                resp.sendRedirect(ssoRedirectUrl);
            } else {
                StringBuilder loginPath = new StringBuilder("/login/jsp/login.jsp");
                if (meetDisabledUser) {
                    String errorData = meetDisabledUser ? new LoginError(1, disabledUser).toString() : "";
                    loginPath.append("?").append("_error").append("=").append(URLEncoder.encode(errorData, "UTF-8"));
                }
                resp.setContentType("text/html; charset=UTF-8");
                this.getServletContext().getRequestDispatcher(loginPath.toString()).include((ServletRequest)wrappedRequest, (ServletResponse)resp);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private static void bindCredentialsToAuthenticationRegistry(ExoContainer exoContainer, HttpServletRequest req, Credentials credentials) {
        AuthenticationRegistry authRegistry = (AuthenticationRegistry)exoContainer.getComponentInstanceOfType(AuthenticationRegistry.class);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Binding credentials to temporary authentication registry for user " + credentials.getUsername()));
        }
        authRegistry.setCredentials(req, credentials);
    }

    private String getUserNameCaseInsensitive(String username) {
        try {
            OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstance(OrganizationService.class);
            Query query = new Query();
            query.setUserName(username);
            ListAccess users = organizationService.getUserHandler().findUsersByQuery(query);
            if (users.getSize() >= 1) {
                String loadedUsername = "";
                User[] listusers = (User[])users.load(0, users.getSize());
                int found = 0;
                for (User user : listusers) {
                    if (!username.equalsIgnoreCase(user.getUserName())) continue;
                    loadedUsername = user.getUserName();
                    ++found;
                }
                if (found == 1 && StringUtils.isNotBlank((String)loadedUsername)) {
                    if (StringUtils.equals((String)username, (String)loadedUsername)) {
                        return null;
                    }
                    username = loadedUsername;
                } else {
                    log.warn((Object)("duplicate entry for user " + username));
                }
            }
        }
        catch (Exception exception) {
            log.warn((Object)("Error while retrieving user " + username + " from IDM stores "), (Throwable)exception);
        }
        return username;
    }
}

