/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.Command;
import uk.ac.ed.ph.snuggletex.definitions.CommandOrEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.GlobalBuiltins;
import uk.ac.ed.ph.snuggletex.definitions.Globals;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.definitions.UserDefinedCommand;
import uk.ac.ed.ph.snuggletex.definitions.UserDefinedEnvironment;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleInputReader;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.WorkingDocument;
import uk.ac.ed.ph.snuggletex.internal.util.ArrayListStack;
import uk.ac.ed.ph.snuggletex.semantics.MathIdentifierInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathNumberInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.BraceContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.ErrorToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.SimpleToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

public final class LaTeXTokeniser {
    public static final Set<String> reservedCommands = new HashSet<String>(Arrays.asList("begin", "end", "(", ")", "[", "]", "newcommand", "renewcommand", "newenvironment", "renewenvironment"));
    private static final String UDE_POST_BEGIN = "\u00a3";
    private final SessionContext sessionContext;
    private WorkingDocument workingDocument;
    private int position;
    private int startTokenIndex;
    private ModeState currentModeState;
    private final ArrayListStack<ModeState> modeStack;
    private final ArrayListStack<String> openEnvironmentStack;
    private final Set<String> userEnvironmentsOpeningSet;

    public LaTeXTokeniser(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.modeStack = new ArrayListStack();
        this.openEnvironmentStack = new ArrayListStack();
        this.userEnvironmentsOpeningSet = new HashSet<String>();
    }

    private void reset() {
        this.position = 0;
        this.startTokenIndex = -1;
        this.modeStack.clear();
        this.currentModeState = null;
        this.openEnvironmentStack.clear();
        this.userEnvironmentsOpeningSet.clear();
    }

    public ArgumentContainerToken tokenise(SnuggleInputReader reader) throws SnuggleParseException, IOException {
        this.workingDocument = reader.createWorkingDocument();
        this.reset();
        ModeState topLevelResult = this.tokeniseInNewState(TokenisationMode.TOP_LEVEL, null, LaTeXMode.PARAGRAPH);
        while (!this.openEnvironmentStack.isEmpty()) {
            topLevelResult.tokens.add(this.createError(ErrorCode.TTEE04, this.position, this.position, this.openEnvironmentStack.pop()));
        }
        return new ArgumentContainerToken(this.workingDocument.freezeSlice(0, this.workingDocument.length()), LaTeXMode.PARAGRAPH, topLevelResult.tokens);
    }

    private ModeState tokeniseInNewState(TokenisationMode tokenisationMode, Terminator terminator, LaTeXMode latexMode) throws SnuggleParseException {
        FlowToken token;
        this.currentModeState = new ModeState(tokenisationMode, latexMode, this.position, terminator);
        this.modeStack.push(this.currentModeState);
        while ((token = this.readNextToken()) != null) {
            this.currentModeState.tokens.add(token);
        }
        if (this.currentModeState.latexMode == LaTeXMode.VERBATIM && this.currentModeState.tokens.isEmpty()) {
            FrozenSlice emptySlice = this.workingDocument.freezeSlice(this.currentModeState.startPosition, this.currentModeState.startPosition);
            this.currentModeState.tokens.add(new SimpleToken(emptySlice, TokenType.VERBATIM_MODE_TEXT, LaTeXMode.VERBATIM, null));
        }
        if (terminator != null && !this.currentModeState.foundTerminator) {
            this.currentModeState.tokens.add(this.createError(ErrorCode.TTEG00, this.position, this.position, terminator));
        }
        ModeState result = this.currentModeState;
        this.modeStack.pop();
        this.currentModeState = this.modeStack.isEmpty() ? null : this.modeStack.peek();
        return result;
    }

    private FlowToken readNextToken() throws SnuggleParseException {
        FlowToken result;
        int afterTerminator;
        if (this.currentModeState.latexMode == LaTeXMode.MATH) {
            this.skipOverCommentsAndWhitespace();
        } else if (this.currentModeState.latexMode != LaTeXMode.VERBATIM) {
            this.skipOverComments();
        }
        if (this.currentModeState.terminator != null && (afterTerminator = this.currentModeState.terminator.matchesAt(this.workingDocument, this.position)) != -1) {
            this.position = afterTerminator;
            this.currentModeState.foundTerminator = true;
            return null;
        }
        if (this.position == this.workingDocument.length()) {
            return null;
        }
        this.startTokenIndex = this.position;
        switch (this.currentModeState.latexMode) {
            case PARAGRAPH: 
            case LR: {
                result = this.readNextTokenTextMode();
                break;
            }
            case MATH: {
                result = this.readNextTokenMathMode();
                break;
            }
            case VERBATIM: {
                result = this.readNextTokenVerbatimMode();
                break;
            }
            default: {
                throw new SnuggleLogicException("Unexpected switch case " + (Object)((Object)this.currentModeState.latexMode));
            }
        }
        if (result != null) {
            this.position = result.getSlice().endIndex;
        }
        return result;
    }

    private void makeSubstitutionAndRewind(int startIndex, int endIndex, CharSequence replacement) {
        this.workingDocument.substitute(startIndex, endIndex, replacement);
        this.position = startIndex;
    }

    private FlowToken readNextTokenVerbatimMode() {
        Terminator terminator = this.currentModeState.terminator;
        if (terminator == null) {
            throw new SnuggleLogicException("No terminator specified for VERBATIM Mode");
        }
        int endIndex = terminator.nextMatchFrom(this.workingDocument, this.startTokenIndex);
        if (endIndex == -1) {
            endIndex = this.workingDocument.length();
        }
        FrozenSlice verbatimContentSlice = this.workingDocument.freezeSlice(this.startTokenIndex, endIndex);
        return new SimpleToken(verbatimContentSlice, TokenType.VERBATIM_MODE_TEXT, LaTeXMode.VERBATIM, null);
    }

    private FlowToken readNextTokenMathMode() throws SnuggleParseException {
        int c = this.workingDocument.charAt(this.position);
        switch (c) {
            case -1: {
                return null;
            }
            case 92: {
                return this.readSlashToken();
            }
            case 123: {
                return this.readBraceRegion();
            }
            case 37: {
                throw new SnuggleLogicException("Comment should be have been skipped before getting here!");
            }
            case 38: {
                return new SimpleToken(this.workingDocument.freezeSlice(this.position, this.position + 1), TokenType.TAB_CHARACTER, this.currentModeState.latexMode, null);
            }
            case 35: {
                return this.createError(ErrorCode.TTEG04, this.position, this.position + 1, new Object[0]);
            }
        }
        return this.readNextMathNumberOrSymbol();
    }

    private FlowToken readNextMathNumberOrSymbol() {
        SimpleToken numberToken = this.tryReadMathNumber();
        if (numberToken != null) {
            return numberToken;
        }
        char c = (char)this.workingDocument.charAt(this.position);
        FrozenSlice thisCharSlice = this.workingDocument.freezeSlice(this.position, this.position + 1);
        MathInterpretation interpretation = Globals.getMathCharacter(c);
        if (interpretation != null) {
            return new SimpleToken(thisCharSlice, TokenType.SINGLE_CHARACTER_MATH_SPECIAL, LaTeXMode.MATH, interpretation, null);
        }
        return new SimpleToken(thisCharSlice, TokenType.SINGLE_CHARACTER_MATH_IDENTIFIER, LaTeXMode.MATH, new MathIdentifierInterpretation(String.valueOf(c)), null);
    }

    private SimpleToken tryReadMathNumber() {
        int c;
        int index = this.position;
        boolean foundDigitsBeforeDecimalPoint = false;
        boolean foundDigitsAfterDecimalPoint = false;
        boolean foundDecimalPoint = false;
        while ((c = this.workingDocument.charAt(index)) >= 48 && c <= 57) {
            foundDigitsBeforeDecimalPoint = true;
            ++index;
        }
        if (this.workingDocument.charAt(index) == 46) {
            foundDecimalPoint = true;
            ++index;
        }
        if (!foundDigitsBeforeDecimalPoint && !foundDecimalPoint) {
            return null;
        }
        while ((c = this.workingDocument.charAt(index)) >= 48 && c <= 57) {
            foundDigitsAfterDecimalPoint = true;
            ++index;
        }
        if (!foundDigitsBeforeDecimalPoint && !foundDigitsAfterDecimalPoint) {
            return null;
        }
        FrozenSlice numberSlice = this.workingDocument.freezeSlice(this.position, index);
        return new SimpleToken(numberSlice, TokenType.MATH_NUMBER, LaTeXMode.MATH, new MathNumberInterpretation(numberSlice.extract()), null);
    }

    private FlowToken readNextTokenTextMode() throws SnuggleParseException {
        int c = this.workingDocument.charAt(this.position);
        switch (c) {
            case -1: {
                return null;
            }
            case 92: {
                return this.readSlashToken();
            }
            case 36: {
                return this.readDollarMath();
            }
            case 123: {
                return this.readBraceRegion();
            }
            case 37: {
                throw new SnuggleLogicException("Comment should be have been skipped before getting here!");
            }
            case 38: {
                return new SimpleToken(this.workingDocument.freezeSlice(this.position, this.position + 1), TokenType.TAB_CHARACTER, this.currentModeState.latexMode, null);
            }
            case 94: 
            case 95: {
                return this.createError(ErrorCode.TTEM03, this.position, this.position + 1, new Object[0]);
            }
            case 35: {
                return this.createError(ErrorCode.TTEG04, this.position, this.position + 1, new Object[0]);
            }
        }
        return this.readNextSimpleTextParaMode();
    }

    private SimpleToken readNextSimpleTextParaMode() {
        int c;
        int index;
        SimpleToken result = null;
        int newLineCount = 0;
        for (index = this.position; index < this.workingDocument.length(); ++index) {
            c = this.workingDocument.charAt(index);
            if (c == 10) {
                ++newLineCount;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        if (newLineCount >= 2) {
            return new SimpleToken(this.workingDocument.freezeSlice(this.position, index), TokenType.NEW_PARAGRAPH, this.currentModeState.latexMode, TextFlowContext.ALLOW_INLINE);
        }
        newLineCount = 0;
        int whitespaceStartIndex = -1;
        for (index = this.position; index < this.workingDocument.length() && (c = this.workingDocument.charAt(index)) != 92 && c != 36 && c != 123 && c != 37 && c != 38 && c != 35 && c != 94 && c != 95 && (this.currentModeState.terminator == null || this.currentModeState.terminator.matchesAt(this.workingDocument, index) == -1); ++index) {
            if (Character.isWhitespace(c)) {
                if (whitespaceStartIndex == -1) {
                    whitespaceStartIndex = index;
                }
                if (c != 10 || ++newLineCount != 2) continue;
                break;
            }
            newLineCount = 0;
            whitespaceStartIndex = -1;
        }
        result = newLineCount == 2 ? new SimpleToken(this.workingDocument.freezeSlice(this.position, whitespaceStartIndex), TokenType.TEXT_MODE_TEXT, this.currentModeState.latexMode, TextFlowContext.ALLOW_INLINE) : new SimpleToken(this.workingDocument.freezeSlice(this.position, index), TokenType.TEXT_MODE_TEXT, this.currentModeState.latexMode, TextFlowContext.ALLOW_INLINE);
        return result;
    }

    private FlowToken readDollarMath() throws SnuggleParseException {
        int endContentIndex;
        int openDollarPosition = this.position;
        LaTeXMode startLatexMode = this.currentModeState.latexMode;
        boolean isDisplayMath = this.workingDocument.matchesAt(this.position, "$$");
        String delimiter = isDisplayMath ? "$$" : "$";
        this.position += delimiter.length();
        int startContentIndex = this.position;
        ModeState contentResult = this.tokeniseInNewState(TokenisationMode.BUILTIN_ENVIRONMENT_CONTENT, new StringTerminator(delimiter), LaTeXMode.MATH);
        int n = endContentIndex = contentResult.foundTerminator ? this.position - delimiter.length() : this.position;
        if (delimiter.equals("$") && this.workingDocument.charAt(this.position) == 36) {
            return this.createError(ErrorCode.TTEM01, this.position, this.position + 1, new Object[0]);
        }
        FrozenSlice contentSlice = this.workingDocument.freezeSlice(startContentIndex, endContentIndex);
        ArgumentContainerToken contentToken = new ArgumentContainerToken(contentSlice, LaTeXMode.MATH, contentResult.tokens);
        FrozenSlice environmentSlice = this.workingDocument.freezeSlice(openDollarPosition, this.position);
        BuiltinEnvironment environment = isDisplayMath ? GlobalBuiltins.ENV_DISPLAYMATH : GlobalBuiltins.ENV_MATH;
        return new EnvironmentToken(environmentSlice, startLatexMode, environment, contentToken);
    }

    private BraceContainerToken readBraceRegion() throws SnuggleParseException {
        int openBraceIndex = this.position++;
        LaTeXMode openLaTeXMode = this.currentModeState.latexMode;
        ModeState result = this.tokeniseInNewState(TokenisationMode.BRACE, new StringTerminator("}"), this.currentModeState.latexMode);
        int endInnerIndex = result.foundTerminator ? this.position - 1 : this.position;
        FrozenSlice braceOuterSlice = this.workingDocument.freezeSlice(openBraceIndex, this.position);
        FrozenSlice braceInnerSlice = this.workingDocument.freezeSlice(openBraceIndex + 1, endInnerIndex);
        ArgumentContainerToken braceContents = new ArgumentContainerToken(braceInnerSlice, openLaTeXMode, result.tokens);
        return new BraceContainerToken(braceOuterSlice, openLaTeXMode, braceContents);
    }

    private FlowToken readSlashToken() throws SnuggleParseException {
        FlowToken result;
        int afterSlashIndex = this.position + 1;
        int c = this.workingDocument.charAt(afterSlashIndex);
        if (c == -1) {
            result = this.createError(ErrorCode.TTEG01, this.position, afterSlashIndex, new Object[]{this.currentModeState.latexMode});
        } else if (c == 40 || c == 91) {
            if (this.currentModeState.latexMode == LaTeXMode.MATH) {
                result = this.createError(ErrorCode.TTEM00, this.position, afterSlashIndex, new Object[0]);
            } else {
                int startCommandIndex = this.position;
                this.position += 2;
                int startContentIndex = this.position;
                String closer = c == 40 ? "\\)" : "\\]";
                ModeState contentResult = this.tokeniseInNewState(TokenisationMode.BUILTIN_ENVIRONMENT_CONTENT, new StringTerminator(closer), LaTeXMode.MATH);
                if (!contentResult.foundTerminator) {
                    contentResult.tokens.add(0, this.createError(ErrorCode.TTEM02, startCommandIndex, this.position, "\\" + Character.valueOf((char)c), closer));
                }
                int endContentIndex = contentResult.computeLastTokenEndIndex();
                FrozenSlice contentSlice = this.workingDocument.freezeSlice(startContentIndex, endContentIndex);
                FrozenSlice mathSlice = this.workingDocument.freezeSlice(startCommandIndex, this.position);
                ArgumentContainerToken contentToken = new ArgumentContainerToken(contentSlice, LaTeXMode.MATH, contentResult.tokens);
                BuiltinEnvironment environment = c == 40 ? GlobalBuiltins.ENV_MATH : GlobalBuiltins.ENV_DISPLAYMATH;
                result = new EnvironmentToken(mathSlice, this.currentModeState.latexMode, environment, contentToken);
            }
        } else {
            result = c == 41 || c == 93 ? this.createError(ErrorCode.TTEG03, this.position, this.position + 2, this.workingDocument.freezeSlice(this.position, this.position + 2).extract()) : this.readCommandOrEnvironmentOrVerb();
        }
        return result;
    }

    private FlowToken readCommandOrEnvironmentOrVerb() throws SnuggleParseException {
        int startCommandNameIndex = this.position + 1;
        String commandName = this.readCommandOrEnvironmentName(startCommandNameIndex);
        if (commandName == null) {
            throw new SnuggleLogicException("Expected caller to have picked the commandName==null case up");
        }
        this.position += 1 + commandName.length();
        boolean isWhitespaceCommand = true;
        for (int i = 0; i < commandName.length(); ++i) {
            if (Character.isWhitespace(commandName.charAt(i))) continue;
            isWhitespaceCommand = false;
            break;
        }
        if (isWhitespaceCommand) {
            commandName = " ";
        }
        FlowToken result = null;
        result = commandName.equals("begin") ? this.finishBeginEnvironment() : (commandName.equals("end") ? this.finishEndEnvironment() : (commandName.equals(UDE_POST_BEGIN) ? this.handleUserDefinedEnvironmentControl() : (commandName.equals(GlobalBuiltins.CMD_VERB.getTeXName()) ? this.finishVerbToken(GlobalBuiltins.CMD_VERB) : (commandName.equals(GlobalBuiltins.CMD_VERBSTAR.getTeXName()) ? this.finishVerbToken(GlobalBuiltins.CMD_VERBSTAR) : this.finishCommand(commandName)))));
        return result;
    }

    private String readCommandOrEnvironmentName(int startCommandNameIndex) {
        String commandName;
        int index = startCommandNameIndex;
        int c = this.workingDocument.charAt(index);
        if (c == -1) {
            commandName = null;
        } else if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90)) {
            commandName = Character.toString((char)c);
        } else {
            ++index;
            while ((c = this.workingDocument.charAt(index)) >= 97 && c <= 122 || c >= 65 && c <= 90) {
                ++index;
            }
            if (c == 42) {
                ++index;
            }
            commandName = ((Object)this.workingDocument.extract(startCommandNameIndex, index)).toString();
        }
        return commandName;
    }

    private FlowToken finishVerbToken(BuiltinCommand verbCommand) throws SnuggleParseException {
        int startDelimitIndex;
        int delimitChar;
        if ((delimitChar = this.workingDocument.charAt(startDelimitIndex = this.position++)) == -1) {
            return this.createError(ErrorCode.TTEV00, this.startTokenIndex, startDelimitIndex, new Object[0]);
        }
        if (Character.isWhitespace(delimitChar)) {
            return this.createError(ErrorCode.TTEV00, this.startTokenIndex, startDelimitIndex + 1, new Object[0]);
        }
        ModeState contentState = this.tokeniseInNewState(TokenisationMode.COMMAND_ARGUMENT, new StringTerminator(Character.toString((char)delimitChar)), LaTeXMode.VERBATIM);
        List<FlowToken> contentTokens = contentState.tokens;
        Token verbatimContentToken = null;
        for (FlowToken resultToken : contentTokens) {
            if (resultToken.getType() == TokenType.VERBATIM_MODE_TEXT && verbatimContentToken == null) {
                verbatimContentToken = (SimpleToken)resultToken;
                continue;
            }
            if (resultToken.getType() == TokenType.ERROR) {
                if (((ErrorToken)resultToken).getError().getErrorCode() == ErrorCode.TTEG00) continue;
                throw new SnuggleLogicException("Unexpected error when parsing \\verb content: " + resultToken);
            }
            throw new SnuggleLogicException("Unexpected token when examining \\verb content: " + resultToken);
        }
        if (verbatimContentToken == null) {
            throw new SnuggleLogicException("\\verb had no proper content token");
        }
        FrozenSlice contentSlice = verbatimContentToken.getSlice();
        int newlineIndex = this.workingDocument.indexOf(contentSlice.startIndex, '\n');
        if (newlineIndex != -1 && newlineIndex < contentSlice.endIndex) {
            return this.createError(ErrorCode.TTEV01, this.startTokenIndex, contentSlice.endIndex + 1, new Object[0]);
        }
        FrozenSlice verbatimSlice = this.workingDocument.freezeSlice(this.startTokenIndex, this.position);
        return new CommandToken(verbatimSlice, this.currentModeState.latexMode, verbCommand, null, new ArgumentContainerToken[]{new ArgumentContainerToken(contentSlice, LaTeXMode.VERBATIM, contentTokens)});
    }

    private FlowToken finishCommand(String commandName) throws SnuggleParseException {
        BuiltinCommand builtinCommand;
        FlowToken result = null;
        UserDefinedCommand userCommand = this.sessionContext.getUserCommandMap().get(commandName);
        result = userCommand != null ? this.finishUserDefinedCommand(userCommand) : ((builtinCommand = this.sessionContext.getCommandByTeXName(commandName)) != null ? this.finishBuiltinCommand(builtinCommand) : this.createError(ErrorCode.TTEC00, this.startTokenIndex, this.position, commandName));
        return result;
    }

    private FlowToken finishBuiltinCommand(BuiltinCommand command) throws SnuggleParseException {
        if (!command.getAllowedModes().contains((Object)this.currentModeState.latexMode)) {
            return this.createError(ErrorCode.TTEC01, this.startTokenIndex, this.position, new Object[]{command.getTeXName(), this.currentModeState.latexMode});
        }
        if (command == GlobalBuiltins.CMD_NEWCOMMAND || command == GlobalBuiltins.CMD_RENEWCOMMAND) {
            return this.finishCommandDefinition(command);
        }
        if (command == GlobalBuiltins.CMD_NEWENVIRONMENT || command == GlobalBuiltins.CMD_RENEWENVIRONMENT) {
            return this.finishEnvironmentDefinition(command);
        }
        switch (command.getType()) {
            case SIMPLE: {
                return this.finishSimpleCommand(command);
            }
            case COMBINER: {
                return this.finishCombiningCommand(command);
            }
            case COMPLEX: {
                return this.finishComplexCommand(command);
            }
        }
        throw new SnuggleLogicException("Unexpected switch case " + (Object)((Object)command.getType()));
    }

    private FlowToken finishSimpleCommand(BuiltinCommand command) {
        boolean isFunnyCommand = false;
        String commandName = command.getTeXName();
        if (commandName.length() == 1) {
            char c = commandName.charAt(0);
            boolean bl = isFunnyCommand = !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
        }
        if (!isFunnyCommand) {
            this.skipOverTrailingWhitespace();
        }
        return new CommandToken(this.workingDocument.freezeSlice(this.startTokenIndex, this.position), this.currentModeState.latexMode, command);
    }

    private FlowToken finishCombiningCommand(BuiltinCommand command) throws SnuggleParseException {
        this.skipOverCommentsAndWhitespace();
        int afterWhitespaceIndex = this.position;
        int startCommandIndex = this.startTokenIndex;
        FlowToken nextToken = this.readNextToken();
        if (nextToken == null) {
            return this.createError(ErrorCode.TTEC03, this.startTokenIndex, afterWhitespaceIndex, command.getTeXName());
        }
        if (!command.getAllowedCombinerIntepretationTypes().contains((Object)nextToken.getInterpretationType())) {
            return this.createError(ErrorCode.TTEC04, this.startTokenIndex, nextToken.getSlice().endIndex, command.getTeXName());
        }
        return new CommandToken(this.workingDocument.freezeSlice(startCommandIndex, nextToken.getSlice().endIndex), this.currentModeState.latexMode, command, nextToken);
    }

    private FlowToken finishComplexCommand(BuiltinCommand command) throws SnuggleParseException {
        int startCommandIndex = this.startTokenIndex;
        BuiltinCommandArgumentSearchResult argumentSearchResult = new BuiltinCommandArgumentSearchResult();
        ErrorToken errorToken = this.advanceOverBuiltinCommandOrEnvironmentArguments(command, argumentSearchResult);
        if (errorToken != null) {
            return errorToken;
        }
        FrozenSlice commandSlice = this.workingDocument.freezeSlice(startCommandIndex, this.position);
        return new CommandToken(commandSlice, this.currentModeState.latexMode, command, argumentSearchResult.optionalArgument, argumentSearchResult.requiredArguments);
    }

    private ErrorToken advanceOverBuiltinCommandOrEnvironmentArguments(CommandOrEnvironment commandOrEnvironment, BuiltinCommandArgumentSearchResult result) throws SnuggleParseException {
        ModeState argumentResult;
        int c;
        LaTeXMode argumentMode;
        if (commandOrEnvironment.getArgumentCount() == 0 && !commandOrEnvironment.isAllowingOptionalArgument()) {
            result.optionalArgument = null;
            result.requiredArguments = ArgumentContainerToken.EMPTY_ARRAY;
            return null;
        }
        this.skipOverCommentsAndWhitespace();
        ArgumentContainerToken optionalArgument = null;
        FrozenSlice optionalArgumentSlice = null;
        int argumentIndex = 0;
        if (commandOrEnvironment.isAllowingOptionalArgument()) {
            if ((argumentMode = commandOrEnvironment.getArgumentMode(argumentIndex++)) == null) {
                argumentMode = this.currentModeState.latexMode;
            }
            if ((c = this.workingDocument.charAt(this.position)) == 91) {
                int startArgumentContentIndex = ++this.position;
                argumentResult = this.tokeniseInNewState(TokenisationMode.COMMAND_ARGUMENT, new StringTerminator("]"), argumentMode);
                int endArgumentContentIndex = argumentResult.foundTerminator ? this.position - 1 : this.position;
                optionalArgumentSlice = this.workingDocument.freezeSlice(startArgumentContentIndex, endArgumentContentIndex);
                optionalArgument = new ArgumentContainerToken(optionalArgumentSlice, argumentMode, argumentResult.tokens);
            }
        }
        int argCount = commandOrEnvironment.getArgumentCount();
        ArgumentContainerToken[] requiredArguments = new ArgumentContainerToken[argCount];
        FrozenSlice[] requiredArgumentSlices = new FrozenSlice[argCount];
        for (int i = 0; i < argCount; ++i) {
            this.skipOverCommentsAndWhitespace();
            argumentMode = commandOrEnvironment.getArgumentMode(argumentIndex++);
            if (argumentMode == null) {
                argumentMode = this.currentModeState.latexMode;
            }
            if ((c = this.workingDocument.charAt(this.position)) == 123) {
                int startArgumentContentIndex = ++this.position;
                argumentResult = this.tokeniseInNewState(TokenisationMode.COMMAND_ARGUMENT, new StringTerminator("}"), argumentMode);
                int endArgumentContentIndex = argumentResult.foundTerminator ? this.position - 1 : this.position;
                requiredArgumentSlices[i] = this.workingDocument.freezeSlice(startArgumentContentIndex, endArgumentContentIndex);
                requiredArguments[i] = new ArgumentContainerToken(requiredArgumentSlices[i], argumentMode, argumentResult.tokens);
                continue;
            }
            if (c != -1 && i == 0 && argCount == 1 && optionalArgument == null && commandOrEnvironment instanceof Command) {
                LaTeXMode currentLaTeXMode = this.currentModeState.latexMode;
                this.currentModeState.latexMode = argumentMode;
                FlowToken nextToken = this.readNextToken();
                this.currentModeState.latexMode = currentLaTeXMode;
                if (nextToken != null) {
                    requiredArguments[i] = ArgumentContainerToken.createFromSingleToken(argumentMode, nextToken);
                    requiredArgumentSlices[i] = requiredArguments[i].getSlice();
                    continue;
                }
                return this.createError(ErrorCode.TTEC02, this.startTokenIndex, this.position, commandOrEnvironment.getTeXName(), 1);
            }
            return this.createError(commandOrEnvironment instanceof Command ? ErrorCode.TTEC02 : ErrorCode.TTEE06, this.startTokenIndex, this.position, commandOrEnvironment.getTeXName(), i + 1);
        }
        result.optionalArgument = optionalArgument;
        result.requiredArguments = requiredArguments;
        return null;
    }

    private FlowToken finishUserDefinedCommand(UserDefinedCommand command) throws SnuggleParseException {
        UserDefinedCommandArgumentSearchResult argumentSearchResult = new UserDefinedCommandArgumentSearchResult();
        ErrorToken errorToken = this.advanceOverUserDefinedCommandOrEnvironmentArguments(command, argumentSearchResult);
        if (errorToken != null) {
            return errorToken;
        }
        String replacement = ((Object)command.getDefinitionSlice().extract()).toString();
        int argumentNumber = 1;
        if (command.isAllowingOptionalArgument()) {
            replacement = replacement.replace("#1", argumentSearchResult.optionalArgument != null ? argumentSearchResult.optionalArgument : "");
            ++argumentNumber;
        }
        for (int i = 0; i < argumentSearchResult.requiredArguments.length; ++i) {
            replacement = replacement.replace("#" + argumentNumber++, argumentSearchResult.requiredArguments[i]);
        }
        int afterCommandIndex = this.position;
        this.makeSubstitutionAndRewind(this.startTokenIndex, afterCommandIndex, replacement);
        return this.readNextToken();
    }

    private ErrorToken advanceOverUserDefinedCommandOrEnvironmentArguments(CommandOrEnvironment commandOrEnvironment, UserDefinedCommandArgumentSearchResult result) throws SnuggleParseException {
        int c;
        if (commandOrEnvironment.getArgumentCount() == 0 && !commandOrEnvironment.isAllowingOptionalArgument()) {
            result.optionalArgument = null;
            result.requiredArguments = new CharSequence[0];
            return null;
        }
        this.skipOverCommentsAndWhitespace();
        CharSequence optionalArgument = null;
        if (commandOrEnvironment.isAllowingOptionalArgument() && (c = this.workingDocument.charAt(this.position)) == 91) {
            int openBracketIndex = this.position;
            int closeBracketIndex = this.findEndSquareBrackets(openBracketIndex);
            if (closeBracketIndex == -1) {
                return this.createError(ErrorCode.TTEG00, this.startTokenIndex, this.workingDocument.length(), Character.valueOf(']'));
            }
            optionalArgument = this.workingDocument.extract(openBracketIndex + 1, closeBracketIndex);
            this.position = closeBracketIndex + 1;
        }
        int argCount = commandOrEnvironment.getArgumentCount();
        CharSequence[] requiredArguments = new CharSequence[argCount];
        for (int i = 0; i < argCount; ++i) {
            this.skipOverCommentsAndWhitespace();
            c = this.workingDocument.charAt(this.position);
            if (c == 123) {
                int openBraceIndex = this.position;
                int closeBraceIndex = this.findEndCurlyBrackets(openBraceIndex);
                if (closeBraceIndex == -1) {
                    return this.createError(ErrorCode.TTEG00, this.startTokenIndex, this.workingDocument.length(), Character.valueOf('}'));
                }
                requiredArguments[i] = this.workingDocument.extract(openBraceIndex + 1, closeBraceIndex);
                this.position = closeBraceIndex + 1;
                continue;
            }
            if (c != -1 && i == 0 && argCount == 1 && result.optionalArgument == null) {
                FlowToken nextToken = this.readNextToken();
                if (nextToken == null) {
                    return this.createError(ErrorCode.TTEC02, this.startTokenIndex, this.position, commandOrEnvironment.getTeXName(), 1);
                }
                FrozenSlice nextSlice = nextToken.getSlice();
                requiredArguments[i] = nextSlice.extract();
                this.workingDocument.unfreeze(this.startTokenIndex);
                continue;
            }
            return this.createError(commandOrEnvironment instanceof Command ? ErrorCode.TTEC02 : ErrorCode.TTEE06, this.startTokenIndex, this.position, commandOrEnvironment.getTeXName(), i + 1);
        }
        result.optionalArgument = optionalArgument;
        result.requiredArguments = requiredArguments;
        return null;
    }

    private FlowToken finishBeginEnvironment() throws SnuggleParseException {
        BuiltinEnvironment builtinEnvironment;
        String environmentName = this.advanceOverBracesAndEnvironmentName();
        if (environmentName == null) {
            return this.createError(ErrorCode.TTEE01, this.startTokenIndex, this.position, new Object[0]);
        }
        UserDefinedEnvironment userEnvironment = this.sessionContext.getUserEnvironmentMap().get(environmentName);
        FlowToken result = null;
        result = userEnvironment != null ? this.finishBeginUserDefinedEnvironment(userEnvironment) : ((builtinEnvironment = this.sessionContext.getEnvironmentByTeXName(environmentName)) != null ? this.finishBeginBuiltinEnvironment(builtinEnvironment) : this.createError(ErrorCode.TTEE02, this.startTokenIndex, this.position, environmentName));
        return result;
    }

    private FlowToken finishEndEnvironment() throws SnuggleParseException {
        String lastOpenName;
        String environmentName = this.advanceOverBracesAndEnvironmentName();
        if (environmentName == null) {
            return this.createError(ErrorCode.TTEE01, this.startTokenIndex, this.position, new Object[0]);
        }
        String string = lastOpenName = this.openEnvironmentStack.isEmpty() ? null : this.openEnvironmentStack.peek();
        if (lastOpenName == null) {
            return this.createError(ErrorCode.TTEE05, this.startTokenIndex, this.position, new Object[0]);
        }
        if (!environmentName.equals(lastOpenName)) {
            return this.createError(ErrorCode.TTEE00, this.startTokenIndex, this.position, environmentName, lastOpenName);
        }
        this.openEnvironmentStack.pop();
        UserDefinedEnvironment userEnvironment = this.sessionContext.getUserEnvironmentMap().get(environmentName);
        FlowToken result = null;
        if (userEnvironment != null) {
            result = this.finishEndUserDefinedEnvironment(userEnvironment);
        } else {
            BuiltinEnvironment builtinEnvironment = this.sessionContext.getEnvironmentByTeXName(environmentName);
            if (builtinEnvironment == null) {
                result = this.createError(ErrorCode.TTEE02, this.startTokenIndex, this.position, environmentName);
            }
        }
        return result;
    }

    private String advanceOverBracesAndEnvironmentName() {
        this.skipOverCommentsAndWhitespace();
        if (this.workingDocument.charAt(this.position) != 123) {
            return null;
        }
        String environmentName = this.readCommandOrEnvironmentName(++this.position);
        this.position += environmentName.length();
        if (this.workingDocument.charAt(this.position) != 125) {
            return null;
        }
        ++this.position;
        return environmentName;
    }

    private FlowToken finishBeginBuiltinEnvironment(BuiltinEnvironment environment) throws SnuggleParseException {
        ArgumentContainerToken contentToken;
        int startContentIndex;
        this.openEnvironmentStack.push(environment.getTeXName());
        int startEnvironmentIndex = this.startTokenIndex;
        LaTeXMode startLatexMode = this.currentModeState.latexMode;
        ErrorToken errorToken = null;
        if (!environment.getAllowedModes().contains((Object)this.currentModeState.latexMode)) {
            errorToken = this.createError(ErrorCode.TTEE03, this.startTokenIndex, this.position, new Object[]{environment.getTeXName(), startLatexMode});
        }
        BuiltinCommandArgumentSearchResult argumentSearchResult = new BuiltinCommandArgumentSearchResult();
        errorToken = this.advanceOverBuiltinCommandOrEnvironmentArguments(environment, argumentSearchResult);
        LaTeXMode contentMode = environment.getContentMode();
        if (contentMode == null) {
            contentMode = this.currentModeState.latexMode;
        }
        if (contentMode == LaTeXMode.VERBATIM) {
            startContentIndex = this.position;
            Pattern terminatorPattern = Pattern.compile("\\\\end\\s*\\{" + environment.getTeXName() + "\\}\\s*");
            ModeState contentResult = this.tokeniseInNewState(TokenisationMode.BUILTIN_ENVIRONMENT_CONTENT, new PatternTerminator(terminatorPattern), LaTeXMode.VERBATIM);
            int endContentIndex = contentResult.computeLastTokenEndIndex();
            FrozenSlice contentSlice = this.workingDocument.freezeSlice(startContentIndex, endContentIndex);
            contentToken = new ArgumentContainerToken(contentSlice, contentMode, contentResult.tokens);
            this.openEnvironmentStack.pop();
        } else {
            this.skipOverCommentsAndWhitespace();
            startContentIndex = this.position;
            ModeState contentResult = this.tokeniseInNewState(TokenisationMode.BUILTIN_ENVIRONMENT_CONTENT, null, contentMode);
            int endContentIndex = contentResult.computeLastTokenEndIndex();
            FrozenSlice contentSlice = this.workingDocument.freezeSlice(startContentIndex, endContentIndex);
            contentToken = new ArgumentContainerToken(contentSlice, contentMode, contentResult.tokens);
        }
        if (errorToken != null) {
            this.sessionContext.getErrors().remove(errorToken.getError());
            return this.createError(errorToken.getError().getErrorCode(), this.startTokenIndex, this.position, errorToken.getError().getArguments());
        }
        FrozenSlice environmentSlice = this.workingDocument.freezeSlice(startEnvironmentIndex, this.position);
        return new EnvironmentToken(environmentSlice, startLatexMode, environment, argumentSearchResult.optionalArgument, argumentSearchResult.requiredArguments, contentToken);
    }

    private FlowToken finishBeginUserDefinedEnvironment(UserDefinedEnvironment environment) throws SnuggleParseException {
        UserDefinedCommandArgumentSearchResult argumentSearchResult = new UserDefinedCommandArgumentSearchResult();
        ErrorToken errorToken = this.advanceOverUserDefinedCommandOrEnvironmentArguments(environment, argumentSearchResult);
        if (errorToken != null) {
            return errorToken;
        }
        String environmentName = environment.getTeXName();
        if (this.userEnvironmentsOpeningSet.contains(environmentName)) {
            return this.createError(ErrorCode.TTEUE4, this.startTokenIndex, this.position, environment.getTeXName());
        }
        this.userEnvironmentsOpeningSet.add(environmentName);
        FrozenSlice beginSlice = environment.getBeginDefinitionSlice();
        String resolvedBegin = ((Object)beginSlice.extract()).toString();
        int argumentNumber = 1;
        if (environment.isAllowingOptionalArgument()) {
            resolvedBegin = resolvedBegin.replace("#1", argumentSearchResult.optionalArgument != null ? argumentSearchResult.optionalArgument : "");
            ++argumentNumber;
        }
        for (int i = 0; i < argumentSearchResult.requiredArguments.length; ++i) {
            resolvedBegin = resolvedBegin.replace("#" + argumentNumber++, argumentSearchResult.requiredArguments[i]);
        }
        resolvedBegin = resolvedBegin + "\\\u00a3{" + environment.getTeXName() + "}";
        int endBeginIndex = this.position;
        this.makeSubstitutionAndRewind(this.startTokenIndex, endBeginIndex, resolvedBegin);
        return this.readNextToken();
    }

    private FlowToken finishEndUserDefinedEnvironment(UserDefinedEnvironment environment) throws SnuggleParseException {
        int endEndIndex = this.position;
        this.makeSubstitutionAndRewind(this.startTokenIndex, endEndIndex, environment.getEndDefinitionSlice().extract());
        return this.readNextToken();
    }

    private FlowToken handleUserDefinedEnvironmentControl() throws SnuggleParseException {
        String environmentName = this.advanceOverBracesAndEnvironmentName();
        if (environmentName == null) {
            throw new SnuggleLogicException("Expected to find {envName}");
        }
        UserDefinedEnvironment userEnvironment = this.sessionContext.getUserEnvironmentMap().get(environmentName);
        if (userEnvironment == null) {
            throw new SnuggleLogicException("Environment is not user-defined");
        }
        this.userEnvironmentsOpeningSet.remove(environmentName);
        this.openEnvironmentStack.push(environmentName);
        this.makeSubstitutionAndRewind(this.startTokenIndex, this.position, "");
        return this.readNextToken();
    }

    private FlowToken finishCommandDefinition(BuiltinCommand definitionCommand) throws SnuggleParseException {
        boolean isCommandAlreadyDefined;
        ArgumentDefinitionResult argumentDefinitionResult;
        ErrorToken error;
        String commandName;
        this.skipOverCommentsAndWhitespace();
        boolean nameIsInBraces = false;
        int c = this.workingDocument.charAt(this.position);
        if (c == -1) {
            return this.createError(ErrorCode.TTEUC0, this.startTokenIndex, this.position, new Object[0]);
        }
        if (c == 123) {
            ++this.position;
            this.skipOverCommentsAndWhitespace();
            nameIsInBraces = true;
        }
        if (this.workingDocument.charAt(this.position) != 92) {
            return this.createError(ErrorCode.TTEUC1, this.startTokenIndex, this.position, new Object[0]);
        }
        if ((commandName = this.readCommandOrEnvironmentName(++this.position)) == null) {
            return this.createError(ErrorCode.TTEUC0, this.startTokenIndex, this.position, new Object[0]);
        }
        if (reservedCommands.contains(commandName)) {
            return this.createError(ErrorCode.TTEUC8, this.startTokenIndex, this.position + commandName.length(), commandName);
        }
        this.position += commandName.length();
        if (nameIsInBraces) {
            this.skipOverCommentsAndWhitespace();
            if (this.workingDocument.charAt(this.position) != 125) {
                return this.createError(ErrorCode.TTEUC6, this.startTokenIndex, this.position, new Object[0]);
            }
            ++this.position;
        }
        if ((error = this.advanceOverUserDefinedCommandOrEnvironmentArgumentDefinition(commandName, argumentDefinitionResult = new ArgumentDefinitionResult())) != null) {
            return error;
        }
        c = this.workingDocument.charAt(this.position);
        if (c != 123) {
            return this.createError(ErrorCode.TTEUC3, this.startTokenIndex, this.position, commandName);
        }
        int startCurlyIndex = this.position;
        int endCurlyIndex = this.findEndCurlyBrackets(this.position);
        if (endCurlyIndex == -1) {
            return this.createError(ErrorCode.TTEUC2, this.startTokenIndex, this.workingDocument.length(), new Object[0]);
        }
        this.position = endCurlyIndex + 1;
        this.skipOverCommentsAndWhitespace();
        FrozenSlice definitionSlice = this.workingDocument.freezeSlice(startCurlyIndex + 1, endCurlyIndex);
        UserDefinedCommand userCommand = new UserDefinedCommand(commandName, argumentDefinitionResult.allowOptionalArgument, argumentDefinitionResult.requiredArgumentCount, definitionSlice);
        Map<String, UserDefinedCommand> userCommandMap = this.sessionContext.getUserCommandMap();
        boolean isRenewing = definitionCommand == GlobalBuiltins.CMD_RENEWCOMMAND;
        boolean bl = isCommandAlreadyDefined = userCommandMap.containsKey(commandName) || this.sessionContext.getCommandByTeXName(commandName) != null;
        if (isRenewing && !isCommandAlreadyDefined) {
            return this.createError(ErrorCode.TTEUC4, this.startTokenIndex, this.position, commandName);
        }
        if (!isRenewing && isCommandAlreadyDefined) {
            return this.createError(ErrorCode.TTEUC5, this.startTokenIndex, this.position, commandName);
        }
        userCommandMap.put(commandName, userCommand);
        return new CommandToken(this.workingDocument.freezeSlice(this.startTokenIndex, this.position), this.currentModeState.latexMode, definitionCommand);
    }

    private FlowToken finishEnvironmentDefinition(BuiltinCommand definitionCommand) throws SnuggleParseException {
        boolean isEnvAlreadyDefined;
        this.skipOverCommentsAndWhitespace();
        String environmentName = this.advanceOverBracesAndEnvironmentName();
        if (environmentName == null) {
            return this.createError(ErrorCode.TTEUE0, this.startTokenIndex, this.position, new Object[0]);
        }
        if (reservedCommands.contains(environmentName)) {
            return this.createError(ErrorCode.TTEUC8, this.startTokenIndex, this.position + 2 + environmentName.length(), environmentName);
        }
        this.skipOverCommentsAndWhitespace();
        ArgumentDefinitionResult argumentDefinitionResult = new ArgumentDefinitionResult();
        ErrorToken error = this.advanceOverUserDefinedCommandOrEnvironmentArgumentDefinition(environmentName, argumentDefinitionResult);
        if (error != null) {
            return error;
        }
        FrozenSlice[] definitionSlices = new FrozenSlice[2];
        for (int i = 0; i < 2; ++i) {
            int c = this.workingDocument.charAt(this.position);
            if (c != 123) {
                return this.createError(ErrorCode.TTEUE1, this.startTokenIndex, this.position, i == 0 ? "begin" : "end", environmentName);
            }
            int startCurlyIndex = this.position;
            int endCurlyIndex = this.findEndCurlyBrackets(this.position);
            this.position = endCurlyIndex + 1;
            this.skipOverCommentsAndWhitespace();
            definitionSlices[i] = this.workingDocument.freezeSlice(startCurlyIndex + 1, endCurlyIndex);
        }
        UserDefinedEnvironment userEnvironment = new UserDefinedEnvironment(environmentName, argumentDefinitionResult.allowOptionalArgument, argumentDefinitionResult.requiredArgumentCount, definitionSlices[0], definitionSlices[1]);
        Map<String, UserDefinedEnvironment> userEnvironmentMap = this.sessionContext.getUserEnvironmentMap();
        boolean isRenewing = definitionCommand == GlobalBuiltins.CMD_RENEWENVIRONMENT;
        boolean bl = isEnvAlreadyDefined = userEnvironmentMap.containsKey(environmentName) || this.sessionContext.getEnvironmentByTeXName(environmentName) != null;
        if (isRenewing && !isEnvAlreadyDefined) {
            return this.createError(ErrorCode.TTEUE2, this.startTokenIndex, this.position, environmentName);
        }
        if (!isRenewing && isEnvAlreadyDefined) {
            return this.createError(ErrorCode.TTEUE3, this.startTokenIndex, this.position, environmentName);
        }
        userEnvironmentMap.put(environmentName, userEnvironment);
        CommandToken result = new CommandToken(this.workingDocument.freezeSlice(this.startTokenIndex, this.position), this.currentModeState.latexMode, definitionCommand);
        return result;
    }

    private ErrorToken advanceOverUserDefinedCommandOrEnvironmentArgumentDefinition(String commandOrEnvironmentName, ArgumentDefinitionResult result) throws SnuggleParseException {
        this.skipOverCommentsAndWhitespace();
        int argCount = 0;
        boolean allowOptArgs = false;
        int c = this.workingDocument.charAt(this.position);
        if (c == 91) {
            int afterOpenSquare = this.position + 1;
            int closeSquareIndex = this.findEndSquareBrackets(this.position);
            if (closeSquareIndex == -1) {
                return this.createError(ErrorCode.TTEUC9, this.startTokenIndex, this.workingDocument.length(), new Object[0]);
            }
            this.position = closeSquareIndex + 1;
            String rawArgCount = ((Object)this.workingDocument.extract(afterOpenSquare, closeSquareIndex)).toString().trim();
            try {
                argCount = Integer.parseInt(rawArgCount);
            }
            catch (NumberFormatException e) {
                return this.createError(ErrorCode.TTEUC7, this.startTokenIndex, this.position, commandOrEnvironmentName, rawArgCount);
            }
            if (argCount < 1 || argCount > 9) {
                return this.createError(ErrorCode.TTEUC7, this.startTokenIndex, this.position, commandOrEnvironmentName, rawArgCount);
            }
            this.skipOverCommentsAndWhitespace();
            if (this.workingDocument.charAt(this.position) == 91) {
                allowOptArgs = true;
                --argCount;
                closeSquareIndex = this.findEndSquareBrackets(this.position);
                if (closeSquareIndex == -1) {
                    return this.createError(ErrorCode.TTEUC9, this.startTokenIndex, this.workingDocument.length(), new Object[0]);
                }
                this.position = closeSquareIndex + 1;
            }
        }
        this.skipOverCommentsAndWhitespace();
        result.allowOptionalArgument = allowOptArgs;
        result.requiredArgumentCount = argCount;
        return null;
    }

    private int findEndSquareBrackets(int openSquareBracketIndex) {
        boolean inEscape = false;
        boolean inComment = false;
        for (int index = openSquareBracketIndex; index < this.workingDocument.length(); ++index) {
            int c = this.workingDocument.charAt(index);
            if (inComment) {
                if (c != 10) continue;
                inComment = false;
                continue;
            }
            if (c == 93) {
                return index;
            }
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if (c == 92) {
                inEscape = true;
                continue;
            }
            if (c == 123) {
                index = this.findEndCurlyBrackets(index);
                continue;
            }
            if (c != 37) continue;
            inComment = true;
        }
        return -1;
    }

    private int findEndCurlyBrackets(int openBraceIndex) {
        boolean inEscape = false;
        boolean inComment = false;
        int depth = 0;
        for (int index = openBraceIndex; index < this.workingDocument.length(); ++index) {
            int c = this.workingDocument.charAt(index);
            if (!inEscape && c == 92) {
                inEscape = true;
                continue;
            }
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if (inComment) {
                if (c != 10) continue;
                inComment = false;
                continue;
            }
            if (c == 37) {
                inComment = true;
                continue;
            }
            if (c == 123) {
                ++depth;
                continue;
            }
            if (c != 125 || --depth != 0) continue;
            return index;
        }
        return -1;
    }

    private void skipOverCommentsAndWhitespace() {
        while (this.position < this.workingDocument.length()) {
            int c = this.workingDocument.charAt(this.position);
            if (c == 37) {
                this.skipOverComment();
                continue;
            }
            if (!Character.isWhitespace(c)) break;
            ++this.position;
        }
    }

    private void skipOverComments() {
        int c;
        while (this.position < this.workingDocument.length() && (c = this.workingDocument.charAt(this.position)) == 37) {
            this.skipOverComment();
        }
    }

    private void skipOverComment() {
        int index;
        if (this.workingDocument.charAt(this.position) != 37) {
            return;
        }
        for (index = this.position + 1; index < this.workingDocument.length() && this.workingDocument.charAt(index) != 10; ++index) {
        }
        if (this.workingDocument.charAt(index) == 10) {
            int c;
            for (int searchIndex = index + 1; searchIndex < this.workingDocument.length() && (c = this.workingDocument.charAt(searchIndex)) != 10; ++searchIndex) {
                if (Character.isWhitespace(c)) continue;
                index = searchIndex;
                break;
            }
        }
        this.position = index;
    }

    private void skipOverTrailingWhitespace() {
        int c;
        while (this.position < this.workingDocument.length() && Character.isWhitespace(c = this.workingDocument.charAt(this.position)) && c != 10) {
            ++this.position;
        }
    }

    private ErrorToken createError(ErrorCode errorCode, int errorStartIndex, int errorEndIndex, Object ... arguments) throws SnuggleParseException {
        FrozenSlice errorSlice = this.workingDocument.freezeSlice(errorStartIndex, errorEndIndex);
        InputError error = new InputError(errorCode, errorSlice, arguments);
        this.sessionContext.registerError(error);
        return new ErrorToken(error, this.currentModeState != null ? this.currentModeState.latexMode : LaTeXMode.PARAGRAPH);
    }

    static final class ArgumentDefinitionResult {
        public boolean allowOptionalArgument;
        public int requiredArgumentCount;

        ArgumentDefinitionResult() {
        }
    }

    static class UserDefinedCommandArgumentSearchResult {
        public CharSequence optionalArgument;
        public CharSequence[] requiredArguments;

        UserDefinedCommandArgumentSearchResult() {
        }
    }

    static class BuiltinCommandArgumentSearchResult {
        public ArgumentContainerToken optionalArgument;
        public ArgumentContainerToken[] requiredArguments;

        BuiltinCommandArgumentSearchResult() {
        }
    }

    public static class ModeState {
        public final TokenisationMode tokenisationMode;
        public LaTeXMode latexMode;
        public final int startPosition;
        public final Terminator terminator;
        public final List<FlowToken> tokens;
        public boolean foundTerminator;

        public ModeState(TokenisationMode tokenisationMode, LaTeXMode latexMode, int startPosition, Terminator terminator) {
            this.tokenisationMode = tokenisationMode;
            this.latexMode = latexMode;
            this.startPosition = startPosition;
            this.terminator = terminator;
            this.tokens = new ArrayList<FlowToken>();
            this.foundTerminator = false;
        }

        public int computeLastTokenEndIndex() {
            if (this.tokens.isEmpty()) {
                return this.startPosition;
            }
            return this.tokens.get((int)(this.tokens.size() - 1)).getSlice().endIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TokenisationMode {
        TOP_LEVEL,
        BRACE,
        MATH,
        COMMAND_ARGUMENT,
        BUILTIN_ENVIRONMENT_CONTENT,
        USER_DEFINED_ENVIRONMENT_BEGIN;

    }

    public static final class PatternTerminator
    implements Terminator {
        private final Pattern terminatorPattern;

        public PatternTerminator(Pattern terminatorPattern) {
            this.terminatorPattern = terminatorPattern;
        }

        public int matchesAt(WorkingDocument workingDocument, int index) {
            Matcher matcher = this.terminatorPattern.matcher(workingDocument.extract());
            return matcher.find(index) && matcher.start() == index ? matcher.end() : -1;
        }

        public int nextMatchFrom(WorkingDocument workingDocument, int index) {
            Matcher matcher = this.terminatorPattern.matcher(workingDocument.extract());
            return matcher.find(index) ? matcher.start() : -1;
        }

        public String toString() {
            return "(pattern) " + this.terminatorPattern;
        }
    }

    public static final class StringTerminator
    implements Terminator {
        private final String terminatorString;

        public StringTerminator(String terminatorString) {
            this.terminatorString = terminatorString;
        }

        public int matchesAt(WorkingDocument workingDocument, int index) {
            return workingDocument.matchesAt(index, this.terminatorString) ? index + this.terminatorString.length() : -1;
        }

        public int nextMatchFrom(WorkingDocument workingDocument, int index) {
            return workingDocument.indexOf(index, this.terminatorString);
        }

        public String toString() {
            return this.terminatorString;
        }
    }

    public static interface Terminator {
        public int matchesAt(WorkingDocument var1, int var2);

        public int nextMatchFrom(WorkingDocument var1, int var2);
    }
}

