/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.ElasticSearchServiceConnector;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SpaceElasticUnifiedSearchServiceConnector
extends ElasticSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(SpaceElasticUnifiedSearchServiceConnector.class);
    private SpaceService spaceService;

    public SpaceElasticUnifiedSearchServiceConnector(InitParams initParams, ElasticSearchingClient client, SpaceService wikiService) {
        super(initParams, client);
        this.spaceService = wikiService;
    }

    protected String getSourceFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("prettyName");
        fields.add("displayName");
        fields.add("description");
        ArrayList<String> sourceFields = new ArrayList<String>();
        for (String sourceField : fields) {
            sourceFields.add("\"" + sourceField + "\"");
        }
        return StringUtils.join(sourceFields, (String)",");
    }

    protected String getPermissionFilter() {
        StringBuilder permissions = new StringBuilder();
        permissions.append(super.getPermissionFilter()).append("\n");
        permissions.append("  ,{ \"bool\" : { \n").append("    \"must_not\" : {\n").append("      \"term\" : {\n").append("        \"visibility\" : \"").append("hidden").append("\"\n").append("      }\n").append("    } \n").append("  } \n").append("  } \n");
        return permissions.toString();
    }

    protected String getSitesFilter(Collection<String> sitesCollection) {
        return null;
    }

    protected Collection<SearchResult> buildResult(String jsonResponse, SearchContext context) {
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            JSONObject hitSource = (JSONObject)((JSONObject)jsonHit).get((Object)"_source");
            Space space = this.spaceService.getSpaceById(((JSONObject)jsonHit).get((Object)"_id").toString());
            String title = this.getTitleFromJsonResult(hitSource);
            String url = this.getUrlFromJsonResult(space, context);
            Long lastUpdatedDate = (Long)hitSource.get((Object)"lastUpdatedDate");
            if (lastUpdatedDate == null) {
                lastUpdatedDate = new Date().getTime();
            }
            Double score = (Double)((JSONObject)jsonHit).get((Object)"_score");
            StringBuilder sb = new StringBuilder(String.valueOf(space.getDisplayName()));
            sb.append(String.format(" - %s Member(s)", space.getMembers().length));
            if ("open".equals(space.getRegistration())) {
                sb.append(" - Free to Join");
            } else if ("validation".equals(space.getRegistration())) {
                sb.append(" - Register");
            } else if ("close".equals(space.getRegistration())) {
                sb.append(" - Invitation Only");
            } else {
                LOG.debug((Object)(space.getRegistration() + " registration unknown"));
            }
            results.add(new SearchResult(url, title, space.getDescription(), sb.toString(), space.getAvatarUrl() != null ? space.getAvatarUrl() : "/eXoSkin/skin/images/system/SpaceAvtDefault.png", lastUpdatedDate.longValue(), score.longValue()));
        }
        return results;
    }

    private String getUrlFromJsonResult(Space space, SearchContext context) {
        try {
            String permanentSpaceName = space.getPrettyName();
            String groupId = space.getGroupId();
            String siteName = groupId.replaceAll("/", ":");
            String siteType = SiteType.GROUP.getName();
            ExoContainerContext eXoContext = (ExoContainerContext)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoContainerContext.class);
            String portalName = eXoContext.getPortalContainerName();
            String spaceURI = context.handler(portalName).lang("").siteName(siteName).siteType(siteType).path(permanentSpaceName).renderLink();
            return URLDecoder.decode(String.format("/%s%s", portalName, spaceURI), "UTF-8");
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot compute space url for " + space.getDisplayName()), (Throwable)e);
            return "";
        }
    }
}

