/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.ElasticSearchFilter;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.MembershipEntry;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ElasticSearchServiceConnector
extends SearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(ElasticSearchServiceConnector.class);
    public static final String HIGHLIGHT_FRAGMENT_SIZE_PARAM_NAME = "highlightFragmentSize";
    public static final int HIGHLIGHT_FRAGMENT_SIZE_DEFAULT_VALUE = 150;
    public static final String HIGHLIGHT_FRAGMENT_NUMBER_PARAM_NAME = "highlightFragmentNumber";
    public static final int HIGHLIGHT_FRAGMENT_NUMBER_DEFAULT_VALUE = 3;
    private final ElasticSearchingClient client;
    private String index;
    private String type;
    private List<String> searchFields;
    public int highlightFragmentSize;
    public int highlightFragmentNumber;
    private String img;
    private String titleElasticFieldName = "title";
    private String updatedDateElasticFieldName = "lastUpdatedDate";
    private Map<String, String> sortMapping = new HashMap<String, String>();

    public ElasticSearchServiceConnector(InitParams initParams, ElasticSearchingClient client) {
        super(initParams);
        String highlightFragmentNumberParamValue;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        this.type = param.getProperty("type");
        if (StringUtils.isNotBlank((String)param.getProperty("titleField"))) {
            this.titleElasticFieldName = param.getProperty("titleField");
        }
        if (StringUtils.isNotBlank((String)param.getProperty("updatedDateField"))) {
            this.updatedDateElasticFieldName = param.getProperty("updatedDateField");
        }
        this.searchFields = new ArrayList<String>(Arrays.asList(param.getProperty("searchFields").split(",")));
        String highlightFragmentSizeParamValue = param.getProperty(HIGHLIGHT_FRAGMENT_SIZE_PARAM_NAME);
        if (highlightFragmentSizeParamValue != null) {
            try {
                this.highlightFragmentSize = Integer.valueOf(highlightFragmentSizeParamValue);
            }
            catch (NumberFormatException e) {
                this.highlightFragmentSize = 150;
                LOG.warn((Object)("Value of param highlightFragmentSize of search connector " + ((Object)((Object)this)).getClass().getName() + " is not a valid number (" + highlightFragmentSizeParamValue + "), default value will be used (" + 150 + ")"));
            }
        } else {
            this.highlightFragmentSize = 150;
        }
        if ((highlightFragmentNumberParamValue = param.getProperty(HIGHLIGHT_FRAGMENT_NUMBER_PARAM_NAME)) != null) {
            try {
                this.highlightFragmentNumber = Integer.valueOf(highlightFragmentNumberParamValue);
            }
            catch (NumberFormatException e) {
                this.highlightFragmentNumber = 3;
                LOG.warn((Object)("Value of param highlightFragmentNumber of search connector " + ((Object)((Object)this)).getClass().getName() + " is not a valid number (" + highlightFragmentNumberParamValue + "), default value will be used (" + 3 + ")"));
            }
        } else {
            this.highlightFragmentNumber = 3;
        }
        this.sortMapping.put("relevancy", "_score");
        this.sortMapping.put("date", "lastUpdatedDate");
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        String esQuery = this.buildQuery(query, sites, offset, limit, sort, order);
        String jsonResponse = this.client.sendRequest(esQuery, this.index, this.type);
        return this.buildResult(jsonResponse, context);
    }

    public Collection<SearchResult> filteredSearch(SearchContext context, String query, List<ElasticSearchFilter> filters, Collection<String> sites, int offset, int limit, String sort, String order) {
        String esQuery = this.buildFilteredQuery(query, sites, filters, offset, limit, sort, order);
        String jsonResponse = this.client.sendRequest(esQuery, this.index, this.type);
        return this.buildResult(jsonResponse, context);
    }

    protected String buildQuery(String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        return this.buildFilteredQuery(query, sites, null, offset, limit, sort, order);
    }

    protected String buildFilteredQuery(String query, Collection<String> sites, List<ElasticSearchFilter> filters, int offset, int limit, String sort, String order) {
        String additionalFilters;
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{\n");
        esQuery.append("     \"from\" : " + offset + ",\n");
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            esQuery.append("     \"size\" : " + limit + ",\n");
        }
        esQuery.append("     \"track_scores\": true,\n");
        esQuery.append("     \"sort\" : [\n");
        esQuery.append("       { \"" + (StringUtils.isNotBlank((String)this.sortMapping.get(sort)) ? this.sortMapping.get(sort) : "_score") + "\" : ");
        esQuery.append("{\"order\" : \"" + (StringUtils.isNotBlank((String)order) ? order : "desc") + "\"}}\n");
        esQuery.append("     ],\n");
        esQuery.append("     \"_source\": [" + this.getSourceFields() + "],");
        esQuery.append("     \"query\": {\n");
        esQuery.append("        \"bool\" : {\n");
        esQuery.append("            \"must\" : {\n");
        esQuery.append("                \"query_string\" : {\n");
        esQuery.append("                    \"fields\" : [" + this.getFields() + "],\n");
        esQuery.append("                    \"query\" : \"" + query + "\"\n");
        esQuery.append("                }\n");
        esQuery.append("            },\n");
        esQuery.append("            \"filter\" : {\n");
        esQuery.append("              \"bool\" : {\n");
        esQuery.append("                \"must\" : [\n");
        esQuery.append("                  {\n");
        esQuery.append("                   \"bool\" : {\n");
        esQuery.append("                     \"should\" : [\n");
        esQuery.append("                      " + this.getPermissionFilter() + "\n");
        esQuery.append("                      ]\n");
        esQuery.append("                    }\n");
        esQuery.append("                  }\n");
        String sitesFilter = this.getSitesFilter(sites);
        if (StringUtils.isNotBlank((String)sitesFilter)) {
            esQuery.append("                  ,{\n");
            esQuery.append("                   \"bool\" : {\n");
            esQuery.append("                     \"should\" : \n");
            esQuery.append("                      " + sitesFilter + "\n");
            esQuery.append("                    }\n");
            esQuery.append("                  }");
        }
        if (StringUtils.isNotBlank((String)(additionalFilters = this.getAdditionalFilters(filters)))) {
            esQuery.append(additionalFilters);
        }
        esQuery.append("                  \n");
        esQuery.append("                ]\n");
        esQuery.append("              }\n");
        esQuery.append("            }");
        esQuery.append("        }\n");
        esQuery.append("     },\n");
        esQuery.append("     \"highlight\" : {\n");
        esQuery.append("       \"pre_tags\" : [\"<strong>\"],\n");
        esQuery.append("       \"post_tags\" : [\"</strong>\"],\n");
        esQuery.append("       \"fields\" : {\n");
        for (int i = 0; i < this.searchFields.size(); ++i) {
            esQuery.append("         \"" + this.searchFields.get(i) + "\" : {\n").append("          \"type\" : \"unified\",\n").append("          \"fragment_size\" : " + this.highlightFragmentSize + ",\n").append("          \"number_of_fragments\" : " + this.highlightFragmentNumber + "}");
            if (i < this.searchFields.size() - 1) {
                esQuery.append(",");
            }
            esQuery.append("\n");
        }
        esQuery.append("       }\n");
        esQuery.append("     }\n");
        esQuery.append("}");
        LOG.debug("Search Query request to ES : {} ", new Object[]{esQuery});
        return esQuery.toString();
    }

    protected Collection<SearchResult> buildResult(String jsonResponse, SearchContext context) {
        JSONArray jsonHits;
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult != null && (jsonHits = (JSONArray)jsonResult.get((Object)"hits")) != null) {
            for (Object jsonHit : jsonHits) {
                results.add(this.buildHit((JSONObject)jsonHit, context));
            }
        }
        return results;
    }

    protected SearchResult buildHit(JSONObject jsonHit, SearchContext searchContext) {
        JSONObject hitSource = (JSONObject)jsonHit.get((Object)"_source");
        String title = this.getTitleFromJsonResult(hitSource);
        String url = this.getUrlFromJsonResult(hitSource, searchContext);
        Long lastUpdatedDate = this.getUpdatedDateFromResult(hitSource);
        if (lastUpdatedDate == null) {
            lastUpdatedDate = new Date().getTime();
        }
        Double score = (Double)jsonHit.get((Object)"_score");
        String detail = this.buildDetail(jsonHit, searchContext);
        JSONObject hitHighlight = (JSONObject)jsonHit.get((Object)"highlight");
        StringBuilder excerpt = new StringBuilder();
        if (hitHighlight != null) {
            for (String key : hitHighlight.keySet()) {
                JSONArray highlights = (JSONArray)hitHighlight.get((Object)key);
                for (Object highlight : highlights) {
                    excerpt.append("... ").append(highlight);
                }
            }
        }
        LOG.debug("Excerpt extract from ES response : {}", new Object[]{excerpt.toString()});
        return new SearchResult(url, title, excerpt.toString(), detail, this.img, lastUpdatedDate.longValue(), score.longValue());
    }

    protected String buildDetail(JSONObject jsonHit, SearchContext searchContext) {
        return null;
    }

    protected Long getUpdatedDateFromResult(JSONObject hitSource) {
        Object date = hitSource.get((Object)this.updatedDateElasticFieldName);
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date != null) {
            try {
                return Long.parseLong(date.toString());
            }
            catch (Exception ex) {
                LOG.error("Can not parse updatedDate field as Long {}", new Object[]{date});
            }
        }
        return null;
    }

    protected String getUrlFromJsonResult(JSONObject hitSource, SearchContext context) {
        return (String)hitSource.get((Object)"url");
    }

    protected String getTitleFromJsonResult(JSONObject hitSource) {
        return (String)hitSource.get((Object)this.titleElasticFieldName);
    }

    protected String getAdditionalFilters(List<ElasticSearchFilter> filters) {
        if (filters == null) {
            return "";
        }
        StringBuilder filterJSON = new StringBuilder();
        for (ElasticSearchFilter filter : filters) {
            filterJSON.append("                  ,\n");
            filterJSON.append("                  {\n");
            filterJSON.append("                   \"bool\" : {\n");
            filterJSON.append("                     \"should\" : [\n");
            filterJSON.append("                      " + this.getFilter(filter) + "\n");
            filterJSON.append("                       ]\n");
            filterJSON.append("                    }\n");
            filterJSON.append("                  }");
        }
        return filterJSON.toString();
    }

    private String getFilter(ElasticSearchFilter filter) {
        switch (filter.getType()) {
            case FILTER_BY_TERM: {
                return this.getTermFilter(filter.getField(), filter.getValue());
            }
            case FILTER_EXIST: {
                return this.getExistFilter(filter.getField());
            }
            case FILTER_NOT_EXIST: {
                return this.getNotExistFilter(filter.getField());
            }
            case FILTER_CUSTOM: {
                return this.getCustomFilter(filter.getValue());
            }
        }
        return "";
    }

    private String getTermFilter(String field, String value) {
        return "{\n \"term\" : { \"" + field + "\" : \"" + value + "\" }\n }";
    }

    private String getNotExistFilter(String field) {
        return "{\n  \"not\": {\n    \"exists\" : { \"field\" : \"" + field + "\" }\n  }\n}";
    }

    private String getExistFilter(String field) {
        return "{\n \"exists\" : { \"field\" : \"" + field + "\" }\n }";
    }

    protected String getFields() {
        ArrayList<String> fields = new ArrayList<String>();
        for (String searchField : this.searchFields) {
            fields.add("\"" + searchField + "\"");
        }
        return StringUtils.join(fields, (String)",");
    }

    private String getCustomFilter(String value) {
        return value;
    }

    protected String getPermissionFilter() {
        StringBuilder permissionSB = new StringBuilder();
        Set<String> membershipSet = this.getUserMemberships();
        if (membershipSet != null && membershipSet.size() > 0) {
            String memberships = StringUtils.join((Object[])membershipSet.toArray(new String[membershipSet.size()]), (String)"|");
            permissionSB.append("{\n").append("  \"term\" : { \"permissions\" : \"").append(this.getCurrentUser()).append("\" }\n").append("},\n").append("{\n").append("  \"regexp\" : { \"permissions\" : \"").append(memberships).append("\" }\n").append("}");
        } else {
            permissionSB.append("{\n").append("  \"term\" : { \"permissions\" : \"").append(this.getCurrentUser()).append("\" }\n").append("}");
        }
        return permissionSB.toString();
    }

    protected String getSitesFilter(Collection<String> sitesCollection) {
        if (sitesCollection != null && sitesCollection.size() > 0) {
            ArrayList<String> sites = new ArrayList<String>();
            for (String site : sitesCollection) {
                sites.add("\"" + site + "\"");
            }
            String sitesList = "[" + StringUtils.join(sites, (String)",") + "]";
            return " [ { \"bool\" : {\n         \"must_not\": {\n           \"exists\" : { \"field\" : \"sites\" }\n         }\n       }\n},\n{\n  \"terms\" : { \n    \"sites\" : " + sitesList + "\n  }\n} ]";
        }
        return " { \"bool\" : {\n  \"must_not\": {\n      \"exists\" : { \"field\" : \"sites\" }\n   }\n  }\n}\n";
    }

    private String getCurrentUser() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent() is null");
        }
        if (ConversationState.getCurrent().getIdentity() == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent().getIdentity() is null");
        }
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    private Set<String> getUserMemberships() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent() is null");
        }
        if (ConversationState.getCurrent().getIdentity() == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent().getIdentity() is null");
        }
        if (ConversationState.getCurrent().getIdentity().getMemberships() == null) {
            throw new IllegalStateException("No Membership found: ConversationState.getCurrent().getIdentity().getMemberships() is null");
        }
        HashSet<String> entries = new HashSet<String>();
        for (MembershipEntry entry : ConversationState.getCurrent().getIdentity().getMemberships()) {
            if (entry.getMembershipType().equals("*")) {
                entries.add(entry.toString().replace("*", ".*"));
                continue;
            }
            entries.add(entry.toString());
            entries.add("*:" + entry.getGroup());
        }
        return entries;
    }

    protected String getSourceFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("url");
        fields.add(this.getTitleElasticFieldName());
        ArrayList<String> sourceFields = new ArrayList<String>();
        for (String sourceField : fields) {
            sourceFields.add("\"" + sourceField + "\"");
        }
        return StringUtils.join(sourceFields, (String)",");
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getImg() {
        return this.img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public String getTitleElasticFieldName() {
        return this.titleElasticFieldName;
    }

    public void setTitleElasticFieldName(String titleElasticFieldName) {
        this.titleElasticFieldName = titleElasticFieldName;
    }

    public List<String> getSearchFields() {
        return this.searchFields;
    }

    public void setSearchFields(List<String> searchFields) {
        this.searchFields = searchFields;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ElasticSearchingClient getClient() {
        return this.client;
    }
}

