/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.exoplatform.commons.utils.DateUtils;

public class CalendarSetting
implements Serializable {
    private static final long serialVersionUID = 1620512378382132299L;
    public static String DAY_VIEW = "0";
    public static String WEEK_VIEW = "1";
    public static String MONTH_VIEW = "2";
    public static String LIST_VIEW = "3";
    public static String WORKING_VIEW = "4";
    public static final long DEFAULT_TIME_INTERVAL = 30L;
    public static String SUNDAY = "1";
    public static String MONDAY = "2";
    public static String TUESDAY = "3";
    public static String WENDNESDAY = "4";
    public static String THURSDAY = "5";
    public static String FRIDAY = "6";
    public static String SATURDAY = "7";
    public static String ACTION_ALWAYS = "always";
    public static String ACTION_NEVER = "never";
    public static String ACTION_ASK = "ask";
    public static String ACTION_BYSETTING = "setting";
    private String viewType = WORKING_VIEW;
    private long timeInterval = 30L;
    private String weekStartOn = String.valueOf(1);
    private String dateFormat = "MM/dd/yyyy";
    private String timeFormat = "hh:mm a";
    private String timeZone = TimeZone.getDefault().getID();
    private String baseURL;
    private boolean isShowWorkingTime = true;
    private String workingTimeBegin;
    private String workingTimeEnd;
    private String[] sharedCalendarsColors;
    private String[] filterPrivateCalendars = new String[0];
    private String[] filterPublicCalendars = new String[0];
    private String[] filterSharedCalendars = new String[0];
    private String sendOption;

    public CalendarSetting() {
        this.sharedCalendarsColors = new String[0];
        this.sendOption = ACTION_NEVER;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public void setWeekStartOn(String weekStartOn) {
        this.weekStartOn = weekStartOn;
    }

    public String getWeekStartOn() {
        return this.weekStartOn;
    }

    public void setDateFormat(String dFormat) {
        this.dateFormat = dFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setBaseURL(String url) {
        this.baseURL = url;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setFilterPrivateCalendars(String[] defaultCalendars) {
        this.filterPrivateCalendars = defaultCalendars;
    }

    public String[] getFilterPrivateCalendars() {
        return this.filterPrivateCalendars;
    }

    public void setFilterPublicCalendars(String[] defaultCalendars) {
        this.filterPublicCalendars = defaultCalendars;
    }

    public String[] getFilterPublicCalendars() {
        return this.filterPublicCalendars;
    }

    public List<String> getFilterCalendars() {
        LinkedList<String> cals = new LinkedList<String>();
        if (this.getFilterPrivateCalendars() != null) {
            cals.addAll(Arrays.asList(this.getFilterPrivateCalendars()));
        }
        if (this.getFilterPublicCalendars() != null) {
            cals.addAll(Arrays.asList(this.getFilterPublicCalendars()));
        }
        if (this.getFilterSharedCalendars() != null) {
            cals.addAll(Arrays.asList(this.getFilterSharedCalendars()));
        }
        return cals;
    }

    public void setShowWorkingTime(boolean isShowWorkingTime) {
        this.isShowWorkingTime = isShowWorkingTime;
    }

    public boolean isShowWorkingTime() {
        return this.isShowWorkingTime;
    }

    public void setWorkingTimeBegin(String workingTimeBegin) {
        this.workingTimeBegin = workingTimeBegin;
    }

    public String getWorkingTimeBegin() {
        return this.workingTimeBegin;
    }

    public void setWorkingTimeEnd(String workingTimeEnd) {
        this.workingTimeEnd = workingTimeEnd;
    }

    public String getWorkingTimeEnd() {
        return this.workingTimeEnd;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setSharedCalendarsColors(String[] sharedCalendarColor) {
        this.sharedCalendarsColors = sharedCalendarColor;
    }

    public String[] getSharedCalendarsColors() {
        return this.sharedCalendarsColors;
    }

    public void setFilterSharedCalendars(String[] sharedCalendars) {
        this.filterSharedCalendars = sharedCalendars;
    }

    public String[] getFilterSharedCalendars() {
        return this.filterSharedCalendars;
    }

    public void setSendOption(String option) {
        this.sendOption = option;
    }

    public String getSendOption() {
        return this.sendOption;
    }

    public Calendar createCalendar(long time) {
        Calendar c = GregorianCalendar.getInstance(DateUtils.getTimeZone((String)this.timeZone));
        c.setFirstDayOfWeek(Integer.parseInt(this.weekStartOn));
        c.setTimeInMillis(time);
        c.setMinimalDaysInFirstWeek(4);
        return c;
    }

    public Calendar createCalendar(Date time) {
        return time != null ? this.createCalendar(time.getTime()) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarSetting that = (CalendarSetting)o;
        return this.timeInterval == that.timeInterval && this.isShowWorkingTime == that.isShowWorkingTime && Objects.equals(this.viewType, that.viewType) && Objects.equals(this.weekStartOn, that.weekStartOn) && Objects.equals(this.dateFormat, that.dateFormat) && Objects.equals(this.timeFormat, that.timeFormat) && Objects.equals(this.timeZone, that.timeZone) && Objects.equals(this.baseURL, that.baseURL) && Objects.equals(this.workingTimeBegin, that.workingTimeBegin) && Objects.equals(this.workingTimeEnd, that.workingTimeEnd) && Arrays.equals(this.sharedCalendarsColors, that.sharedCalendarsColors) && Arrays.equals(this.filterPrivateCalendars, that.filterPrivateCalendars) && Arrays.equals(this.filterPublicCalendars, that.filterPublicCalendars) && Arrays.equals(this.filterSharedCalendars, that.filterSharedCalendars) && Objects.equals(this.sendOption, that.sendOption);
    }

    public int hashCode() {
        return Objects.hash(this.viewType, this.timeInterval, this.weekStartOn, this.dateFormat, this.timeFormat, this.timeZone, this.baseURL, this.isShowWorkingTime, this.workingTimeBegin, this.workingTimeEnd, this.sharedCalendarsColors, this.filterPrivateCalendars, this.filterPublicCalendars, this.filterSharedCalendars, this.sendOption);
    }
}

