/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.calendar.model.Calendar;
import org.exoplatform.calendar.model.CompositeID;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.model.query.EventQuery;
import org.exoplatform.calendar.service.CalendarException;
import org.exoplatform.calendar.service.EventHandler;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.ExtendedCalendarServiceImpl;
import org.exoplatform.calendar.storage.EventDAO;
import org.exoplatform.calendar.storage.Storage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.future.FutureExoCache;
import org.exoplatform.services.cache.future.Loader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EventHandlerImpl
implements EventHandler {
    private static Log log = ExoLogger.getLogger(EventHandlerImpl.class);
    protected ExtendedCalendarServiceImpl calService;
    protected FutureExoCache<String, String, ExtendedCalendarServiceImpl> dsNameByCalId = null;

    public EventHandlerImpl(ExtendedCalendarServiceImpl service, CacheService cacheService) {
        this.calService = service;
        ExoCache dsNameByCalIdCache = cacheService.getCacheInstance("calendar.dsNameById");
        this.dsNameByCalId = new FutureExoCache((Loader)new CalDSNameLoader(), dsNameByCalIdCache);
    }

    @Override
    public Event getEventById(String eventId) {
        CompositeID composID = CompositeID.parse(eventId);
        if (composID.getDS() != null) {
            EventDAO dao = this.getEventDAOImpl(composID.getDS());
            if (dao != null) {
                return (Event)dao.getById(composID.getId());
            }
        } else {
            for (Storage storage : this.calService.getAllStorage()) {
                Event evt;
                EventDAO dao = storage.getEventDAO();
                if (dao == null || (evt = (Event)dao.getById(composID.getId())) == null) continue;
                return evt;
            }
        }
        return null;
    }

    @Override
    public Event saveEvent(Event event) {
        EventDAO dao = this.getEventDAOImpl(event.getDS());
        if (dao != null) {
            return dao.save(event);
        }
        return null;
    }

    @Override
    public Event removeEvent(String eventId) {
        CompositeID composId = CompositeID.parse(eventId);
        EventDAO dao = this.getEventDAOImpl(composId.getDS());
        if (dao != null) {
            return (Event)dao.remove(composId.getId());
        }
        return null;
    }

    @Override
    public ListAccess<Event> findEventsByQuery(EventQuery eventQuery) {
        String[] calendarIds = eventQuery.getCalendarIds();
        if (eventQuery.getDS() == null && calendarIds != null && calendarIds.length > 0) {
            Set<String> allCalIds = Arrays.stream(calendarIds).collect(Collectors.toSet());
            HashMap<String, List<String>> computedCalIdByDS = new HashMap<String, List<String>>();
            for (String calendarId : calendarIds) {
                String ds = (String)this.dsNameByCalId.get((Object)this.calService, (Object)calendarId);
                if (ds == null) {
                    if (log.isDebugEnabled()) {
                        log.warn("Can't find a store for cal id '{}'", new Object[]{calendarId});
                    }
                    ds = "jcr";
                }
                this.addCalendarIdToDSMap(calendarId, ds, allCalIds, computedCalIdByDS);
            }
            LinkedList<ListAccess<Event>> result = new LinkedList<ListAccess<Event>>();
            for (String dsName : computedCalIdByDS.keySet()) {
                try {
                    EventQuery eventQueryForDS = (EventQuery)eventQuery.clone();
                    List calIdsListByDSName = (List)computedCalIdByDS.get(dsName);
                    eventQueryForDS.setDS(dsName);
                    eventQueryForDS.setCalendarIds(calIdsListByDSName.toArray(new String[0]));
                    EventDAO dao = this.calService.lookForDS(dsName).getEventDAO();
                    ListAccess<Event> tmp = dao.findEventsByQuery(eventQueryForDS);
                    if (tmp == null) continue;
                    result.add(tmp);
                }
                catch (CloneNotSupportedException e) {
                    log.error((Object)("Cannot get events for datasource " + dsName), (Throwable)e);
                }
            }
            return this.mergeListAccesses(result);
        }
        LinkedList<EventDAO> daos = new LinkedList<EventDAO>();
        if (eventQuery.getDS() == null) {
            for (Storage storage : this.calService.getAllStorage()) {
                daos.add(storage.getEventDAO());
            }
        } else {
            daos.add(this.getEventDAOImpl(eventQuery.getDS()));
        }
        LinkedList<ListAccess<Event>> result = new LinkedList<ListAccess<Event>>();
        for (EventDAO dao : daos) {
            ListAccess<Event> tmp = dao.findEventsByQuery(eventQuery);
            if (tmp == null) continue;
            result.add(tmp);
        }
        return this.mergeListAccesses(result);
    }

    private ListAccess<Event> mergeListAccesses(List<ListAccess<Event>> result) {
        if (result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        final LinkedList<Object> events = new LinkedList<Object>();
        for (ListAccess<Event> list : result) {
            try {
                events.addAll(Arrays.asList(list.load(0, -1)));
            }
            catch (Exception e) {
                throw new CalendarException(null, e.getMessage(), e);
            }
        }
        return new ListAccess<Event>(){

            public int getSize() throws Exception {
                return events.size();
            }

            public Event[] load(int offset, int limit) throws Exception, IllegalArgumentException {
                return Utils.subArray(events.toArray(new Event[this.getSize()]), offset, limit);
            }
        };
    }

    private void addCalendarIdToDSMap(String calendarId, String ds, Set<String> allCalIds, Map<String, List<String>> computedCalIdByDS) {
        List<String> computedCalIdList = computedCalIdByDS.get(ds);
        if (computedCalIdList == null) {
            computedCalIdList = new ArrayList<String>();
            computedCalIdByDS.put(ds, computedCalIdList);
        } else if (computedCalIdList.contains(calendarId)) {
            allCalIds.remove(calendarId);
            return;
        }
        computedCalIdList.add(calendarId);
        allCalIds.remove(calendarId);
    }

    @Override
    public Event newEventInstance(String dsId) {
        EventDAO dao = this.getEventDAOImpl(dsId);
        if (dao != null) {
            return (Event)dao.newInstance();
        }
        return null;
    }

    private EventDAO getEventDAOImpl(String id) {
        return this.calService.lookForDS(id).getEventDAO();
    }

    private final class CalDSNameLoader
    implements Loader<String, String, ExtendedCalendarServiceImpl> {
        private CalDSNameLoader() {
        }

        public String retrieve(ExtendedCalendarServiceImpl calService, String calendarId) throws Exception {
            Calendar calendar;
            CompositeID composId = CompositeID.parse(calendarId);
            String ds = composId.getDS();
            if (log.isDebugEnabled()) {
                log.warn("Calendar id '{}' hasn't store definition, search information from store", new Object[]{calendarId});
            }
            if ((calendar = calService.getCalendarHandler().getCalendarById(calendarId)) == null) {
                return null;
            }
            ds = calendar.getDS();
            if (ds == null) {
                if (log.isDebugEnabled()) {
                    log.warn((Object)"Retrieved calendar '{}' from stores hasn't a DS definition, use default one");
                }
                ds = "jcr";
            }
            return ds;
        }
    }
}

