/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.CMAPTable;
import org.apache.fontbox.ttf.DigitalSignatureTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.MemoryTTFDataStream;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.RAFDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

abstract class AbstractTTFParser {
    protected boolean isEmbedded = false;
    protected boolean parseOnDemandOnly = false;

    AbstractTTFParser(boolean fontIsEmbedded) {
        this(fontIsEmbedded, false);
    }

    AbstractTTFParser(boolean fontIsEmbedded, boolean parseOnDemand) {
        this.isEmbedded = fontIsEmbedded;
        this.parseOnDemandOnly = parseOnDemand;
    }

    public TrueTypeFont parseTTF(String ttfFile) throws IOException {
        return this.parseTTF(new File(ttfFile));
    }

    public TrueTypeFont parseTTF(File ttfFile) throws IOException {
        RAFDataStream raf = new RAFDataStream(ttfFile, "r");
        try {
            return this.parseTTF(raf);
        }
        catch (IOException ex) {
            raf.close();
            throw ex;
        }
    }

    public TrueTypeFont parseTTF(InputStream inputStream) throws IOException {
        return this.parseTTF(new MemoryTTFDataStream(inputStream));
    }

    public TrueTypeFont parseTTF(TTFDataStream raf) throws IOException {
        TrueTypeFont font = new TrueTypeFont(raf);
        font.setVersion(raf.read32Fixed());
        int numberOfTables = raf.readUnsignedShort();
        int searchRange = raf.readUnsignedShort();
        int entrySelector = raf.readUnsignedShort();
        int rangeShift = raf.readUnsignedShort();
        for (int i = 0; i < numberOfTables; ++i) {
            TTFTable table = this.readTableDirectory(raf);
            font.addTable(table);
        }
        if (!this.parseOnDemandOnly) {
            this.parseTables(font, raf);
        }
        return font;
    }

    protected void parseTables(TrueTypeFont font, TTFDataStream raf) throws IOException {
        for (TTFTable table : font.getTables()) {
            if (table.getInitialized()) continue;
            font.initializeTable(table);
        }
        HeaderTable head = font.getHeader();
        if (head == null) {
            throw new IOException("head is mandatory");
        }
        HorizontalHeaderTable hh = font.getHorizontalHeader();
        if (hh == null) {
            throw new IOException("hhead is mandatory");
        }
        MaximumProfileTable maxp = font.getMaximumProfile();
        if (maxp == null) {
            throw new IOException("maxp is mandatory");
        }
        PostScriptTable post = font.getPostScript();
        if (post == null && !this.isEmbedded) {
            throw new IOException("post is mandatory");
        }
        IndexToLocationTable loc = font.getIndexToLocation();
        if (loc == null) {
            throw new IOException("loca is mandatory");
        }
        if (font.getGlyph() == null) {
            throw new IOException("glyf is mandatory");
        }
        if (font.getNaming() == null && !this.isEmbedded) {
            throw new IOException("name is mandatory");
        }
        if (font.getHorizontalMetrics() == null) {
            throw new IOException("hmtx is mandatory");
        }
    }

    private TTFTable readTableDirectory(TTFDataStream raf) throws IOException {
        TTFTable retval = null;
        String tag = raf.readString(4);
        retval = tag.equals("cmap") ? new CMAPTable() : (tag.equals("glyf") ? new GlyphTable() : (tag.equals("head") ? new HeaderTable() : (tag.equals("hhea") ? new HorizontalHeaderTable() : (tag.equals("hmtx") ? new HorizontalMetricsTable() : (tag.equals("loca") ? new IndexToLocationTable() : (tag.equals("maxp") ? new MaximumProfileTable() : (tag.equals("name") ? new NamingTable() : (tag.equals("OS/2") ? new OS2WindowsMetricsTable() : (tag.equals("post") ? new PostScriptTable() : (tag.equals("DSIG") ? new DigitalSignatureTable() : new TTFTable()))))))))));
        retval.setTag(tag);
        retval.setCheckSum(raf.readUnsignedInt());
        retval.setOffset(raf.readUnsignedInt());
        retval.setLength(raf.readUnsignedInt());
        return retval;
    }
}

