/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link.impl;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NodeFinderImpl
implements NodeFinder {
    private final RepositoryService repositoryService_;
    private final LinkManager linkManager_;

    public NodeFinderImpl(RepositoryService repositoryService, LinkManager linkManager) {
        this.repositoryService_ = repositoryService;
        this.linkManager_ = linkManager;
    }

    @Override
    public Item getItem(String workspace, String absPath, boolean giveTarget) throws PathNotFoundException, RepositoryException {
        return this.getItemGiveTargetSys(workspace, absPath, giveTarget, false);
    }

    @Override
    public Item getItemGiveTargetSys(String workspace, String absPath, boolean giveTarget, boolean system) throws PathNotFoundException, RepositoryException {
        if (!absPath.startsWith("/")) {
            throw new IllegalArgumentException(absPath + " isn't absolute path");
        }
        Session session = this.getSession(this.repositoryService_.getCurrentRepository(), workspace);
        return this.getItemTarget(session, absPath, giveTarget, system);
    }

    @Override
    public Item getItem(String workspace, String absPath) throws PathNotFoundException, RepositoryException {
        return this.getItem(workspace, absPath, false);
    }

    @Override
    public Item getItemSys(String workspace, String absPath, boolean system) throws PathNotFoundException, RepositoryException {
        return this.getItemGiveTargetSys(workspace, absPath, false, system);
    }

    @Override
    public Node getNode(Node ancestorNode, String relativePath, boolean giveTarget) throws PathNotFoundException, RepositoryException {
        if (relativePath.startsWith("/")) {
            throw new IllegalArgumentException("Invalid relative path: " + relativePath);
        }
        String absPath = "";
        absPath = ancestorNode.getPath().equals("/") ? "/" + relativePath : ancestorNode.getPath() + "/" + relativePath;
        Session session = ancestorNode.getSession();
        return (Node)this.getItem(session, absPath, giveTarget);
    }

    @Override
    public Node getNode(Node ancestorNode, String relativePath) throws PathNotFoundException, RepositoryException {
        return this.getNode(ancestorNode, relativePath, false);
    }

    @Override
    public Item getItem(Session session, String absPath, boolean giveTarget) throws PathNotFoundException, RepositoryException {
        return this.getItem(session, absPath, giveTarget, 0, false);
    }

    @Override
    public Item getItemTarget(Session session, String absPath, boolean giveTarget, boolean system) throws PathNotFoundException, RepositoryException {
        return this.getItem(session, absPath, giveTarget, 0, system);
    }

    @Override
    public Item getItem(Session session, String absPath) throws PathNotFoundException, RepositoryException {
        return this.getItem(session, absPath, false);
    }

    @Override
    public boolean itemExists(Session session, String absPath) throws RepositoryException {
        try {
            return this.getItem(session, absPath) != null;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public Item getItem(Session session, String absPath, boolean giveTarget, int fromIdx, boolean system) throws PathNotFoundException, RepositoryException {
        boolean itemExists;
        if (absPath.contains("\\'")) {
            absPath = absPath.replaceAll("\\\\'", "'");
        }
        if (!(itemExists = session.itemExists(absPath)) && absPath.contains("%") && session.itemExists(Text.unescapeIllegalJcrChars((String)absPath))) {
            absPath = Text.unescapeIllegalJcrChars((String)absPath);
            itemExists = session.itemExists(absPath);
        }
        if (itemExists) {
            Item item = session.getItem(absPath);
            if (giveTarget && this.linkManager_.isLink(item)) {
                return this.linkManager_.getTarget((Node)item);
            }
            return item;
        }
        String[] splitPath = absPath.substring(1).split("/");
        int low = fromIdx;
        int high = splitPath.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            String partPath = this.makePath(splitPath, mid);
            if (session.itemExists(partPath)) {
                Item item = session.getItem(partPath);
                if (this.linkManager_.isLink(item)) {
                    Node link = (Node)item;
                    if (this.linkManager_.isTargetReachable(link, system)) {
                        Node target = this.linkManager_.getTarget(link, system);
                        String targetPath = target.getPath();
                        return this.getItem(target.getSession(), targetPath + absPath.substring(partPath.length()), giveTarget, targetPath.substring(1).split("/").length, system);
                    }
                    throw new PathNotFoundException("Can't reach the target of the link: " + link.getPath());
                }
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        throw new PathNotFoundException("Can't find path: " + absPath);
    }

    public Session getSession(ManageableRepository manageableRepository, String workspace) throws RepositoryException {
        SessionProviderService service = WCMCoreUtils.getService(SessionProviderService.class);
        return service.getSessionProvider(null).getSession(workspace, manageableRepository);
    }

    public String makePath(String[] splitString, int toIdx) {
        StringBuilder buffer = new StringBuilder(1024);
        for (int i = 0; i <= toIdx; ++i) {
            buffer.append('/').append(splitString[i]);
        }
        return buffer.toString();
    }
}

