/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.taxonomy.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyAlreadyExistsException;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyNodeAlreadyExistsException;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyPlugin;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyTreeDefaultUserPermission;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class TaxonomyServiceImpl
implements TaxonomyService,
Startable {
    private SessionProviderService providerService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService repositoryService_;
    private static final String TAXONOMY_LINK = "exo:taxonomyLink";
    private static final String EXOSYMLINK_LINK = "exo:symlink";
    private static final String EXO_WORKSPACE = "exo:workspace";
    private static final String EXO_UUID = "exo:uuid";
    private LinkManager linkManager_;
    private ListenerService listenerService;
    private ActivityCommonService activityService;
    private final String SQL_QUERY = "Select * from exo:taxonomyLink where jcr:path like '$0/%' and exo:uuid = '$1' and exo:workspace = '$2' order by exo:dateCreated DESC";
    private final String SQL_QUERY_EXACT_PATH = "Select * from exo:taxonomyLink where jcr:path like '$0/%' and not jcr:path like '$0/%/%' and exo:uuid = '$1' and exo:workspace = '$2' order by exo:dateCreated DESC";
    List<TaxonomyPlugin> plugins_ = new ArrayList<TaxonomyPlugin>();
    private DMSConfiguration dmsConfiguration_;
    private Map<String, String[]> taxonomyTreeDefaultUserPermissions_;
    private static final Log LOG = ExoLogger.getLogger((String)TaxonomyServiceImpl.class.getName());
    private static String categoryNameLength_ = null;

    public TaxonomyServiceImpl(InitParams initParams, SessionProviderService providerService, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repoService, LinkManager linkManager, DMSConfiguration dmsConfiguration) throws Exception {
        this.providerService_ = providerService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repoService;
        this.linkManager_ = linkManager;
        this.dmsConfiguration_ = dmsConfiguration;
        ValueParam valueParam = initParams.getValueParam("categoryNameLength");
        categoryNameLength_ = valueParam != null ? valueParam.getValue() : "150";
        ObjectParameter objectParam = initParams.getObjectParam("defaultPermission.configuration");
        if (objectParam != null) {
            this.taxonomyTreeDefaultUserPermissions_ = this.getPermissions(((TaxonomyTreeDefaultUserPermission)objectParam.getObject()).getPermissions());
        }
        this.activityService = WCMCoreUtils.getService(ActivityCommonService.class);
    }

    @Override
    public String getCategoryNameLength() {
        return categoryNameLength_;
    }

    @Override
    public void init() throws Exception {
        for (TaxonomyPlugin plugin : this.plugins_) {
            plugin.init();
        }
    }

    @Override
    public void addTaxonomyPlugin(ComponentPlugin plugin) {
        if (plugin instanceof TaxonomyPlugin) {
            this.plugins_.add((TaxonomyPlugin)plugin);
        }
    }

    @Override
    public List<Node> getAllTaxonomyTrees() throws RepositoryException {
        return this.getAllTaxonomyTrees(false);
    }

    @Override
    public List<Node> getAllTaxonomyTrees(boolean system) throws RepositoryException {
        ArrayList<Node> listNode = new ArrayList<Node>();
        try {
            Node taxonomyDef = this.getRootTaxonomyDef();
            NodeIterator nodeIter = taxonomyDef.getNodes();
            while (nodeIter.hasNext()) {
                Node node = (Node)nodeIter.next();
                if (!node.isNodeType(EXOSYMLINK_LINK)) continue;
                try {
                    Node target = this.linkManager_.getTarget(node, system);
                    if (target == null) continue;
                    listNode.add(target);
                }
                catch (ItemNotFoundException ex) {
                }
                catch (AccessDeniedException adex) {}
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        return listNode;
    }

    @Override
    public Node getTaxonomyTree(String taxonomyName) throws RepositoryException {
        return this.getTaxonomyTree(taxonomyName, false);
    }

    @Override
    public Node getTaxonomyTree(String taxonomyName, boolean system) throws RepositoryException {
        try {
            Node taxonomyDef = this.getRootTaxonomyDef();
            try {
                Node taxonomyTree = taxonomyDef.getNode(taxonomyName);
                if (taxonomyTree.isNodeType(EXOSYMLINK_LINK)) {
                    return this.linkManager_.getTarget(taxonomyTree, system);
                }
            }
            catch (PathNotFoundException pne) {
                throw new RepositoryException((Throwable)pne);
            }
        }
        catch (RepositoryConfigurationException e1) {
            throw new RepositoryException((Throwable)e1);
        }
        catch (PathNotFoundException e2) {
            throw new RepositoryException((Throwable)e2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTaxonomyTree(String taxonomyName) throws RepositoryException {
        try (SessionProvider systemProvider = SessionProvider.createSystemProvider();){
            Node taxonomyTree = this.getRootTaxonomyDef(systemProvider).getNode(taxonomyName);
            boolean bl = taxonomyTree.isNodeType(EXOSYMLINK_LINK);
            return bl;
        }
        return false;
    }

    @Override
    public void addTaxonomyTree(Node taxonomyTree) throws RepositoryException, TaxonomyAlreadyExistsException {
        if (this.hasTaxonomyTree(taxonomyTree.getName())) {
            throw new TaxonomyAlreadyExistsException();
        }
        try (SessionProvider systemProvider = SessionProvider.createSystemProvider();){
            Node taxonomyDef = this.getRootTaxonomyDef(systemProvider);
            this.linkManager_.createLink(taxonomyDef, EXOSYMLINK_LINK, taxonomyTree, taxonomyTree.getName());
        }
    }

    @Override
    public void updateTaxonomyTree(String taxonomyName, Node taxonomyTree) throws RepositoryException {
        try {
            if (this.hasTaxonomyTree(taxonomyName)) {
                Node taxonomyTreeLink = this.getRootTaxonomyDef().getNode(taxonomyName);
                this.linkManager_.updateLink(taxonomyTreeLink, taxonomyTree);
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void removeTaxonomyTree(String taxonomyName) throws RepositoryException {
        Session session = null;
        try {
            if (this.hasTaxonomyTree(taxonomyName)) {
                Node targetNode = this.getTaxonomyTree(taxonomyName, true);
                session = targetNode.getSession();
                targetNode.remove();
                session.save();
                Node taxonomyDef = this.getRootTaxonomyDef();
                if (taxonomyDef.hasNode(taxonomyName)) {
                    Node taxonomyTree = taxonomyDef.getNode(taxonomyName);
                    taxonomyTree.remove();
                    taxonomyDef.getSession().save();
                }
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void addTaxonomyNode(String workspace, String parentPath, String taxoNodeName, String creatorUser) throws RepositoryException, TaxonomyNodeAlreadyExistsException {
        Session systemSession = null;
        try {
            ManageableRepository manaRepo = this.repositoryService_.getCurrentRepository();
            systemSession = this.getSession(manaRepo, workspace, true);
            Node parentNode = (Node)systemSession.getItem(parentPath);
            if (parentNode.hasNode(taxoNodeName)) {
                throw new TaxonomyNodeAlreadyExistsException();
            }
            ExtendedNode node = (ExtendedNode)parentNode.addNode(taxoNodeName, "exo:taxonomy");
            if (node.canAddMixin("exo:privilegeable")) {
                if (node.hasProperty("exo:owner")) {
                    String owner = node.getProperty("exo:owner").getString();
                    node.addMixin("exo:privilegeable");
                    node.setPermission(owner, PermissionType.ALL);
                    if (creatorUser != null) {
                        node.setPermission(creatorUser, PermissionType.ALL);
                    }
                    for (Map.Entry<String, String[]> entry : this.taxonomyTreeDefaultUserPermissions_.entrySet()) {
                        node.setPermission(entry.getKey(), entry.getValue());
                    }
                }
                if (!node.isNodeType("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                }
                String systemUser = IdentityConstants.SYSTEM;
                if (!this.containsUser(node.getACL().getPermissionEntries(), systemUser)) {
                    node.setPermission(systemUser, PermissionType.ALL);
                }
            }
            systemSession.save();
        }
        catch (PathNotFoundException e2) {
            throw new RepositoryException((Throwable)e2);
        }
    }

    private boolean containsUser(List<AccessControlEntry> entries, String userName) {
        if (userName == null) {
            return false;
        }
        for (AccessControlEntry entry : entries) {
            if (!userName.equals(entry.getIdentity())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeTaxonomyNode(String workspace, String absPath) throws RepositoryException {
        Session systemSession = null;
        try {
            ManageableRepository manaRepo = this.repositoryService_.getCurrentRepository();
            systemSession = this.getSession(manaRepo, workspace, true);
            Node taxonomyNode = (Node)systemSession.getItem(absPath);
            taxonomyNode.remove();
            systemSession.save();
        }
        catch (PathNotFoundException e2) {
            throw new RepositoryException((Throwable)e2);
        }
    }

    @Override
    public List<Node> getCategories(Node node, String taxonomyName) throws RepositoryException {
        return this.getCategories(node, taxonomyName, false);
    }

    @Override
    public List<Node> getCategories(Node node, String taxonomyName, boolean system) throws RepositoryException {
        ArrayList<Node> listCate = new ArrayList<Node>();
        Session session = null;
        try {
            Node rootNodeTaxonomy;
            if (node.isNodeType("mix:referenceable") && (rootNodeTaxonomy = this.getTaxonomyTree(taxonomyName, system)) != null) {
                String sql = null;
                sql = StringUtils.replace((String)"Select * from exo:taxonomyLink where jcr:path like '$0/%' and exo:uuid = '$1' and exo:workspace = '$2' order by exo:dateCreated DESC", (String)"$0", (String)rootNodeTaxonomy.getPath());
                sql = StringUtils.replace((String)sql, (String)"$1", (String)node.getUUID());
                sql = StringUtils.replace((String)sql, (String)"$2", (String)node.getSession().getWorkspace().getName());
                session = this.repositoryService_.getCurrentRepository().login(rootNodeTaxonomy.getSession().getWorkspace().getName());
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(sql, "sql");
                QueryResult result = query.execute();
                NodeIterator iterate = result.getNodes();
                HashSet<String> addedNode = new HashSet<String>();
                while (iterate.hasNext()) {
                    Node parentCate = iterate.nextNode().getParent();
                    if (addedNode.contains(parentCate.getSession().getWorkspace().getName() + ":/" + parentCate.getPath())) continue;
                    listCate.add(parentCate);
                    addedNode.add(parentCate.getSession().getWorkspace().getName() + ":/" + parentCate.getPath());
                }
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return listCate;
    }

    @Override
    public List<Node> getAllCategories(Node node) throws RepositoryException {
        return this.getAllCategories(node, false);
    }

    @Override
    public List<Node> getAllCategories(Node node, boolean system) throws RepositoryException {
        ArrayList<Node> listCategories = new ArrayList<Node>();
        List<Node> allTrees = this.getAllTaxonomyTrees(system);
        for (Node tree : allTrees) {
            List<Node> categories = this.getCategories(node, tree.getName(), system);
            for (Node category : categories) {
                listCategories.add(category);
            }
        }
        return listCategories;
    }

    @Override
    public void addCategory(Node node, String taxonomyName, String categoryPath) throws RepositoryException {
        this.addCategories(node, taxonomyName, new String[]{categoryPath});
    }

    @Override
    public void addCategory(Node node, String taxonomyName, String categoryPath, boolean system) throws RepositoryException {
        this.addCategories(node, taxonomyName, new String[]{categoryPath}, system);
    }

    @Override
    public void addCategories(Node node, String taxonomyName, String[] categoryPaths) throws RepositoryException {
        this.addCategories(node, taxonomyName, categoryPaths, false);
    }

    @Override
    public void addCategories(Node node, String taxonomyName, String[] categoryPaths, boolean system) throws RepositoryException {
        if (this.listenerService == null) {
            this.listenerService = WCMCoreUtils.getService(ListenerService.class);
        }
        String category = "";
        try {
            Node rootNodeTaxonomy = this.getTaxonomyTree(taxonomyName, system);
            for (String categoryPath : categoryPaths) {
                category = rootNodeTaxonomy.getPath().equals("/") ? categoryPath : (categoryPath.length() != 0 ? (!categoryPath.startsWith("/") ? rootNodeTaxonomy.getPath() + "/" + categoryPath : rootNodeTaxonomy.getPath() + categoryPath) : rootNodeTaxonomy.getPath());
                Node categoryNode = categoryPath.startsWith(rootNodeTaxonomy.getPath()) ? (Node)rootNodeTaxonomy.getSession().getItem(categoryPath) : (categoryPath.equals("") ? rootNodeTaxonomy : (Node)rootNodeTaxonomy.getSession().getItem(category));
                String categoryName = categoryNode.getName();
                if (categoryNode.hasProperty("exo:title")) {
                    categoryName = categoryNode.getProperty("exo:title").getString();
                }
                if (node.canAddMixin("mix:referenceable")) {
                    node.addMixin("mix:referenceable");
                    node.getSession().save();
                }
                String nodeUUID = node.getUUID();
                String nodeWS = node.getSession().getWorkspace().getName();
                String linkName = node.getName();
                int index = 1;
                while (categoryNode.hasNode(linkName)) {
                    Node taxonomyNode = categoryNode.getNode(linkName);
                    if (nodeUUID.equals(taxonomyNode.getProperty(EXO_UUID).getString()) && nodeWS.equals(taxonomyNode.getProperty(EXO_WORKSPACE).getString())) {
                        throw new ItemExistsException();
                    }
                    linkName = node.getName() + index++;
                }
                this.linkManager_.createLink(categoryNode, TAXONOMY_LINK, node, linkName);
                if (this.listenerService == null) continue;
                try {
                    if (!this.activityService.isAcceptedNode(node) && (!node.getPrimaryNodeType().getName().equals("nt:file") || !this.activityService.isBroadcastNTFileEvents(node))) continue;
                    this.listenerService.broadcast(ActivityCommonService.CATEGORY_ADDED_ACTIVITY, (Object)node, (Object)categoryName);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("Can not notify CategoryAddedActivity because of: " + e.getMessage()));
                }
            }
        }
        catch (PathNotFoundException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public boolean hasCategories(Node node, String taxonomyName) throws RepositoryException {
        return this.hasCategories(node, taxonomyName, false);
    }

    @Override
    public boolean hasCategories(Node node, String taxonomyName, boolean system) throws RepositoryException {
        List<Node> listCate = this.getCategories(node, taxonomyName, system);
        return listCate != null && listCate.size() > 0;
    }

    @Override
    public void moveTaxonomyNode(String workspace, String srcPath, String destPath, String type) throws RepositoryException {
        Session systemSession = null;
        ManageableRepository manaRepo = this.repositoryService_.getCurrentRepository();
        systemSession = this.getSession(manaRepo, workspace, true);
        if ("cut".equals(type)) {
            systemSession.move(srcPath, destPath);
            systemSession.save();
        } else if ("copy".equals(type)) {
            Workspace wspace = systemSession.getWorkspace();
            wspace.copy(srcPath, destPath);
            systemSession.save();
        } else {
            throw new UnsupportedRepositoryOperationException();
        }
    }

    @Override
    public void removeCategory(Node node, String taxonomyName, String categoryPath) throws RepositoryException {
        this.removeCategory(node, taxonomyName, categoryPath, false);
    }

    @Override
    public void removeCategory(Node node, String taxonomyName, String categoryPath, boolean system) throws RepositoryException {
        block8: {
            try {
                String category = "";
                Node rootNodeTaxonomy = this.getTaxonomyTree(taxonomyName, system);
                category = rootNodeTaxonomy.getPath().equals("/") ? categoryPath : (!categoryPath.startsWith("/") ? rootNodeTaxonomy.getPath() + "/" + categoryPath : rootNodeTaxonomy.getPath() + categoryPath);
                Node categoryNode = (Node)rootNodeTaxonomy.getSession().getItem(category);
                String categoryName = categoryNode.getName();
                String sql = StringUtils.replace((String)"Select * from exo:taxonomyLink where jcr:path like '$0/%' and not jcr:path like '$0/%/%' and exo:uuid = '$1' and exo:workspace = '$2' order by exo:dateCreated DESC", (String)"$0", (String)categoryNode.getPath());
                sql = StringUtils.replace((String)sql, (String)"$1", (String)node.getUUID());
                sql = StringUtils.replace((String)sql, (String)"$2", (String)node.getSession().getWorkspace().getName());
                QueryManager queryManager = categoryNode.getSession().getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(sql, "sql");
                QueryResult result = query.execute();
                NodeIterator iterate = result.getNodes();
                Node nodeTaxonomyLink = null;
                if (iterate != null && iterate.hasNext()) {
                    nodeTaxonomyLink = iterate.nextNode();
                }
                if (nodeTaxonomyLink == null) {
                    throw new RepositoryException("canot found taxonomy link node");
                }
                nodeTaxonomyLink.remove();
                categoryNode.save();
                node.getSession().save();
                if (this.listenerService == null) break block8;
                try {
                    if (this.activityService.isAcceptedNode(node) || node.getPrimaryNodeType().getName().equals("nt:file") && this.activityService.isBroadcastNTFileEvents(node)) {
                        this.listenerService.broadcast(ActivityCommonService.CATEGORY_REMOVED_ACTIVITY, (Object)node, (Object)categoryName);
                    }
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Can not notify Activity because of: " + e.getMessage()));
                    }
                }
            }
            catch (PathNotFoundException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    @Override
    public Map<String, String[]> getTaxonomyTreeDefaultUserPermission() {
        return this.taxonomyTreeDefaultUserPermissions_;
    }

    public Map<String, String[]> getPermissions(List<TaxonomyTreeDefaultUserPermission.Permission> permissions) {
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        for (TaxonomyTreeDefaultUserPermission.Permission permission : permissions) {
            StringBuilder strPer = new StringBuilder();
            if ("true".equals(permission.getRead())) {
                strPer.append("read");
            }
            if ("true".equals(permission.getAddNode())) {
                strPer.append(",").append("add_node");
            }
            if ("true".equals(permission.getSetProperty())) {
                strPer.append(",").append("set_property");
            }
            if ("true".equals(permission.getRemove())) {
                strPer.append(",").append("remove");
            }
            permissionsMap.put(permission.getIdentity(), strPer.toString().split(","));
        }
        return permissionsMap;
    }

    private Node getRootTaxonomyDef(SessionProvider systemProvider) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository manaRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        Session systemSession = systemProvider.getSession(dmsRepoConfig.getSystemWorkspace(), manaRepository);
        String taxonomiesTreeDef = this.nodeHierarchyCreator_.getJcrPath("exoTaxoTreesDefinitionPath");
        Node taxonomyRootDef = (Node)systemSession.getItem(taxonomiesTreeDef);
        return taxonomyRootDef;
    }

    private Node getRootTaxonomyDef() throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository manaRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        Session systemSession = this.getSession(manaRepository, dmsRepoConfig.getSystemWorkspace(), true);
        String taxonomiesTreeDef = this.nodeHierarchyCreator_.getJcrPath("exoTaxoTreesDefinitionPath");
        Node taxonomyRootDef = (Node)systemSession.getItem(taxonomiesTreeDef);
        return taxonomyRootDef;
    }

    private Session getSession(ManageableRepository manageRepository, String workspaceName, boolean system) throws RepositoryException {
        if (system) {
            return this.providerService_.getSystemSessionProvider(null).getSession(workspaceName, manageRepository);
        }
        return this.providerService_.getSessionProvider(null).getSession(workspaceName, manageRepository);
    }

    public void start() {
        block3: {
            try {
                for (TaxonomyPlugin plugin : this.plugins_) {
                    plugin.init();
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    public void stop() {
    }
}

