/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.webui.navigation;

import org.exoplatform.platform.webui.navigation.UINavigationNodeSelector;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/platform/webui/containers/UINavigationManagement.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddRootNodeActionListener.class})})
public class UINavigationManagement
extends UIContainer {
    private SiteKey siteKey;

    public UINavigationManagement() throws Exception {
        this.addChild(UINavigationNodeSelector.class, null, null);
    }

    public SiteKey getSiteKey() {
        return this.siteKey;
    }

    public void setSiteKey(SiteKey key) {
        this.siteKey = key;
    }

    public <T extends UIComponent> T setRendered(boolean b) {
        return (T)super.setRendered(b);
    }

    public void loadView(Event<? extends UIComponent> event) throws Exception {
        UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)this.getChild(UINavigationNodeSelector.class);
        UITree uiTree = (UITree)uiNodeSelector.getChild(UITree.class);
        uiTree.createEvent("ChangeNode", event.getExecutionPhase(), event.getRequestContext()).broadcast();
    }

    public static class AddRootNodeActionListener
    extends EventListener<UINavigationManagement> {
        public void execute(Event<UINavigationManagement> event) throws Exception {
            UINavigationManagement uiManagement = (UINavigationManagement)((Object)event.getSource());
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)uiManagement.getChild(UINavigationNodeSelector.class);
            UIRightClickPopupMenu menu = (UIRightClickPopupMenu)uiNodeSelector.getChild(UIRightClickPopupMenu.class);
            menu.createEvent("AddNode", Event.Phase.PROCESS, event.getRequestContext()).broadcast();
        }
    }

    public static class SaveActionListener
    extends EventListener<UINavigationManagement> {
        public void execute(Event<UINavigationManagement> event) throws Exception {
            UserNavigation persistNavigation;
            UserPortalConfig userPortalConfig;
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UINavigationManagement uiManagement = (UINavigationManagement)((Object)event.getSource());
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)uiManagement.getChild(UINavigationNodeSelector.class);
            UserPortalConfigService portalConfigService = (UserPortalConfigService)uiManagement.getApplicationComponent(UserPortalConfigService.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getParent();
            uiPopup.createEvent("ClosePopup", Event.Phase.PROCESS, event.getRequestContext()).broadcast();
            UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            prContext.setFullRender(true);
            UserNavigation navigation = uiNodeSelector.getEdittedNavigation();
            SiteKey siteKey = navigation.getKey();
            String editedOwnerId = siteKey.getName();
            if (SiteType.PORTAL.equals((Object)siteKey.getType())) {
                userPortalConfig = portalConfigService.getUserPortalConfig(editedOwnerId, event.getRequestContext().getRemoteUser());
                if (userPortalConfig == null) {
                    prContext.getUIApplication().addMessage(new ApplicationMessage("UIPortalForm.msg.notExistAnymore", null, 0));
                    return;
                }
            } else {
                userPortalConfig = portalConfigService.getUserPortalConfig(prContext.getPortalOwner(), event.getRequestContext().getRemoteUser());
            }
            if ((persistNavigation = userPortalConfig.getUserPortal().getNavigation(siteKey)) == null) {
                prContext.getUIApplication().addMessage(new ApplicationMessage("UINavigationManagement.msg.NavigationNotExistAnymore", null, 0));
                return;
            }
            uiNodeSelector.save();
        }
    }
}

