/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.service.QueueMessage;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class QueueMessageImpl
extends AbstractService
implements QueueMessage,
Startable {
    private static final Log LOG = ExoLogger.getExoLogger(QueueMessageImpl.class);
    private static final String MAX_TO_SEND_SYS_KEY = "conf.notification.service.QueueMessage.numberOfMailPerBatch";
    private static final String MAX_TO_SEND_KEY = "numberOfMailPerBatch";
    private static final int MAX_TO_SEND_DEFAULT = 20;
    private boolean enabled = true;
    private int maxToSend;
    private MailService mailService;
    private ListenerService listenerService;
    private NotificationConfiguration notificationConfiguration;
    final transient ReentrantLock lock = new ReentrantLock();
    private Set<MessageInfo> messages = Collections.synchronizedSet(new HashSet());
    private ThreadLocal<Set<String>> idsRemovingLocal = new ThreadLocal();

    public QueueMessageImpl(NotificationConfiguration notificationConfiguration, MailService mailService, ListenerService listenerService, SettingService settingService, InitParams params) {
        this.notificationConfiguration = notificationConfiguration;
        this.listenerService = listenerService;
        this.mailService = mailService;
        this.maxToSend = NotificationUtils.getSystemValue(params, MAX_TO_SEND_SYS_KEY, MAX_TO_SEND_KEY, 20);
    }

    public boolean put(MessageInfo message) throws Exception {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        if (message == null || message.getTo() == null || message.getTo().length() == 0) {
            return false;
        }
        if (!NotificationUtils.isValidEmailAddresses(message.getTo())) {
            LOG.warn((Object)String.format("The email %s is not valid for sending notification", message.getTo()));
            return false;
        }
        if (stats) {
            LOG.info((Object)("Tenant Name:: " + CommonsUtils.getRepository().getConfiguration().getName()));
            LOG.info((Object)("Message::From: " + message.getFrom() + " To: " + message.getTo() + " body: " + message.getBody()));
        }
        this.saveMessageInfo(message);
        this.listenerService.broadcast(new Event("MESSAGE_ADDED_IN_QUEUE", (Object)this, (Object)message.getId()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws Exception {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            this.load(sProvider);
            if (this.idsRemovingLocal.get() == null) {
                this.idsRemovingLocal.set(new HashSet());
            }
            if (this.messages.size() > 0) {
                LOG.info((Object)(this.messages.size() + " message(s) will be sent."));
            }
            for (MessageInfo messageInfo : this.messages) {
                if (messageInfo == null || this.idsRemovingLocal.get().contains(messageInfo.getId()) || !this.sendMessage(messageInfo)) continue;
                LOG.debug((Object)("Message sent to user: " + messageInfo.getTo()));
                this.idsRemovingLocal.get().add(messageInfo.getId());
                if (!stats) continue;
                NotificationContextFactory.getInstance().getStatisticsCollector().pollQueue(messageInfo.getPluginId());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to send message.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            sProvider.close();
            this.removeMessageInfo();
        }
    }

    private void load(SessionProvider sProvider) {
        try {
            NodeIterator iterator = this.getMessageInfoNodes(sProvider);
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                MessageInfo messageInfo = this.getMessageInfo(node);
                messageInfo.setId(node.getUUID());
                this.messages.add(messageInfo);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to load message.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMessageInfo(MessageInfo message) {
        ReentrantLock lock = this.lock;
        lock.lock();
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        try {
            message.setCreatedTime(System.currentTimeMillis());
            Node messageInfoHome = this.getMessageInfoHomeNode(sProvider, this.notificationConfiguration.getWorkspace());
            Node messageInfoNode = messageInfoHome.addNode(String.valueOf(message.getCreatedTime()), "ntf:messageInfo");
            if (messageInfoNode.canAddMixin("mix:referenceable")) {
                messageInfoNode.addMixin("mix:referenceable");
            }
            this.saveData(messageInfoNode, StringCommonUtils.compress(message.toJSON()));
            QueueMessageImpl.sessionSave(messageInfoHome);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to save message.");
            LOG.debug((Object)(e.getMessage() + message.toJSON()), (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessageInfo() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ReentrantLock lock = this.lock;
        ArrayList ids = new ArrayList(this.idsRemovingLocal.get());
        try {
            lock.lock();
            Session session = QueueMessageImpl.getSession(sProvider, this.notificationConfiguration.getWorkspace());
            for (String messageId : ids) {
                session.getNodeByUUID(messageId).remove();
                this.listenerService.broadcast(new Event("MESSAGE_DELETED_FROM_QUEUE", (Object)this, (Object)messageId));
                LOG.debug((Object)("Removing messageId: " + messageId));
            }
            session.save();
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to remove message.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.messages.clear();
            this.idsRemovingLocal.get().removeAll(ids);
            lock.unlock();
            sProvider.close();
        }
    }

    private NodeIterator getMessageInfoNodes(SessionProvider sProvider) {
        try {
            Node messageInfoHome = this.getMessageInfoHomeNode(sProvider, this.notificationConfiguration.getWorkspace());
            QueryManager qm = messageInfoHome.getSession().getWorkspace().getQueryManager();
            StringBuilder sqlQuery = new StringBuilder();
            sqlQuery.append("SELECT * FROM ").append("ntf:messageInfo").append(" WHERE jcr:path LIKE '").append(messageInfoHome.getPath()).append("/%' AND NOT jcr:path LIKE '").append(messageInfoHome.getPath()).append("/%/%'").append(" ORDER BY exo:name");
            QueryImpl query = (QueryImpl)qm.createQuery(sqlQuery.toString(), "sql");
            query.setOffset(0L);
            query.setLimit((long)this.maxToSend);
            QueryResult result = query.execute();
            return result.getNodes();
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get message from node.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public MessageInfo getMessageInfo(Node messageInfoNode) {
        try {
            String messageJson = this.getDataJson(messageInfoNode);
            JSONObject object = new JSONObject(messageJson);
            MessageInfo info = new MessageInfo();
            info.pluginId(object.optString("pluginId")).from(object.getString("from")).to(object.getString("to")).subject(object.getString("subject")).body(object.getString("body")).footer(object.optString("footer")).setCreatedTime(object.getLong("createdTime"));
            return info;
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to map message between node and model.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean sendMessage(MessageInfo message) throws Exception {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        if (this.enabled) {
            try {
                if (message.getFrom() == null) {
                    return false;
                }
                this.mailService.sendMessage(message.makeEmailNotification());
                return true;
            }
            catch (Exception e) {
                LOG.error((Object)("Error while sending a message - Cause : " + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        this.listenerService.broadcast(new Event("MESSAGE_SENT_FROM_QUEUE", (Object)this, (Object)message.getId()));
        return true;
    }

    public void enable(boolean enabled) {
        this.enabled = enabled;
    }

    public void start() {
    }

    public void stop() {
    }

    private void saveData(Node node, InputStream is) throws Exception {
        Node fileNode = node.addNode("datajson", "nt:file");
        Node nodeContent = fileNode.addNode("jcr:content", "nt:resource");
        nodeContent.setProperty("jcr:mimeType", "application/x-gzip");
        nodeContent.setProperty("jcr:data", is);
        nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
    }

    private String getDataJson(Node node) throws Exception {
        Node fileNode = node.getNode("datajson");
        Node nodeContent = fileNode.getNode("jcr:content");
        InputStream stream = nodeContent.getProperty("jcr:data").getStream();
        return StringCommonUtils.decompress(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        int t = 0;
        int j = 0;
        String pli = "";
        try {
            NodeIterator it;
            Session session = QueueMessageImpl.getSession(sProvider, this.notificationConfiguration.getWorkspace());
            Node root = session.getRootNode();
            LOG.debug((Object)"Removing messages: ");
            if (root.hasNode("eXoNotification/messageInfoHome")) {
                it = root.getNode("eXoNotification/messageInfoHome").getNodes();
                this.removeNodes(session, it);
            }
            LOG.debug((Object)"Done to removed messages! ");
            LOG.debug((Object)"Removing notification info... ");
            it = root.getNode("eXoNotification/messageHome").getNodes();
            ArrayList<String> pluginPaths = new ArrayList<String>();
            while (it.hasNext()) {
                pluginPaths.add(it.nextNode().getPath());
            }
            session.logout();
            Iterator iterator = pluginPaths.iterator();
            while (iterator.hasNext()) {
                String string;
                pli = string = (String)iterator.next();
                LOG.debug((Object)("Remove notification info on plugin: " + pli));
                session = QueueMessageImpl.getSession(sProvider, this.notificationConfiguration.getWorkspace());
                it = ((Node)session.getItem(string)).getNodes();
                while (it.hasNext()) {
                    NodeIterator hIter = it.nextNode().getNodes();
                    j = this.removeNodes(session, hIter);
                    t += j;
                }
                LOG.debug((Object)("Removed " + j + " nodes info on plugin: " + pli));
                session.logout();
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Removed " + j + " nodes info on plugin: " + pli));
            LOG.debug((Object)("Removed all " + t + " nodes."));
            LOG.debug((Object)("Failed to remove all data of feature notification." + e.getMessage()));
        }
        finally {
            sProvider.close();
        }
    }

    private int removeNodes(Session session, NodeIterator it) throws Exception {
        int i = 0;
        int size = Integer.valueOf(System.getProperty("sizePersiter", "200"));
        LOG.debug((Object)"Starting to remove nodes...");
        while (it.hasNext()) {
            it.nextNode().remove();
            if (++i % size != 0) continue;
            session.save();
        }
        session.save();
        LOG.debug((Object)String.format("Done to removed %s nodes", i));
        return i;
    }
}

