/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.invalidation;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.services.cache.concurrent.ListenerContext;
import org.exoplatform.services.cache.invalidation.HashCode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AsyncInvalidationExoCache<K extends Serializable, V>
extends ConcurrentFIFOExoCache<K, V> {
    private static final Log LOG = ExoLogger.getLogger(AsyncInvalidationExoCache.class);
    private final ExoCache<K, HashCode<V>> replicatedCache;
    private final HashCode<V> invalidationHashCodeObject = new HashCode<String>(new String("NULL_OBJECT_INVALIDATION"));
    private final int invalidationHashCode = this.invalidationHashCodeObject.hashCode();

    public AsyncInvalidationExoCache(ExoCache<K, HashCode<V>> replicatedCache) {
        this.replicatedCache = replicatedCache;
        this.setMaxSize(replicatedCache.getMaxSize());
        this.setName(replicatedCache.getName());
        this.setLiveTime(replicatedCache.getLiveTime());
        this.setLabel(replicatedCache.getLabel());
        this.setLogEnabled(replicatedCache.isLogEnabled());
        this.replicatedCache.addCacheListener(new InvalidationListener());
    }

    @Override
    public void put(K key, V value) throws NullPointerException {
        HashCode<V> hashCode = new HashCode<V>(value);
        LOG.debug((Object)(this.getName() + "  PUT KEY " + key + " hash " + hashCode));
        super.put(key, value);
        this.replicatedCache.put(key, hashCode);
    }

    @Override
    public void putLocal(K key, V value) throws NullPointerException {
        LOG.debug((Object)(this.getName() + " PUT Local  KEY " + key));
        super.put(key, value);
    }

    @Override
    public V remove(Serializable key) throws NullPointerException {
        LOG.debug((Object)(this.getName() + "  Remove KEY " + key));
        Object value = super.remove(key);
        HashCode<V> hashCode = this.replicatedCache.get(key);
        if (value != null && hashCode == null) {
            this.replicatedCache.put(key, this.invalidationHashCodeObject);
        } else {
            this.replicatedCache.remove(key);
        }
        return value;
    }

    @Override
    public void removeLocal(Serializable key) throws NullPointerException {
        LOG.debug((Object)(this.getName() + "  Remove Local KEY " + key));
        super.remove(key);
    }

    @Override
    public void putMap(Map<? extends K, ? extends V> objs) throws NullPointerException, IllegalArgumentException {
        if (objs == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        super.putMap(objs);
        LinkedHashMap<K, HashCode<V>> map = new LinkedHashMap<K, HashCode<V>>();
        for (Map.Entry<K, V> entry : objs.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("No null cache key accepted");
            }
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("No null cache value accepted");
            }
            map.put(entry.getKey(), new HashCode<V>(entry.getValue()));
        }
        this.replicatedCache.putAsyncMap(map);
    }

    @Override
    public void onExpire(K key, V obj) {
        this.replicatedCache.removeLocal((Serializable)key);
        super.onExpire(key, obj);
    }

    @Override
    public void onClearCache() {
        this.replicatedCache.clearCache();
        super.onClearCache();
    }

    @Override
    public List<ListenerContext<K, V>> getListeners() {
        return super.getListeners();
    }

    private class InvalidationListener
    implements CacheListener<K, HashCode<V>> {
        private InvalidationListener() {
        }

        @Override
        public void onExpire(CacheListenerContext context, K key, HashCode<V> obj) throws Exception {
        }

        @Override
        public void onRemove(CacheListenerContext context, K key, HashCode<V> obj) throws Exception {
            LOG.debug((Object)(AsyncInvalidationExoCache.this.getName() + " ON onRemove KEY " + key));
            AsyncInvalidationExoCache.this.removeLocal((Serializable)key);
        }

        @Override
        public void onPut(CacheListenerContext context, K key, HashCode<V> obj) throws Exception {
            Object value;
            Object v0 = value = obj == null ? null : obj.getValue();
            if (value == null) {
                if (obj.hashCode() == AsyncInvalidationExoCache.this.invalidationHashCode) {
                    LOG.debug((Object)(AsyncInvalidationExoCache.this.getName() + " ON PUT invalidationHashCode KEY " + key + " hashCode " + obj.hashCode()));
                    AsyncInvalidationExoCache.this.removeLocal((Serializable)key);
                    return;
                }
                Object currentValue = AsyncInvalidationExoCache.this.get((Serializable)key);
                if (currentValue != null && obj != null && currentValue.hashCode() == obj.hashCode()) {
                    LOG.debug((Object)(AsyncInvalidationExoCache.this.getName() + " ON PUT equal hash KEY " + key + " hashCode " + obj.hashCode()));
                    value = currentValue;
                } else {
                    LOG.debug((Object)(AsyncInvalidationExoCache.this.getName() + " ON PUT not equal hash KEY " + key + " hashCode " + obj.hashCode()));
                    value = null;
                    AsyncInvalidationExoCache.this.removeLocal((Serializable)key);
                }
            }
            for (ListenerContext listenerContext : AsyncInvalidationExoCache.this.getListeners()) {
                try {
                    listenerContext.onPut(key, value);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
                }
            }
        }

        @Override
        public void onGet(CacheListenerContext context, K key, HashCode<V> obj) throws Exception {
        }

        @Override
        public void onClearCache(CacheListenerContext context) throws Exception {
        }
    }
}

