/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.compressor.impl;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.WarningLevel;
import java.io.Reader;
import java.io.Writer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.portal.resource.compressor.BaseResourceCompressorPlugin;
import org.exoplatform.portal.resource.compressor.ResourceCompressorException;
import org.exoplatform.portal.resource.compressor.ResourceType;

public class ClosureCompressorPlugin
extends BaseResourceCompressorPlugin {
    private volatile CompilationLevel compilationLevel;

    public ClosureCompressorPlugin(InitParams params) {
        super(params);
        ValueParam vp = params.getValueParam("level");
        CompilationLevel level = null;
        if (vp != null) {
            String value = vp.getValue().trim().toLowerCase();
            this.log.debug((Object)("found compressor level configuration " + value));
            this.setLevel(value);
        }
        if (level == null) {
            this.log.debug((Object)"no compressor level found, will use simple level instead");
            level = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        }
        this.compilationLevel = level;
    }

    @Managed
    @ManagedDescription(value="The compression level value among {basic,simple,advanced}")
    public String getLevel() {
        if (this.compilationLevel == CompilationLevel.WHITESPACE_ONLY) {
            return "basic";
        }
        if (this.compilationLevel == CompilationLevel.ADVANCED_OPTIMIZATIONS) {
            return "advanced";
        }
        return "simple";
    }

    @Managed
    public void setLevel(String level) {
        if (level != null) {
            if ("basic".equals(level = level.trim().toLowerCase())) {
                this.log.debug((Object)"configuring to basic level configuration");
                this.compilationLevel = CompilationLevel.WHITESPACE_ONLY;
            } else if ("simple".equals(level)) {
                this.log.debug((Object)"configuring to simple level configuration");
                this.compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
            } else if ("advanced".equals(level)) {
                this.log.debug((Object)"configuring to advanced level configuration");
                this.compilationLevel = CompilationLevel.ADVANCED_OPTIMIZATIONS;
            }
        }
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.JAVASCRIPT;
    }

    @Override
    public void compress(Reader input, Writer output) throws ResourceCompressorException {
        CompilationLevel level = this.compilationLevel;
        if (level == null) {
            level = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        }
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        options.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
        level.setOptionsForCompilationLevel(options);
        WarningLevel.QUIET.setOptionsForWarningLevel(options);
        JSSourceFile extern = JSSourceFile.fromCode((String)"extern", (String)"");
        try {
            String code = JSSourceFile.fromReader((String)"code", (Reader)input).getCode();
            JSSourceFile jsInput = JSSourceFile.fromCode((String)"jsInput", (String)code);
            compiler.compile((SourceFile)extern, (SourceFile)jsInput, options);
            output.write(compiler.toSource());
        }
        catch (Exception ex) {
            throw new ResourceCompressorException(ex);
        }
    }
}

