/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.jeuclid.elements.support.attributes.FontFamily;
import net.sourceforge.jeuclid.elements.support.attributes.MathVariant;
import net.sourceforge.jeuclid.elements.support.text.CodePointAndVariant;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.fonts.Glyphs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharacterMapping
implements Serializable {
    private static final String LOAD_ERROR = "Error loading character mappings";
    private static final int POS_MAPS = 5;
    private static final int POS_DESCRIPTION = 1;
    private static final int POS_CODESTR = 0;
    private static final int HIGHPLANE_MATH_CHARS_START = 119808;
    private static final int HIGHPLANE_START = 65536;
    private static final long serialVersionUID = 1L;
    private static CharacterMapping instance;
    private static final Log LOGGER;
    private final Map<Integer, CodePointAndVariant> extractAttrs = new TreeMap<Integer, CodePointAndVariant>();
    private final Set<Integer> forceSet = new TreeSet<Integer>();
    private final Map<FontFamily, Map<Integer, Integer[]>> composeAttrs = new EnumMap<FontFamily, Map<Integer, Integer[]>>(FontFamily.class);
    private transient Map<CodePointAndVariant, Reference<List<CodePointAndVariant>>> alternatives;

    private CharacterMapping() {
        this.readResolve();
        this.loadUnicodeData();
    }

    private Object readResolve() {
        this.alternatives = new HashMap<CodePointAndVariant, Reference<List<CodePointAndVariant>>>();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUnicodeData() {
        InputStream inputStream = CharacterMapping.class.getResourceAsStream("/UnicodeData.txt");
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(";");
                    if (stringArray.length <= 5) continue;
                    this.process(stringArray[0], stringArray[1], stringArray[5]);
                }
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)LOAD_ERROR, (Throwable)iOException);
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    LOGGER.warn((Object)LOAD_ERROR, (Throwable)iOException);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.warn((Object)LOAD_ERROR, (Throwable)nullPointerException);
        }
    }

    private void process(String string, String string2, String string3) {
        try {
            boolean bl;
            int n = Integer.parseInt(string, 16);
            if (!string3.startsWith("<font> ")) {
                return;
            }
            int n2 = Integer.parseInt(string3.substring(7), 16);
            int n3 = this.parseAwtStyle(string2);
            FontFamily fontFamily = this.parseFontFamily(string2);
            if (fontFamily == null) {
                return;
            }
            boolean bl2 = bl = n >= 119808 && (FontFamily.SANSSERIF.equals((Object)fontFamily) || FontFamily.SERIF.equals((Object)fontFamily));
            if (bl) {
                this.forceSet.add(n);
            }
            CodePointAndVariant codePointAndVariant = new CodePointAndVariant(n2, new MathVariant(n3, fontFamily));
            this.extractAttrs.put(n, codePointAndVariant);
            Map<Integer, Integer[]> map = this.getFFMap(fontFamily);
            Integer[] integerArray = this.getMapsTo(n2, map);
            integerArray[n3] = n;
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.debug((Object)"Parse Error", (Throwable)numberFormatException);
        }
    }

    private Integer[] getMapsTo(int n, Map<Integer, Integer[]> map) {
        Integer[] integerArray = map.get(n);
        if (integerArray == null) {
            integerArray = new Integer[4];
            map.put(n, integerArray);
        }
        return integerArray;
    }

    private Map<Integer, Integer[]> getFFMap(FontFamily fontFamily) {
        Map<Integer, Integer[]> map = this.composeAttrs.get((Object)fontFamily);
        if (map == null) {
            map = new TreeMap<Integer, Integer[]>();
            this.composeAttrs.put(fontFamily, map);
        }
        return map;
    }

    private int parseAwtStyle(String string) {
        int n = 0;
        if (string.contains("BOLD")) {
            ++n;
        }
        if (string.contains("ITALIC")) {
            n += 2;
        }
        return n;
    }

    private FontFamily parseFontFamily(String string) {
        FontFamily fontFamily = string.contains("DOUBLE-STRUCK") ? FontFamily.DOUBLE_STRUCK : (string.contains("SCRIPT") ? FontFamily.SCRIPT : (string.contains("BLACK-LETTER") || string.contains("FRAKTUR") ? FontFamily.FRAKTUR : (string.contains("SANS-SERIF") ? FontFamily.SANSSERIF : (string.contains("MONOSPACE") ? FontFamily.MONOSPACED : (string.contains("MATHEMATICAL") ? FontFamily.SERIF : null)))));
        return fontFamily;
    }

    public static synchronized CharacterMapping getInstance() {
        if (instance == null) {
            CharacterMapping characterMapping;
            try {
                InputStream inputStream = CharacterMapping.class.getResourceAsStream("/charmap.ser");
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                characterMapping = (CharacterMapping)objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (ClassNotFoundException classNotFoundException) {
                characterMapping = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                characterMapping = null;
            }
            catch (IOException iOException) {
                characterMapping = null;
            }
            catch (NullPointerException nullPointerException) {
                characterMapping = null;
            }
            instance = characterMapping == null ? new CharacterMapping() : characterMapping;
        }
        return instance;
    }

    public CodePointAndVariant composeUnicodeChar(CodePointAndVariant codePointAndVariant, boolean bl) {
        MathVariant mathVariant = codePointAndVariant.getVariant();
        Map<Integer, Integer[]> map = this.composeAttrs.get((Object)mathVariant.getFontFamily());
        if (map == null) {
            return codePointAndVariant;
        }
        Integer[] integerArray = map.get(codePointAndVariant.getCodePoint());
        if (integerArray == null) {
            return codePointAndVariant;
        }
        int n = mathVariant.getAwtStyle();
        Integer n2 = integerArray[n];
        if (n2 != null) {
            if (bl && n2 >= 65536) {
                return codePointAndVariant;
            }
            return new CodePointAndVariant(n2, MathVariant.NORMAL);
        }
        if (n != 0) {
            n2 = integerArray[0];
        }
        if (n2 != null) {
            if (bl && n2 >= 65536) {
                return codePointAndVariant;
            }
            return new CodePointAndVariant(n2, new MathVariant(n, FontFamily.SERIF));
        }
        return codePointAndVariant;
    }

    public CodePointAndVariant extractUnicodeAttr(CodePointAndVariant codePointAndVariant) {
        CodePointAndVariant codePointAndVariant2;
        CodePointAndVariant codePointAndVariant3 = this.extractAttrs.get(codePointAndVariant.getCodePoint());
        if (codePointAndVariant3 == null) {
            return codePointAndVariant;
        }
        MathVariant mathVariant = codePointAndVariant.getVariant();
        int n = mathVariant.getAwtStyle();
        int n2 = codePointAndVariant3.getCodePoint();
        if (n == 0 || this.forceSet.contains(n2)) {
            codePointAndVariant2 = codePointAndVariant3;
        } else {
            MathVariant mathVariant2 = codePointAndVariant3.getVariant();
            codePointAndVariant2 = new CodePointAndVariant(n2, new MathVariant(n | mathVariant2.getAwtStyle(), mathVariant2.getFontFamily()));
        }
        return codePointAndVariant2;
    }

    public List<CodePointAndVariant> getAllAlternatives(CodePointAndVariant codePointAndVariant) {
        Reference<List<CodePointAndVariant>> reference = this.alternatives.get(codePointAndVariant);
        List<CodePointAndVariant> list = null;
        if (reference != null) {
            list = reference.get();
        }
        if (list == null) {
            list = this.reallyGetAllAternatives(codePointAndVariant, true);
            this.alternatives.put(codePointAndVariant, new SoftReference<List<CodePointAndVariant>>(list));
        }
        return list;
    }

    private List<CodePointAndVariant> reallyGetAllAternatives(CodePointAndVariant codePointAndVariant, boolean bl) {
        ArrayList<CodePointAndVariant> arrayList = new ArrayList<CodePointAndVariant>(3);
        CodePointAndVariant codePointAndVariant2 = this.extractUnicodeAttr(codePointAndVariant);
        CodePointAndVariant codePointAndVariant3 = this.composeUnicodeChar(codePointAndVariant2, StringUtil.OSX);
        this.addGlyphsAndTheirAlternatives(arrayList, codePointAndVariant2, bl);
        this.addGlyphsAndTheirAlternatives(arrayList, codePointAndVariant3, bl);
        this.addGlyphsAndTheirAlternatives(arrayList, codePointAndVariant, bl);
        return arrayList;
    }

    private void addGlyphsAndTheirAlternatives(List<CodePointAndVariant> list, CodePointAndVariant codePointAndVariant, boolean bl) {
        if (!list.contains(codePointAndVariant)) {
            list.add(codePointAndVariant);
            if (bl) {
                this.addAlternateGlyph(list, codePointAndVariant);
            }
        }
    }

    private void addAlternateGlyph(List<CodePointAndVariant> list, CodePointAndVariant codePointAndVariant) {
        int n = codePointAndVariant.getCodePoint();
        String string = new String(new int[]{n}, 0, 1);
        String string2 = Glyphs.stringToGlyph((String)string);
        String[] stringArray = Glyphs.getCharNameAlternativesFor((String)string2);
        if (stringArray != null) {
            for (String string3 : stringArray) {
                int n2 = Glyphs.getUnicodeSequenceForGlyphName((String)string3).codePointAt(0);
                List<CodePointAndVariant> list2 = this.reallyGetAllAternatives(new CodePointAndVariant(n2, codePointAndVariant.getVariant()), false);
                for (CodePointAndVariant codePointAndVariant2 : list2) {
                    if (list.contains(codePointAndVariant2)) continue;
                    list.add(codePointAndVariant2);
                }
            }
        }
    }

    static {
        LOGGER = LogFactory.getLog(CharacterMapping.class);
    }
}

