/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;

public class TreeNode {
    private static final Log LOG = ExoLogger.getLogger((String)TreeNode.class.getName());
    private boolean isExpanded_;
    private String path_;
    private String prefix;
    private NodeLocation node_;
    private NodeLinkAware node;
    private String name_;
    private List<TreeNode> children_ = new ArrayList<TreeNode>();
    private long childrenSize;

    public TreeNode(Node node) throws RepositoryException {
        this(node, node.getPath());
    }

    private TreeNode(Node node, String path) {
        if (node instanceof NodeLinkAware) {
            this.node = (NodeLinkAware)node;
            try {
                this.childrenSize = this.node.getNodesLazily().getSize();
            }
            catch (RepositoryException e) {
                this.childrenSize = 0L;
            }
        } else {
            this.node_ = NodeLocation.getNodeLocationByNode((Node)node);
            try {
                this.childrenSize = ((NodeImpl)node).getNodesLazily().getSize();
            }
            catch (RepositoryException e) {
                this.childrenSize = 0L;
            }
        }
        this.name_ = this.getName(node);
        this.isExpanded_ = false;
        this.path_ = path;
        this.prefix = this.path_.equals("/") ? "" : this.path_;
    }

    public boolean isExpanded() {
        return this.isExpanded_;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded_ = isExpanded;
    }

    public String getName() throws RepositoryException {
        return this.name_;
    }

    private String getName(Node node) {
        StringBuilder buffer;
        block3: {
            buffer = new StringBuilder(128);
            try {
                buffer.append(node.getName());
                int index = node.getIndex();
                if (index > 1) {
                    buffer.append('[');
                    buffer.append(index);
                    buffer.append(']');
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)e.getMessage());
            }
        }
        return buffer.toString();
    }

    public String getPath() {
        return this.path_;
    }

    public String getNodePath() throws RepositoryException {
        return this.node != null ? this.node.getPath() : this.node_.getPath();
    }

    public Node getNode() {
        return this.node != null ? this.node : NodeLocation.getNodeByLocation((NodeLocation)this.node_);
    }

    public void setNode(Node node) {
        if (node instanceof NodeLinkAware) {
            this.node = (NodeLinkAware)node;
        } else {
            this.node_ = NodeLocation.getNodeLocationByNode((Node)node);
        }
    }

    public String getNodePath4ID() {
        String tmp = Text.escape((String)this.path_);
        return tmp.replace('%', '_');
    }

    public List<TreeNode> getChildren() {
        return this.children_;
    }

    public int getChildrenSize() {
        return (int)this.childrenSize;
    }

    public TreeNode getChildByName(String name) throws RepositoryException {
        for (TreeNode child : this.children_) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        Node tempNode = this.getNode().getNode(name);
        if (tempNode == null) {
            return null;
        }
        TreeNode tempTreeNode = new TreeNode(tempNode, this.prefix + "/" + this.getName(tempNode));
        return tempTreeNode;
    }

    public void setChildren(List<Node> children) throws Exception {
        this.setExpanded(true);
        for (Node child : children) {
            this.children_.add(new TreeNode(child, this.prefix + "/" + this.getName(child)));
        }
    }
}

