/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeCreateChild;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeMainForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionTaxonomyManager;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionTypeForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeInfo;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeManager;
import org.exoplatform.ecm.webui.core.bean.PermissionBean;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyAlreadyExistsException;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyNodeAlreadyExistsException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="app:/groovy/webui/component/admin/taxonomy/UITaxonomyTreeWizard.gtmpl", events={@EventConfig(listeners={RefreshActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UITaxonomyTreeContainer
extends UIContainer
implements UISelectable {
    private int selectedStep_ = 1;
    private int currentStep_ = 0;
    private TaxonomyTreeData taxonomyTreeData;
    public static final String POPUP_PERMISSION = "PopupTaxonomyTreePermission";
    public static final String POPUP_TAXONOMYHOMEPATH = "PopupTaxonomyJCRBrowser";
    private String[] actions_ = new String[]{"Cancel"};

    public UITaxonomyTreeContainer() throws Exception {
        this.addChild(UITaxonomyTreeMainForm.class, null, "TaxonomyTreeMainForm");
        ((UIPermissionTreeManager)this.addChild(UIPermissionTreeManager.class, null, "TaxonomyPermissionTree")).setRendered(false);
        ((UIActionTaxonomyManager)this.addChild(UIActionTaxonomyManager.class, null, null)).setRendered(false);
    }

    public String[] getActions() {
        return this.actions_;
    }

    public void setCurrentSep(int step) {
        this.currentStep_ = step;
    }

    public int getCurrentStep() {
        return this.currentStep_;
    }

    public void setSelectedStep(int step) {
        this.selectedStep_ = step;
    }

    public int getSelectedStep() {
        return this.selectedStep_;
    }

    public TaxonomyTreeData getTaxonomyTreeData() {
        return this.taxonomyTreeData;
    }

    public void setTaxonomyTreeData(TaxonomyTreeData taxonomyTreeData) {
        this.taxonomyTreeData = taxonomyTreeData;
    }

    public void viewStep(int step) {
        this.selectedStep_ = step;
        this.currentStep_ = step - 1;
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (i == this.getCurrentStep()) {
                ((UIComponent)children.get(i)).setRendered(true);
                continue;
            }
            ((UIComponent)children.get(i)).setRendered(false);
        }
    }

    public void refresh() throws Exception {
        if (this.taxonomyTreeData == null) {
            this.taxonomyTreeData = new TaxonomyTreeData();
        }
        this.taxonomyTreeData.setRepository(((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getConfiguration().getName());
        String taxoTreeName = this.taxonomyTreeData.getTaxoTreeName();
        UIActionTaxonomyManager uiActionTaxonomyManager = (UIActionTaxonomyManager)this.getChild(UIActionTaxonomyManager.class);
        UIActionTypeForm uiActionTypeForm = (UIActionTypeForm)uiActionTaxonomyManager.getChild(UIActionTypeForm.class);
        if (this.taxonomyTreeData.isEdit()) {
            this.removeChild(UITaxonomyTreeCreateChild.class);
            UITaxonomyTreeCreateChild uiTaxonomyCreateChild = (UITaxonomyTreeCreateChild)this.addChild(UITaxonomyTreeCreateChild.class, null, null);
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
            Node taxoTreeNode = taxonomyService.getTaxonomyTree(taxoTreeName, true);
            if (taxoTreeNode != null) {
                this.loadData(taxoTreeNode);
                Node actionNode = actionService.getAction(taxoTreeNode, this.taxonomyTreeData.getTaxoTreeActionName());
                uiActionTaxonomyManager.removeChild(UIActionForm.class);
                UIActionForm uiActionForm = (UIActionForm)uiActionTaxonomyManager.addChild(UIActionForm.class, null, null);
                uiActionTypeForm.setDefaultActionType(this.taxonomyTreeData.getTaxoTreeActionTypeName());
                uiActionForm.createNewAction(taxoTreeNode, this.taxonomyTreeData.getTaxoTreeActionTypeName(), true);
                uiActionForm.setWorkspace(this.taxonomyTreeData.getTaxoTreeWorkspace());
                uiActionForm.setNodePath(actionNode.getPath());
                if (uiTaxonomyCreateChild == null) {
                    uiTaxonomyCreateChild = (UITaxonomyTreeCreateChild)this.addChild(UITaxonomyTreeCreateChild.class, null, null);
                }
                uiTaxonomyCreateChild.setWorkspace(this.getTaxonomyTreeData().getTaxoTreeWorkspace());
                uiTaxonomyCreateChild.setTaxonomyTreeNode(taxoTreeNode);
                UIPermissionTreeInfo uiPermInfo = (UIPermissionTreeInfo)this.findFirstComponentOfType(UIPermissionTreeInfo.class);
                UIPermissionTreeForm uiPermForm = (UIPermissionTreeForm)this.findFirstComponentOfType(UIPermissionTreeForm.class);
                uiPermInfo.setCurrentNode(taxoTreeNode);
                uiPermForm.setCurrentNode(taxoTreeNode);
                uiPermInfo.updateGrid();
            }
        }
        uiActionTypeForm.setDefaultActionType(null);
        ((UITaxonomyTreeMainForm)this.findFirstComponentOfType(UITaxonomyTreeMainForm.class)).update(this.taxonomyTreeData);
    }

    private void loadData(Node taxoTreeTargetNode) throws RepositoryException, Exception {
        String taxoTreeName = this.taxonomyTreeData.getTaxoTreeName();
        if (taxoTreeName == null || taxoTreeName.length() == 0) {
            return;
        }
        if (taxoTreeTargetNode != null) {
            Node node;
            Session session = taxoTreeTargetNode.getSession();
            this.taxonomyTreeData.setTaxoTreeWorkspace(session.getWorkspace().getName());
            this.taxonomyTreeData.setTaxoTreeHomePath(taxoTreeTargetNode.getParent().getPath());
            this.taxonomyTreeData.setTaxoTreePermissions("");
            ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
            List lstActionNodes = actionService.getActions(taxoTreeTargetNode);
            if (lstActionNodes != null && lstActionNodes.size() > 0 && (node = (Node)lstActionNodes.get(0)) != null) {
                this.taxonomyTreeData.setTaxoTreeActionName(node.getName());
                this.taxonomyTreeData.setTaxoTreeActionTypeName(node.getPrimaryNodeType().getName());
            }
        }
    }

    private UIFormStringInput getFormInputById(String id) {
        return (UIFormStringInput)this.findComponentById(id);
    }

    public Session getSession(String workspace) throws RepositoryException {
        return WCMCoreUtils.getSystemSessionProvider().getSession(workspace, WCMCoreUtils.getRepository());
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.getFormInputById(selectField).setValue((Object)value.toString());
        UITaxonomyManagerTrees uiContainer = (UITaxonomyManagerTrees)this.getAncestorOfType(UITaxonomyManagerTrees.class);
        for (UIComponent uiChild : uiContainer.getChildren()) {
            if (!uiChild.getId().equals(POPUP_PERMISSION) && !uiChild.getId().equals(POPUP_TAXONOMYHOMEPATH)) continue;
            UIPopupWindow uiPopup = (UIPopupWindow)uiContainer.getChildById(uiChild.getId());
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
        }
    }

    public void addTaxonomyTree(String name, String workspace, String homePath, List<PermissionBean> permBeans) throws TaxonomyAlreadyExistsException, TaxonomyNodeAlreadyExistsException, AccessControlException, Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        taxonomyService.addTaxonomyNode(workspace, homePath, name, Util.getPortalRequestContext().getRemoteUser());
        Session session = this.getSession(workspace);
        Node homeNode = (Node)session.getItem(homePath);
        Node taxonomyTreeNode = homeNode.getNode(name);
        ExtendedNode node = (ExtendedNode)taxonomyTreeNode;
        if (permBeans != null && permBeans.size() > 0 && PermissionUtil.canChangePermission((Node)node)) {
            if (node.canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            if (node.isNodeType("exo:privilegeable")) {
                AccessControlList acl = node.getACL();
                List permissionEntries = acl.getPermissionEntries();
                String nodeOwner = Utils.getNodeOwner((Node)node);
                for (AccessControlEntry accessControlEntry : permissionEntries) {
                    String identity = accessControlEntry.getIdentity();
                    if (IdentityConstants.SYSTEM.equals(identity) || identity.equals(nodeOwner)) continue;
                    node.removePermission(identity);
                }
                node.setPermission(nodeOwner, PermissionType.ALL);
                if (PermissionUtil.canChangePermission((Node)node)) {
                    for (PermissionBean permBean : permBeans) {
                        ArrayList<String> permsList = new ArrayList<String>();
                        if (permBean.isRead()) {
                            permsList.add("read");
                        }
                        if (permBean.isAddNode()) {
                            permsList.add("add_node");
                        }
                        if (permBean.isRemove()) {
                            permsList.add("remove");
                        }
                        if (permsList.size() <= 0) continue;
                        node.setPermission(permBean.getUsersOrGroups(), permsList.toArray(new String[permsList.size()]));
                    }
                }
                node.save();
            }
        }
        homeNode.save();
        session.save();
        taxonomyService.addTaxonomyTree(taxonomyTreeNode);
    }

    public boolean updateTaxonomyTree(String name, String workspace, String homePath, String actionName) throws RepositoryException, AccessControlException, Exception {
        String repository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        Node taxonomyTreeNode = taxonomyService.getTaxonomyTree(name, true);
        Node homeNode = taxonomyTreeNode.getParent();
        String srcWorkspace = taxonomyTreeNode.getSession().getWorkspace().getName();
        Session session = this.getSession(workspace);
        Workspace objWorkspace = session.getWorkspace();
        if (homeNode.getPath().equals(homePath) && srcWorkspace.equals(workspace)) {
            return false;
        }
        ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        if (actionService.hasActions(taxonomyTreeNode)) {
            actionService.removeAction(taxonomyTreeNode, actionName, repository);
        }
        String destPath = homePath + "/" + name;
        destPath = destPath.replaceAll("/+", "/");
        if (srcWorkspace.equals(workspace)) {
            objWorkspace.move(taxonomyTreeNode.getPath(), destPath);
        } else {
            objWorkspace.copy(srcWorkspace, taxonomyTreeNode.getPath(), destPath);
            taxonomyTreeNode.remove();
            homeNode.save();
        }
        session.save();
        taxonomyTreeNode = (Node)session.getItem(destPath);
        taxonomyService.updateTaxonomyTree(name, taxonomyTreeNode);
        return true;
    }

    public static class CancelActionListener
    extends EventListener<UITaxonomyTreeContainer> {
        public void execute(Event<UITaxonomyTreeContainer> event) throws Exception {
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiTaxonomyTreeContainer.getParent();
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeContainer.getAncestorOfType(UITaxonomyManagerTrees.class);
            uiTaxonomyManagerTrees.removeChildById("AddTaxonomyTreePopup");
            uiTaxonomyManagerTrees.removeChildById("EditTaxonomyTreePopup");
            uiTaxonomyManagerTrees.update();
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    public static class RefreshActionListener
    extends EventListener<UITaxonomyTreeContainer> {
        public void execute(Event<UITaxonomyTreeContainer> event) throws Exception {
            ((UITaxonomyTreeContainer)((Object)event.getSource())).refresh();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)event.getSource());
        }
    }
}

