/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.exportimport;

import java.io.IOException;
import java.io.OutputStream;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.management.exportimport.AbstractExportTask;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationKey;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationUtils;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.gatein.management.api.binding.Marshaller;

public class NavigationExportTask
extends AbstractExportTask {
    public static final String FILE = "navigation.xml";
    private NavigationKey navigationKey;
    private Marshaller<PageNavigation> marshaller;
    private NavigationService navigationService;
    private DescriptionService descriptionService;
    private PageNavigation navigation;

    public NavigationExportTask(NavigationKey navigationKey, NavigationService navigationService, DescriptionService descriptionService, Marshaller<PageNavigation> marshaller) {
        super(navigationKey.getSiteKey());
        this.navigationKey = navigationKey;
        this.navigationService = navigationService;
        this.descriptionService = descriptionService;
        this.marshaller = marshaller;
    }

    public NavigationExportTask(PageNavigation navigation, Marshaller<PageNavigation> marshaller) {
        super(new SiteKey(navigation.getOwnerType(), navigation.getOwnerId()));
        this.navigation = navigation;
        this.marshaller = marshaller;
    }

    @Override
    protected String getXmlFileName() {
        return FILE;
    }

    public void export(OutputStream outputStream) throws IOException {
        if (this.navigation == null) {
            this.navigation = NavigationUtils.loadPageNavigation(this.navigationKey, this.navigationService, this.descriptionService);
        }
        this.marshaller.marshal((Object)this.navigation, outputStream, true);
    }
}

