/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.auth;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.social.core.oauth.OAuthAuthenticationHandler;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.opensocial.auth.ExoBlobCrypterSecurityToken;
import org.exoplatform.social.opensocial.auth.RestPortalContainerNameConfig;

public class ExoOAuthAuthenticationHandler
extends OAuthAuthenticationHandler {
    private static final Log LOG = ExoLogger.getLogger(ExoOAuthAuthenticationHandler.class);
    private String portalContainerName;

    @Inject
    public ExoOAuthAuthenticationHandler(OAuthDataStore store, @Named(value="shindig.oauth.legacy-body-signing") boolean allowLegacyBodySigning) {
        super(store, null);
    }

    public String getName() {
        return super.getName();
    }

    public String getPortalContainerName() {
        if (this.portalContainerName == null) {
            RestPortalContainerNameConfig containerNameConfigRest = (RestPortalContainerNameConfig)((Object)PortalContainer.getInstance().getComponentInstanceOfType(RestPortalContainerNameConfig.class));
            this.portalContainerName = containerNameConfigRest.getContainerName();
        }
        return this.portalContainerName;
    }

    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) throws AuthenticationHandler.InvalidAuthenticationException {
        String domain;
        String portalContainer;
        SecurityToken securityToken = super.getSecurityTokenFromRequest(request);
        try {
            String keyFile = this.getKeyFilePath();
            BasicBlobCrypter crypter = new BasicBlobCrypter(new File(keyFile));
            crypter.timeSource = new TimeSource();
            portalContainer = this.getPortalContainerName();
            domain = securityToken.getDomain();
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get security token from request", (Throwable)e);
            return null;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(AbstractSecurityToken.Keys.APP_URL.getKey(), securityToken.getAppUrl());
        values.put(AbstractSecurityToken.Keys.OWNER.getKey(), securityToken.getOwnerId());
        values.put(AbstractSecurityToken.Keys.VIEWER.getKey(), securityToken.getViewerId());
        values.put(AbstractSecurityToken.Keys.TRUSTED_JSON.getKey(), "trusted");
        ExoBlobCrypterSecurityToken crypterSecurityToken = new ExoBlobCrypterSecurityToken(portalContainer, domain, null, values);
        return crypterSecurityToken;
    }

    public String getWWWAuthenticateHeader(String realm) {
        return super.getWWWAuthenticateHeader(realm);
    }

    private String getKeyFilePath() {
        String keyPath = PropertyManager.getProperty((String)"gatein.gadgets.securitytokenkeyfile");
        File tokenKeyFile = null;
        if (keyPath == null) {
            LOG.warn((Object)"The gadgets token key is not configured. The default key.txt file in /bin will be used");
            tokenKeyFile = new File("key.txt");
        } else {
            tokenKeyFile = new File(keyPath);
        }
        return tokenKeyFile.getAbsolutePath();
    }
}

