/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFieldExtractor
extends AbstractField {
    private static final long serialVersionUID = -2707986404659820071L;
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.TextFieldExtractor");
    private final Reader reader;
    private volatile String extract;

    public TextFieldExtractor(String name, Reader reader, boolean store, boolean withOffsets) {
        super(name, store ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED, withOffsets ? Field.TermVector.WITH_OFFSETS : Field.TermVector.NO);
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValue() {
        if (this.extract == null) {
            TextFieldExtractor textFieldExtractor = this;
            synchronized (textFieldExtractor) {
                if (this.extract == null) {
                    StringBuilder textExtract = new StringBuilder();
                    char[] buffer = new char[1024];
                    try {
                        int len;
                        while ((len = this.reader.read(buffer)) > -1) {
                            textExtract.append(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        log.warn("Exception reading value for field: " + e.getMessage());
                        log.debug("Dump:", (Throwable)e);
                    }
                    finally {
                        try {
                            this.reader.close();
                        }
                        catch (IOException e) {
                            log.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    this.extract = textExtract.toString();
                }
            }
        }
        return this.extract;
    }

    public Reader readerValue() {
        return null;
    }

    public byte[] binaryValue() {
        return null;
    }

    public TokenStream tokenStreamValue() {
        return null;
    }

    public void dispose() throws IOException {
        this.reader.close();
    }
}

