/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.chromattic.api.ChromatticIOException;
import org.chromattic.api.Status;
import org.chromattic.common.CloneableInputStream;
import org.chromattic.common.jcr.Path;
import org.chromattic.core.ArrayType;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EntityContext;
import org.chromattic.core.EntityContextState;
import org.chromattic.core.EventBroadcaster;
import org.chromattic.core.MethodInvoker;
import org.chromattic.core.NameKind;
import org.chromattic.core.ThrowableFactory;
import org.chromattic.core.jcr.type.NodeTypeInfo;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.core.vt2.ValueDefinition;
import org.chromattic.spi.instrument.MethodHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectContext<O extends ObjectContext<O>>
implements MethodHandler {
    public abstract ObjectMapper<O> getMapper();

    public abstract Object getObject();

    public abstract EntityContext getEntity();

    public abstract NodeTypeInfo getTypeInfo();

    public abstract Status getStatus();

    public abstract DomainSession getSession();

    public final Object invoke(Object o, Method method) throws Throwable {
        MethodInvoker<ObjectContext> invoker = this.getMapper().getInvoker(method);
        if (invoker != null) {
            return invoker.invoke(this);
        }
        throw this.createCannotInvokeError(method, new Object[0]);
    }

    public final Object invoke(Object o, Method method, Object arg) throws Throwable {
        MethodInvoker<ObjectContext> invoker = this.getMapper().getInvoker(method);
        if (invoker != null) {
            return invoker.invoke(this, arg);
        }
        throw this.createCannotInvokeError(method, arg);
    }

    public final Object invoke(Object o, Method method, Object[] args) throws Throwable {
        MethodInvoker<ObjectContext> invoker = this.getMapper().getInvoker(method);
        if (invoker != null) {
            switch (args.length) {
                case 0: {
                    return invoker.invoke(this);
                }
                case 1: {
                    return invoker.invoke(this, args[0]);
                }
            }
            return invoker.invoke(this, args);
        }
        throw this.createCannotInvokeError(method, args);
    }

    private AssertionError createCannotInvokeError(Method method, Object ... args) {
        int i;
        StringBuilder msg = new StringBuilder("Cannot invoke method ").append(method.getName()).append("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                msg.append(',');
            }
            msg.append(parameterTypes[i].getName());
        }
        msg.append(") with arguments (");
        for (i = 0; i < args.length; ++i) {
            if (i > 0) {
                msg.append(',');
            }
            msg.append(String.valueOf(args[i]));
        }
        msg.append(")");
        return new AssertionError(msg);
    }

    public final <V> boolean hasProperty(String propertyName, ValueDefinition<?, V> type) throws RepositoryException {
        EntityContext ctx = this.getEntity();
        EntityContextState state = ctx.state;
        propertyName = state.getSession().domain.encodeName(ctx, propertyName, NameKind.PROPERTY);
        Path.validateName((String)propertyName);
        NodeTypeInfo typeInfo = this.getTypeInfo();
        return state.hasProperty(typeInfo, propertyName, type);
    }

    public final <V> V getPropertyValue(String propertyName, ValueDefinition<?, V> type) throws RepositoryException {
        EntityContext ctx = this.getEntity();
        EntityContextState state = ctx.state;
        propertyName = state.getSession().domain.encodeName(ctx, propertyName, NameKind.PROPERTY);
        Path.validateName((String)propertyName);
        NodeTypeInfo typeInfo = this.getTypeInfo();
        return state.getPropertyValue(typeInfo, propertyName, type);
    }

    public final <L, V> L getPropertyValues(String propertyName, ValueDefinition<?, V> simpleType, ArrayType<L, V> arrayType) throws RepositoryException {
        EntityContext ctx = this.getEntity();
        EntityContextState state = ctx.state;
        propertyName = state.getSession().domain.encodeName(ctx, propertyName, NameKind.PROPERTY);
        Path.validateName((String)propertyName);
        NodeTypeInfo typeInfo = this.getTypeInfo();
        return state.getPropertyValues(typeInfo, propertyName, simpleType, arrayType);
    }

    public final <V> void setPropertyValue(String propertyName, ValueDefinition<?, V> type, V o) throws RepositoryException {
        EntityContext ctx = this.getEntity();
        EntityContextState state = ctx.state;
        propertyName = state.getSession().domain.encodeName(ctx, propertyName, NameKind.PROPERTY);
        Path.validateName((String)propertyName);
        Object object = this.getObject();
        EventBroadcaster broadcaster = state.getSession().broadcaster;
        NodeTypeInfo typeInfo = this.getTypeInfo();
        if (o instanceof InputStream && broadcaster.hasStateChangeListeners()) {
            CloneableInputStream in;
            try {
                in = new CloneableInputStream((InputStream)o);
            }
            catch (IOException e) {
                throw new ChromatticIOException("Could not read stream", e);
            }
            CloneableInputStream v = in;
            state.setPropertyValue(typeInfo, propertyName, type, v);
            broadcaster.propertyChanged(state.getId(), object, propertyName, in.clone());
        } else {
            state.setPropertyValue(typeInfo, propertyName, type, o);
            broadcaster.propertyChanged(state.getId(), object, propertyName, o);
        }
    }

    public final <L, V> void setPropertyValues(String propertyName, ValueDefinition<?, V> type, ArrayType<L, V> arrayType, L propertyValues) throws RepositoryException {
        EntityContext ctx = this.getEntity();
        EntityContextState state = ctx.state;
        propertyName = state.getSession().domain.encodeName(ctx, propertyName, NameKind.PROPERTY);
        Path.validateName((String)propertyName);
        NodeTypeInfo typeInfo = this.getTypeInfo();
        state.setPropertyValues(typeInfo, propertyName, type, arrayType, propertyValues);
    }

    public final void removeChild(String prefix, String localName) {
        if (this.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException("Can only insert/remove a child of a persistent object");
        }
        this.getSession().removeChild(this, prefix, localName);
    }

    public final void orderBefore(EntityContext srcCtx, EntityContext dstCtx) {
        this.getSession().orderBefore(this, srcCtx, dstCtx);
    }

    public final <T1 extends Throwable, T2 extends Throwable> void addChild(ThrowableFactory<T1> thisStateTF, ThrowableFactory<T2> childStateTF, String prefix, EntityContext childCtx) throws T1, T2 {
        String localName = childCtx.getLocalName();
        this.addChild(thisStateTF, childStateTF, prefix, localName, childCtx);
    }

    public final <T1 extends Throwable, T2 extends Throwable> void addChild(ThrowableFactory<T1> thisStateTF, ThrowableFactory<T2> childStateTF, String prefix, String localName, EntityContext childCtx) throws T1, T2 {
        if (childCtx.getStatus() == Status.PERSISTENT) {
            this.getSession().move(childStateTF, thisStateTF, childCtx, this, prefix, localName);
        } else {
            this.getSession().persist(thisStateTF, childStateTF, ThrowableFactory.NPE, this, childCtx, prefix, localName);
        }
    }

    public final EntityContext getChild(String prefix, String localName) {
        return this.getSession().getChild(this, prefix, localName);
    }

    public final boolean hasChild(String prefix, String localName) {
        return this.getSession().hasChild(this, prefix, localName);
    }

    public final <T> Iterator<T> getChildren(Class<T> filterClass) {
        return this.getSession().getChildren(this, filterClass);
    }
}

