/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.WorkingDocument;

public final class SnuggleInputReader
implements WorkingDocument.SourceContext {
    private final SessionContext sessionContext;
    private final SnuggleInput input;
    private int[] newlineIndices = null;
    private int inputLength;
    private WorkingDocument resultingDocument = null;

    public SnuggleInputReader(SessionContext sessionContext, SnuggleInput input) {
        this.sessionContext = sessionContext;
        this.input = input;
    }

    public SnuggleInput getInput() {
        return this.input;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public WorkingDocument createWorkingDocument() throws IOException, SnuggleParseException {
        StringBuilder inputData = this.readInputData();
        this.inputLength = inputData.length();
        this.newlineIndices = this.calculateNewlineIndicesAndCheckASCII(inputData);
        this.resultingDocument = new WorkingDocument(inputData, this);
        return this.resultingDocument;
    }

    public int[] getLineAndColumn(int index) {
        int line;
        if (this.newlineIndices == null) {
            throw new IllegalStateException("Input has not yet been read");
        }
        if (index < 0 || index > this.inputLength) {
            throw new IndexOutOfBoundsException();
        }
        for (line = 0; line < this.newlineIndices.length && this.newlineIndices[line] < index; ++line) {
        }
        int column = index - this.newlineIndices[line - 1];
        return new int[]{line, column};
    }

    private StringBuilder readInputData() throws IOException {
        switch (this.input.getType()) {
            case STRING: {
                return new StringBuilder(this.input.getString());
            }
            case FILE: {
                return this.readCharacterStream(new InputStreamReader(new FileInputStream(this.input.getFile())));
            }
            case INPUT_STREAM: {
                return this.readCharacterStream(new InputStreamReader(this.input.getInputStream()));
            }
            case READER: {
                return this.readCharacterStream(this.input.getReader());
            }
        }
        throw new SnuggleLogicException("Unexpected switch case: " + (Object)((Object)this.input.getType()));
    }

    private StringBuilder readCharacterStream(Reader reader) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        int size = 0;
        StringBuilder result = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            size += line.length() + 1;
            result.append(line).append("\n");
        }
        bufferedReader.close();
        return result;
    }

    private int[] calculateNewlineIndicesAndCheckASCII(StringBuilder inputData) throws SnuggleParseException {
        ArrayList<Integer> newlineIndicesBuilder = new ArrayList<Integer>();
        newlineIndicesBuilder.add(-1);
        int length = inputData.length();
        for (int i = 0; i < length; ++i) {
            char c = inputData.charAt(i);
            if (c == '\n') {
                newlineIndicesBuilder.add(i);
            }
            if ((c >= ' ' || Character.isWhitespace((int)c)) && c <= '~') continue;
            InputError error = new InputError(ErrorCode.TTEG02, null, Character.toString(c), Integer.toHexString(c), i);
            this.sessionContext.registerError(error);
            inputData.setCharAt(i, 'x');
        }
        int[] calculatedNewlineIndices = new int[newlineIndicesBuilder.size()];
        for (int i = 0; i < calculatedNewlineIndices.length; ++i) {
            calculatedNewlineIndices[i] = (Integer)newlineIndicesBuilder.get(i);
        }
        return calculatedNewlineIndices;
    }
}

