/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.UIBannerUploader;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceMenu;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.input.UIUploadInput;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/UIBannerAvatarUploader.gtmpl", events={@EventConfig(listeners={ConfirmActionListener.class})})})
public class UIBannerAvatarUploader
extends UIBannerUploader {
    protected static final String FIELD_UPLOADER = "BannerAvatarUploader";
    private boolean renderUpload = false;

    public UIBannerAvatarUploader() {
        super(FIELD_UPLOADER);
    }

    public void setRenderUpload(boolean renderUpload) {
        this.renderUpload = renderUpload;
    }

    public boolean isRenderUpload() {
        return this.renderUpload;
    }

    public void saveSpaceAvatar(Space space, AvatarAttachment avatarAttachment) throws Exception {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        space.setAvatarAttachment(avatarAttachment);
        space.setEditor(Utils.getViewerRemoteId());
        spaceService.updateSpace(space);
        spaceService.updateSpaceAvatar(space);
    }

    public void saveUserAvatar(AvatarAttachment avatarAttachment) throws Exception {
        Profile p = Utils.getOwnerIdentity().getProfile();
        p.setProperty("avatar", (Object)avatarAttachment);
        p.setListUpdateTypes(Arrays.asList(Profile.UpdateType.AVATAR));
        Map props = p.getProperties();
        for (String key : props.keySet()) {
            if (!key.startsWith("avatar_")) continue;
            p.removeProperty(key);
        }
        Utils.getIdentityManager().updateProfile(p);
    }

    public static class ConfirmActionListener
    extends EventListener<UIBannerAvatarUploader> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIBannerAvatarUploader> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIBannerAvatarUploader uiBannerAvatarUploader = (UIBannerAvatarUploader)((Object)event.getSource());
            UIUploadInput uiBannerUploadInput = (UIUploadInput)uiBannerAvatarUploader.getChild(UIUploadInput.class);
            if (uiBannerUploadInput.getUploadResources().length < 1) {
                ctx.getUIApplication().addMessage(new ApplicationMessage("UIBannerUploader.msg.img_not_loaded", null, 0));
                ctx.addUIComponentToUpdateByAjax((UIComponent)uiBannerAvatarUploader);
            }
            for (UploadResource uploadResource : uiBannerUploadInput.getUploadResources()) {
                if (uploadResource == null) continue;
                try {
                    String fileName = uploadResource.getFileName();
                    if (fileName == null || fileName.length() == 0) continue;
                    String mimeType = uploadResource.getMimeType();
                    FileInputStream uploadedStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
                    AvatarAttachment avatarAttachment = ImageUtils.createResizedAvatarAttachment((InputStream)uploadedStream, (int)200, (int)200, null, (String)fileName, (String)mimeType, null);
                    if (avatarAttachment == null) {
                        avatarAttachment = new AvatarAttachment(null, fileName, mimeType, (InputStream)uploadedStream, null, System.currentTimeMillis());
                    }
                    if (!uiBannerAvatarUploader.isAcceptedMimeType(mimeType)) {
                        ctx.getUIApplication().addMessage(new ApplicationMessage("UIBannerUploader.msg.mimetype_not_accepted", null, 0));
                        ctx.addUIComponentToUpdateByAjax((UIComponent)uiBannerAvatarUploader);
                    } else {
                        if (uiBannerAvatarUploader.getAncestorOfType(UISpaceMenu.class) != null) {
                            String spaceUrl = Utils.getSpaceUrlByContext();
                            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
                            Space space = spaceService.getSpaceByUrl(spaceUrl);
                            if (space != null) {
                                uiBannerAvatarUploader.saveSpaceAvatar(space, avatarAttachment);
                            }
                        } else {
                            uiBannerAvatarUploader.saveUserAvatar(avatarAttachment);
                        }
                        ctx.addUIComponentToUpdateByAjax(uiBannerAvatarUploader.getParent());
                    }
                    return;
                }
                finally {
                    UploadService uploadService = (UploadService)CommonsUtils.getService(UploadService.class);
                    uploadService.removeUploadResource(uploadResource.getUploadId());
                    uiBannerUploadInput.addNewUploadId();
                }
            }
        }
    }
}

