/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckDebuggerStatement;
import com.google.javascript.jscomp.CheckEventfulObjectDisposal;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckProvides;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckRequiresForConstructors;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuspiciousCode;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.ControlStructureCheck;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableReferenceCheck;
import java.util.Map;

public class DiagnosticGroups {
    static final DiagnosticType UNUSED = DiagnosticType.warning("JSC_UNUSED", "{0}");
    private static final Map<String, DiagnosticGroup> groupsByName = Maps.newHashMap();
    static final String DIAGNOSTIC_GROUP_NAMES = "accessControls, ambiguousFunctionDecl, checkEventfulObjectDisposal, checkRegExp, checkStructDictInheritance, checkTypes, checkVars, const, constantProperty, deprecated, duplicateMessage, es3, es5Strict, externsValidation, fileoverviewTags, globalThis, internetExplorerChecks, invalidCasts, misplacedTypeAnnotation, missingProperties, missingProvide, missingRequire, missingReturn,nonStandardJsDocs, reportUnknownTypes, suspiciousCode, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, uselessCode, visibility";
    public static final DiagnosticGroup GLOBAL_THIS = DiagnosticGroups.registerGroup("globalThis", CheckGlobalThis.GLOBAL_THIS);
    public static final DiagnosticGroup DEPRECATED = DiagnosticGroups.registerGroup("deprecated", CheckAccessControls.DEPRECATED_NAME, CheckAccessControls.DEPRECATED_NAME_REASON, CheckAccessControls.DEPRECATED_PROP, CheckAccessControls.DEPRECATED_PROP_REASON, CheckAccessControls.DEPRECATED_CLASS, CheckAccessControls.DEPRECATED_CLASS_REASON);
    public static final DiagnosticGroup VISIBILITY = DiagnosticGroups.registerGroup("visibility", CheckAccessControls.BAD_PRIVATE_GLOBAL_ACCESS, CheckAccessControls.BAD_PRIVATE_PROPERTY_ACCESS, CheckAccessControls.BAD_PROTECTED_PROPERTY_ACCESS, CheckAccessControls.PRIVATE_OVERRIDE, CheckAccessControls.VISIBILITY_MISMATCH);
    public static final DiagnosticGroup ACCESS_CONTROLS = DiagnosticGroups.registerGroup("accessControls", DEPRECATED, VISIBILITY);
    public static final DiagnosticGroup NON_STANDARD_JSDOC = DiagnosticGroups.registerGroup("nonStandardJsDocs", RhinoErrorReporter.BAD_JSDOC_ANNOTATION);
    public static final DiagnosticGroup INVALID_CASTS = DiagnosticGroups.registerGroup("invalidCasts", TypeValidator.INVALID_CAST);
    public static final DiagnosticGroup FILEOVERVIEW_JSDOC = DiagnosticGroups.registerDeprecatedGroup("fileoverviewTags");
    public static final DiagnosticGroup STRICT_MODULE_DEP_CHECK = DiagnosticGroups.registerGroup("strictModuleDepCheck", VarCheck.STRICT_MODULE_DEP_ERROR, CheckGlobalNames.STRICT_MODULE_DEP_QNAME);
    public static final DiagnosticGroup VIOLATED_MODULE_DEP = DiagnosticGroups.registerGroup("violatedModuleDep", VarCheck.VIOLATED_MODULE_DEP_ERROR);
    public static final DiagnosticGroup EXTERNS_VALIDATION = DiagnosticGroups.registerGroup("externsValidation", VarCheck.NAME_REFERENCE_IN_EXTERNS_ERROR, VarCheck.UNDEFINED_EXTERN_VAR_ERROR);
    public static final DiagnosticGroup AMBIGUOUS_FUNCTION_DECL = DiagnosticGroups.registerGroup("ambiguousFunctionDecl", VariableReferenceCheck.AMBIGUOUS_FUNCTION_DECL, StrictModeCheck.BAD_FUNCTION_DECLARATION);
    public static final DiagnosticGroup UNKNOWN_DEFINES = DiagnosticGroups.registerGroup("unknownDefines", ProcessDefines.UNKNOWN_DEFINE_WARNING);
    public static final DiagnosticGroup TWEAKS = DiagnosticGroups.registerGroup("tweakValidation", ProcessTweaks.INVALID_TWEAK_DEFAULT_VALUE_WARNING, ProcessTweaks.TWEAK_WRONG_GETTER_TYPE_WARNING, ProcessTweaks.UNKNOWN_TWEAK_WARNING);
    public static final DiagnosticGroup MISSING_PROPERTIES = DiagnosticGroups.registerGroup("missingProperties", TypeCheck.INEXISTENT_PROPERTY_WITH_SUGGESTION);
    public static final DiagnosticGroup MISSING_RETURN = DiagnosticGroups.registerGroup("missingReturn", CheckMissingReturn.MISSING_RETURN_STATEMENT);
    public static final DiagnosticGroup INTERNET_EXPLORER_CHECKS = DiagnosticGroups.registerGroup("internetExplorerChecks", RhinoErrorReporter.TRAILING_COMMA);
    public static final DiagnosticGroup UNDEFINED_VARIABLES = DiagnosticGroups.registerGroup("undefinedVars", VarCheck.UNDEFINED_VAR_ERROR);
    public static final DiagnosticGroup UNDEFINED_NAMES = DiagnosticGroups.registerGroup("undefinedNames", CheckGlobalNames.UNDEFINED_NAME_WARNING);
    public static final DiagnosticGroup DEBUGGER_STATEMENT_PRESENT = DiagnosticGroups.registerGroup("checkDebuggerStatement", CheckDebuggerStatement.DEBUGGER_STATEMENT_PRESENT);
    public static final DiagnosticGroup CHECK_REGEXP = DiagnosticGroups.registerGroup("checkRegExp", CheckRegExp.REGEXP_REFERENCE, CheckRegExp.MALFORMED_REGEXP);
    public static final DiagnosticGroup CHECK_TYPES = DiagnosticGroups.registerGroup("checkTypes", TypeValidator.ALL_DIAGNOSTICS, TypeCheck.ALL_DIAGNOSTICS);
    public static final DiagnosticGroup CHECK_EVENTFUL_OBJECT_DISPOSAL = DiagnosticGroups.registerGroup("checkEventfulObjectDisposal", CheckEventfulObjectDisposal.EVENTFUL_OBJECT_NOT_DISPOSED, CheckEventfulObjectDisposal.EVENTFUL_OBJECT_PURELY_LOCAL, CheckEventfulObjectDisposal.OVERWRITE_PRIVATE_EVENTFUL_OBJECT, CheckEventfulObjectDisposal.UNLISTEN_WITH_ANONBOUND);
    public static final DiagnosticGroup REPORT_UNKNOWN_TYPES = DiagnosticGroups.registerGroup("reportUnknownTypes", TypeCheck.UNKNOWN_EXPR_TYPE);
    public static final DiagnosticGroup CHECK_STRUCT_DICT_INHERITANCE = DiagnosticGroups.registerGroup("checkStructDictInheritance", TypeCheck.CONFLICTING_SHAPE_TYPE);
    public static final DiagnosticGroup CHECK_VARIABLES = DiagnosticGroups.registerGroup("checkVars", VarCheck.UNDEFINED_VAR_ERROR, VarCheck.VAR_MULTIPLY_DECLARED_ERROR, VariableReferenceCheck.UNDECLARED_REFERENCE, VariableReferenceCheck.REDECLARED_VARIABLE);
    public static final DiagnosticGroup CHECK_USELESS_CODE = DiagnosticGroups.registerGroup("uselessCode", CheckSideEffects.USELESS_CODE_ERROR, CheckUnreachableCode.UNREACHABLE_CODE);
    public static final DiagnosticGroup CONST = DiagnosticGroups.registerGroup("const", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE, ConstCheck.CONST_REASSIGNED_VALUE_ERROR);
    public static final DiagnosticGroup CONSTANT_PROPERTY = DiagnosticGroups.registerGroup("constantProperty", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE);
    public static final DiagnosticGroup TYPE_INVALIDATION = DiagnosticGroups.registerGroup("typeInvalidation", DisambiguateProperties.Warnings.INVALIDATION, DisambiguateProperties.Warnings.INVALIDATION_ON_TYPE);
    public static final DiagnosticGroup DUPLICATE_VARS = DiagnosticGroups.registerGroup("duplicate", VarCheck.VAR_MULTIPLY_DECLARED_ERROR, TypeValidator.DUP_VAR_DECLARATION, VariableReferenceCheck.REDECLARED_VARIABLE);
    public static final DiagnosticGroup ES3 = DiagnosticGroups.registerGroup("es3", RhinoErrorReporter.INVALID_ES3_PROP_NAME, RhinoErrorReporter.TRAILING_COMMA);
    public static final DiagnosticGroup ES5_STRICT = DiagnosticGroups.registerGroup("es5Strict", ControlStructureCheck.USE_OF_WITH, StrictModeCheck.UNKNOWN_VARIABLE, StrictModeCheck.EVAL_DECLARATION, StrictModeCheck.EVAL_ASSIGNMENT, StrictModeCheck.ARGUMENTS_DECLARATION, StrictModeCheck.ARGUMENTS_ASSIGNMENT, StrictModeCheck.DELETE_VARIABLE, StrictModeCheck.DUPLICATE_OBJECT_KEY, StrictModeCheck.BAD_FUNCTION_DECLARATION);
    public static final DiagnosticGroup CHECK_PROVIDES = DiagnosticGroups.registerGroup("checkProvides", CheckProvides.MISSING_PROVIDE_WARNING);
    public static final DiagnosticGroup MISSING_PROVIDE = DiagnosticGroups.registerGroup("missingProvide", CheckProvides.MISSING_PROVIDE_WARNING);
    public static final DiagnosticGroup MISSING_REQUIRE = DiagnosticGroups.registerGroup("missingRequire", CheckRequiresForConstructors.MISSING_REQUIRE_WARNING);
    public static final DiagnosticGroup DUPLICATE_MESSAGE = DiagnosticGroups.registerGroup("duplicateMessage", JsMessageVisitor.MESSAGE_DUPLICATE_KEY);
    public static final DiagnosticGroup MISPLACED_TYPE_ANNOTATION = DiagnosticGroups.registerGroup("misplacedTypeAnnotation", RhinoErrorReporter.MISPLACED_TYPE_ANNOTATION);
    public static final DiagnosticGroup SUSPICIOUS_CODE = DiagnosticGroups.registerGroup("suspiciousCode", CheckSuspiciousCode.SUSPICIOUS_SEMICOLON, CheckSuspiciousCode.SUSPICIOUS_COMPARISON_WITH_NAN, CheckSuspiciousCode.SUSPICIOUS_IN_OPERATOR);

    static DiagnosticGroup registerDeprecatedGroup(String name) {
        return DiagnosticGroups.registerGroup(name, new DiagnosticGroup(name, UNUSED));
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticGroup group) {
        groupsByName.put(name, group);
        return group;
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticType ... types) {
        DiagnosticGroup group = new DiagnosticGroup(name, types);
        groupsByName.put(name, group);
        return group;
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticGroup ... groups) {
        DiagnosticGroup group = new DiagnosticGroup(name, groups);
        groupsByName.put(name, group);
        return group;
    }

    protected Map<String, DiagnosticGroup> getRegisteredGroups() {
        return ImmutableMap.copyOf(groupsByName);
    }

    public DiagnosticGroup forName(String name) {
        return groupsByName.get(name);
    }

    void setWarningLevel(CompilerOptions options, String name, CheckLevel level) {
        DiagnosticGroup group = this.forName(name);
        Preconditions.checkNotNull((Object)group, (String)"No warning class for name: %s", (Object[])new Object[]{name});
        options.setWarningLevel(group, level);
    }
}

