/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;

class InstrumentMemoryAllocPass
implements CompilerPass {
    final AbstractCompiler compiler;
    private static int newSiteId = 1;
    static final String JS_INSTRUMENT_ALLOCATION_CODE = "var __allocStats; \nvar __alloc = function(obj, sourcePosition, id, typeName) { \n  if (!__allocStats) { \n    __allocStats = { \n      reset: function() { \n        this.counts = [{ type:typeName, line:'total', count:0 }]; \n      }, \n      report: function(opt_n) { \n        this.counts.filter(function(x) { \n          return x; \n        }).sort(function(a, b) { \n          return b.count - a.count; \n        }).splice(0, opt_n || 50).reverse().forEach(function (x) { \n          if (window.console) { \n            window.console.log(x.count + ' (' + x.type + ') : ' + x.line); \n          } \n        }); \n      } \n    }; \n    __allocStats.reset(); \n    if (window.parent) { \n      window.parent['__allocStats'] = __allocStats; \n    } \n  } \n  if (!__allocStats.counts[id]) { \n    __allocStats.counts[id] = { type:typeName, line:sourcePosition, count:0 }; \n  } \n  __allocStats.counts[0].count++; \n  __allocStats.counts[id].count++; \n  return obj;\n}; \n";

    public InstrumentMemoryAllocPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private Node getInstrumentAllocationCode() {
        return this.compiler.parseSyntheticCode(JS_INSTRUMENT_ALLOCATION_CODE);
    }

    @Override
    public void process(Node externsNode, Node rootNode) {
        if (rootNode.hasChildren()) {
            NodeTraversal.traverse(this.compiler, rootNode, new Traversal());
            NodeTraversal.traverse(this.compiler, rootNode, new PrepareAst.PrepareAnnotations());
            Node firstScript = rootNode.getFirstChild();
            Preconditions.checkState((boolean)firstScript.isScript());
            this.compiler.getNodeForCodeInsertion(null).addChildrenToFront(this.getInstrumentAllocationCode().removeChildren());
            this.compiler.reportCodeChange();
        }
    }

    private Node getTypeString(Node currentNode) {
        if (currentNode.getType() == 30) {
            JSType type = currentNode.getFirstChild().getJSType();
            String typeName = type != null ? type.getDisplayName() : "Unknown";
            return IR.string("new " + typeName);
        }
        return currentNode.getType() == 63 ? IR.string("Array") : (currentNode.getType() == 64 ? IR.string("Object") : (currentNode.getType() == 105 ? IR.string("Function") : IR.string("Unknown")));
    }

    private class Traversal
    extends NodeTraversal.AbstractPostOrderCallback {
        private Traversal() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isNew() || n.getType() == 63 || n.getType() == 64 || NodeUtil.isFunctionExpression(n)) {
                Node instrumentAllocation = IR.call(IR.name("__alloc"), n.cloneTree(), IR.string(n.getSourceFileName() + ":" + n.getLineno()), IR.number(newSiteId++), InstrumentMemoryAllocPass.this.getTypeString(n));
                parent.replaceChild(n, instrumentAllocation);
            }
        }
    }
}

