/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PropertyMap;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Collections;

class ProxyObjectType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private JSType referencedType;
    private ObjectType referencedObjType;

    ProxyObjectType(JSTypeRegistry registry, JSType referencedType) {
        this(registry, referencedType, null);
    }

    ProxyObjectType(JSTypeRegistry registry, JSType referencedType, TemplateTypeMap templateTypeMap) {
        super(registry, templateTypeMap);
        this.setReferencedType(referencedType);
    }

    @Override
    PropertyMap getPropertyMap() {
        return this.referencedObjType == null ? PropertyMap.immutableEmptyMap() : this.referencedObjType.getPropertyMap();
    }

    JSType getReferencedTypeInternal() {
        return this.referencedType;
    }

    ObjectType getReferencedObjTypeInternal() {
        return this.referencedObjType;
    }

    void setReferencedType(JSType referencedType) {
        this.referencedType = referencedType;
        this.referencedObjType = referencedType instanceof ObjectType ? (ObjectType)referencedType : null;
    }

    @Override
    public String getReferenceName() {
        return this.referencedObjType == null ? "" : this.referencedObjType.getReferenceName();
    }

    @Override
    public boolean hasReferenceName() {
        return this.referencedObjType == null ? null : Boolean.valueOf(this.referencedObjType.hasReferenceName());
    }

    @Override
    public boolean matchesNumberContext() {
        return this.referencedType.matchesNumberContext();
    }

    @Override
    public boolean matchesStringContext() {
        return this.referencedType.matchesStringContext();
    }

    @Override
    public boolean matchesObjectContext() {
        return this.referencedType.matchesObjectContext();
    }

    @Override
    public boolean canBeCalled() {
        return this.referencedType.canBeCalled();
    }

    @Override
    public boolean isNoType() {
        return this.referencedType.isNoType();
    }

    @Override
    public boolean isNoObjectType() {
        return this.referencedType.isNoObjectType();
    }

    @Override
    public boolean isNoResolvedType() {
        return this.referencedType.isNoResolvedType();
    }

    @Override
    public boolean isUnknownType() {
        return this.referencedType.isUnknownType();
    }

    @Override
    public boolean isCheckedUnknownType() {
        return this.referencedType.isCheckedUnknownType();
    }

    @Override
    public boolean isNullable() {
        return this.referencedType.isNullable();
    }

    @Override
    public EnumType toMaybeEnumType() {
        return this.referencedType.toMaybeEnumType();
    }

    @Override
    public boolean isConstructor() {
        return this.referencedType.isConstructor();
    }

    @Override
    public boolean isNominalType() {
        return this.referencedType.isNominalType();
    }

    @Override
    public boolean isInstanceType() {
        return this.referencedType.isInstanceType();
    }

    @Override
    public boolean isInterface() {
        return this.referencedType.isInterface();
    }

    @Override
    public boolean isOrdinaryFunction() {
        return this.referencedType.isOrdinaryFunction();
    }

    @Override
    public boolean isAllType() {
        return this.referencedType.isAllType();
    }

    @Override
    public boolean isStruct() {
        return this.referencedType.isStruct();
    }

    @Override
    public boolean isDict() {
        return this.referencedType.isDict();
    }

    @Override
    public boolean isNativeObjectType() {
        return this.referencedObjType == null ? false : this.referencedObjType.isNativeObjectType();
    }

    @Override
    RecordType toMaybeRecordType() {
        return this.referencedType.toMaybeRecordType();
    }

    @Override
    public UnionType toMaybeUnionType() {
        return this.referencedType.toMaybeUnionType();
    }

    @Override
    public FunctionType toMaybeFunctionType() {
        return this.referencedType.toMaybeFunctionType();
    }

    @Override
    public EnumElementType toMaybeEnumElementType() {
        return this.referencedType.toMaybeEnumElementType();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        return this.referencedType.testForEquality(that);
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.referencedType.isSubtype(that);
    }

    @Override
    public FunctionType getOwnerFunction() {
        return this.referencedObjType == null ? null : this.referencedObjType.getOwnerFunction();
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.referencedObjType == null ? Collections.emptyList() : this.referencedObjType.getCtorImplementedInterfaces();
    }

    @Override
    public int hashCode() {
        return this.referencedType.hashCode();
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        return this.referencedType.toStringHelper(forAnnotations);
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.referencedObjType == null ? null : this.referencedObjType.getImplicitPrototype();
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        return this.referencedObjType == null ? true : this.referencedObjType.defineProperty(propertyName, type, inferred, propertyNode);
    }

    @Override
    public boolean removeProperty(String name) {
        return this.referencedObjType == null ? false : this.referencedObjType.removeProperty(name);
    }

    @Override
    public JSType findPropertyType(String propertyName) {
        return this.referencedType.findPropertyType(propertyName);
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        return this.referencedType.getJSDocInfo();
    }

    @Override
    public void setJSDocInfo(JSDocInfo info) {
        if (this.referencedObjType != null) {
            this.referencedObjType.setJSDocInfo(info);
        }
    }

    @Override
    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
        if (this.referencedObjType != null) {
            this.referencedObjType.setPropertyJSDocInfo(propertyName, info);
        }
    }

    @Override
    public FunctionType getConstructor() {
        return this.referencedObjType == null ? null : this.referencedObjType.getConstructor();
    }

    @Override
    public ImmutableList<JSType> getTemplateTypes() {
        return this.referencedObjType == null ? null : this.referencedObjType.getTemplateTypes();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return this.referencedType.visit(visitor);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return this.referencedType.visit(visitor, that);
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        this.setReferencedType(this.referencedType.resolve(t, scope));
        return this;
    }

    @Override
    public String toDebugHashCodeString() {
        return "{proxy:" + this.referencedType.toDebugHashCodeString() + "}";
    }

    @Override
    public JSType getTypeOfThis() {
        if (this.referencedObjType != null) {
            return this.referencedObjType.getTypeOfThis();
        }
        return super.getTypeOfThis();
    }

    @Override
    public JSType collapseUnion() {
        if (this.referencedType.isUnionType()) {
            return this.referencedType.collapseUnion();
        }
        return this;
    }

    @Override
    public void matchConstraint(JSType constraint) {
        this.referencedType.matchConstraint(constraint);
    }

    @Override
    public TemplatizedType toMaybeTemplatizedType() {
        return this.referencedType.toMaybeTemplatizedType();
    }

    @Override
    public TemplateType toMaybeTemplateType() {
        return this.referencedType.toMaybeTemplateType();
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return this.referencedType.hasAnyTemplateTypes();
    }

    @Override
    public TemplateTypeMap getTemplateTypeMap() {
        return this.referencedType.getTemplateTypeMap();
    }
}

